/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.HeapWalker;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.v2.SnapshotsWindow;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class HeapWalkerManager {
    private Set dumpsBeingDeleted = new HashSet();
    private List<HeapWalker> heapWalkers = new ArrayList<HeapWalker>();
    private final RequestProcessor heapwalkerRp = new RequestProcessor(HeapWalkerManager.class);

    private HeapWalkerManager() {
    }

    public static HeapWalkerManager getDefault() {
        return Singleton.INSTANCE;
    }

    public boolean isHeapWalkerOpened(File file) {
        return this.getHeapWalker(file, 0) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllHeapWalkers() {
        HeapWalker[] heapWalkerArray = this;
        synchronized (this) {
            HeapWalker[] heapWalkerArr = this.heapWalkers.toArray(new HeapWalker[0]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (HeapWalker hw : heapWalkerArr) {
                this.closeHeapWalker(hw);
            }
            return;
        }
    }

    public void closeHeapWalker(final HeapWalker hw) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopComponent tc = HeapWalkerManager.this.getTopComponent(hw);
                if (tc == null) {
                    ErrorManager.getDefault().log("Cannot resolve TopComponent for HeapWalker [" + hw.getHeapDumpFile() + "]");
                    return;
                }
                tc.close();
                FileObject folder = FileUtil.toFileObject((File)hw.getHeapDumpFile().getParentFile());
                SnapshotsWindow.instance().refreshFolder(folder, false);
            }
        });
    }

    public void deleteHeapDump(File file) {
        HeapWalker hw = this.getHeapWalker(file, 0);
        if (hw != null) {
            this.dumpsBeingDeleted.add(file);
            this.closeHeapWalker(hw);
        } else {
            this.deleteHeapDumpImpl(file, 15);
        }
    }

    public synchronized void heapWalkerClosed(HeapWalker hw) {
        TopComponent tc = this.getTopComponent(hw);
        if (tc == null) {
            return;
        }
        final File file = hw.getHeapDumpFile();
        this.heapWalkers.remove(hw);
        if (this.dumpsBeingDeleted.remove(file)) {
            BrowserUtils.performTask(new Runnable(){

                @Override
                public void run() {
                    HeapWalkerManager.this.deleteHeapDumpImpl(file, 15);
                }
            });
        }
    }

    public void openHeapWalker(File heapDump) {
        this.openHeapWalker(heapDump, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openHeapWalker(File heapDump, int segment) {
        String heapDumpPath;
        try {
            heapDumpPath = heapDump.getCanonicalPath();
        }
        catch (IOException ex) {
            ProfilerDialogs.displayError((String)Bundle.HeapWalkerManager_CannotOpenHeapWalkerMsg(), null, (String)ex.getLocalizedMessage());
            return;
        }
        String string = heapDumpPath.intern();
        synchronized (string) {
            HeapWalker hw = this.getHeapWalker(heapDump, segment);
            if (hw == null) {
                try {
                    hw = new HeapWalker(heapDump, segment);
                }
                catch (IOException e) {
                    ProfilerDialogs.displayError((String)Bundle.HeapWalkerManager_CannotOpenHeapWalkerMsg(), null, (String)e.getLocalizedMessage());
                }
                catch (Exception e) {
                    Logger.getLogger(HeapWalkerManager.class.getName()).log(Level.SEVERE, null, e);
                }
            }
            if (hw != null) {
                this.openHeapWalker(hw);
            } else {
                ProfilerLogger.severe((String)("Cannot create HeapWalker [" + heapDump + "]"));
            }
        }
    }

    public synchronized void openHeapWalker(final HeapWalker hw) {
        if (!this.heapWalkers.contains(hw)) {
            this.heapWalkers.add(hw);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopComponent tc = HeapWalkerManager.this.getTopComponent(hw);
                if (tc == null) {
                    ProfilerLogger.severe((String)("Cannot resolve TopComponent for HeapWalker [" + hw.getHeapDumpFile() + "]"));
                    return;
                }
                tc.open();
                tc.requestVisible();
                FileObject folder = FileUtil.toFileObject((File)hw.getHeapDumpFile().getParentFile());
                SnapshotsWindow.instance().refreshFolder(folder, false);
            }
        });
    }

    public void openHeapWalkers(File[] heapDumps) {
        for (File heapDump : heapDumps) {
            this.openHeapWalker(heapDump);
        }
    }

    private synchronized HeapWalker getHeapWalker(File heapDump, int segment) {
        for (HeapWalker hw : this.heapWalkers) {
            if (!hw.getHeapDumpFile().equals(heapDump) || hw.getHeapDumpSegment() != segment) continue;
            return hw;
        }
        return null;
    }

    private TopComponent getTopComponent(HeapWalker hw) {
        assert (SwingUtilities.isEventDispatchThread());
        return hw.getTopComponent();
    }

    private void deleteHeapDumpImpl(final File file, final int retries) {
        this.heapwalkerRp.post(new Runnable(){

            @Override
            public void run() {
                if (!file.delete()) {
                    if (retries > 0 && Platform.isWindows()) {
                        System.gc();
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        HeapWalkerManager.this.deleteHeapDumpImpl(file, retries - 1);
                    } else {
                        ProfilerDialogs.displayError((String)Bundle.HeapWalkerManager_CannotDeleteHeapDumpMsg());
                    }
                } else {
                    FileObject folder = FileUtil.toFileObject((File)file.getParentFile());
                    SnapshotsWindow.instance().refreshFolder(folder, true);
                }
            }
        });
    }

    private static class Singleton {
        private static final HeapWalkerManager INSTANCE = new HeapWalkerManager();

        private Singleton() {
        }
    }
}

