/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Rule;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotationArgument;
import org.netbeans.modules.websvc.editor.hints.rules.WebServiceAnnotations;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class WebParamDuplicity
extends Rule<VariableElement>
implements WebServiceAnnotations {
    @Override
    protected ErrorDescription[] apply(VariableElement subject, ProblemContext ctx) {
        Object value;
        AnnotationValue val;
        AnnotationMirror paramAnn = Utilities.findAnnotation(subject, "javax.jws.WebParam");
        if (paramAnn != null && (val = Utilities.getAnnotationAttrValue(paramAnn, "name")) != null && (value = val.getValue()) != null && this.isDuplicate(subject, value)) {
            String label = NbBundle.getMessage(WebParamDuplicity.class, (String)"MSG_WebParam_Duplicity");
            RemoveAnnotationArgument fix = new RemoveAnnotationArgument(ctx.getFileObject(), subject, paramAnn, "name");
            AnnotationTree annotationTree = (AnnotationTree)ctx.getCompilationInfo().getTrees().getTree(subject, paramAnn);
            ExpressionTree problemTree = Utilities.getAnnotationArgumentTree(annotationTree, "name");
            ctx.setElementToAnnotate(problemTree);
            ErrorDescription problem = WebParamDuplicity.createProblem((Element)subject, ctx, label, fix);
            ctx.setElementToAnnotate(null);
            return new ErrorDescription[]{problem};
        }
        return null;
    }

    @Override
    protected boolean isApplicable(VariableElement subject, ProblemContext ctx) {
        return Utilities.hasAnnotation(subject, "javax.jws.WebParam");
    }

    private boolean isDuplicate(VariableElement subject, Object nameValue) {
        Element methodEl = subject.getEnclosingElement();
        if (ElementKind.METHOD == methodEl.getKind()) {
            for (VariableElement variableElement : ((ExecutableElement)methodEl).getParameters()) {
                AnnotationValue val;
                AnnotationMirror paramAnn;
                Name paramName = variableElement.getSimpleName();
                if (paramName.contentEquals(subject.getSimpleName()) || !((paramAnn = Utilities.findAnnotation(variableElement, "javax.jws.WebParam")) != null ? ((val = Utilities.getAnnotationAttrValue(paramAnn, "name")) != null ? nameValue.equals(val.getValue()) : paramName.contentEquals(nameValue.toString())) : paramName.contentEquals(nameValue.toString()))) continue;
                return true;
            }
        }
        return false;
    }
}

