/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.tokens;

import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.ws.security.wsu10.AttributedDateTime;
import com.sun.xml.ws.security.wsu10.ObjectFactory;
import com.sun.xml.ws.security.wsu10.TimestampType;
import com.sun.xml.wss.XWSSecurityException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class Timestamp
extends TimestampType
implements com.sun.xml.ws.security.opt.api.tokens.Timestamp,
SecurityHeaderElement,
SecurityElementWriter {
    private static final TimeZone utc = TimeZone.getTimeZone("UTC");
    private static Calendar utcCalendar = new GregorianCalendar(utc);
    public static final SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat utcCalendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private long timeout = 0L;
    private SOAPVersion soapVersion = SOAPVersion.SOAP_11;
    private ObjectFactory objFac = new ObjectFactory();

    public Timestamp(SOAPVersion sv) {
        this.soapVersion = sv;
    }

    @Override
    public void setCreated(String created) {
        AttributedDateTime timeCreated = this.objFac.createAttributedDateTime();
        timeCreated.setValue(created);
        this.setCreated(timeCreated);
    }

    @Override
    public void setExpires(String expires) {
        AttributedDateTime timeExpires = this.objFac.createAttributedDateTime();
        timeExpires.setValue(expires);
        this.setExpires(timeExpires);
    }

    @Override
    public String getCreatedValue() {
        String createdValue = null;
        AttributedDateTime created = this.getCreated();
        if (created != null) {
            createdValue = created.getValue();
        }
        return createdValue;
    }

    @Override
    public String getExpiresValue() {
        String expiresValue = null;
        AttributedDateTime expires = this.getExpires();
        if (expires != null) {
            expiresValue = expires.getValue();
        }
        return expiresValue;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public String getNamespaceURI() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    }

    @Override
    public String getLocalPart() {
        return "Timestamp";
    }

    public String getAttribute(String nsUri, String localName) {
        QName qname = new QName(nsUri, localName);
        Map<QName, String> otherAttributes = this.getOtherAttributes();
        return otherAttributes.get(qname);
    }

    public String getAttribute(QName name) {
        Map<QName, String> otherAttributes = this.getOtherAttributes();
        return otherAttributes.get(name);
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        XMLStreamBufferResult xbr = new XMLStreamBufferResult();
        JAXBElement<TimestampType> tsElem = new ObjectFactory().createTimestamp(this);
        try {
            this.getMarshaller().marshal(tsElem, xbr);
        }
        catch (JAXBException je) {
            throw new XMLStreamException(je);
        }
        return xbr.getXMLStreamBuffer().readAsXMLStreamReader();
    }

    @Override
    public void writeTo(OutputStream os) {
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        JAXBElement<TimestampType> tsElem = new ObjectFactory().createTimestamp(this);
        try {
            OutputStream os;
            if (streamWriter instanceof Map && (os = (OutputStream)((Map)((Object)streamWriter)).get("sjsxp-outputstream")) != null) {
                streamWriter.writeCharacters("");
                this.getMarshaller().marshal(tsElem, os);
                return;
            }
            this.getMarshaller().marshal(tsElem, streamWriter);
        }
        catch (JAXBException e) {
            throw new XMLStreamException(e);
        }
    }

    private Marshaller getMarshaller() throws JAXBException {
        return JAXBUtil.createMarshaller(this.soapVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDateTime() throws XWSSecurityException {
        if (this.created == null) {
            Calendar calendar = utcCalendar;
            synchronized (calendar) {
                long currentTime = System.currentTimeMillis();
                utcCalendar.setTimeInMillis(currentTime);
                this.setCreated(utcCalendarFormatter1.format(utcCalendar.getTime()));
                utcCalendar.setTimeInMillis(currentTime + this.timeout);
                this.setExpires(utcCalendarFormatter1.format(utcCalendar.getTime()));
            }
        }
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        return false;
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        try {
            Marshaller marshaller = this.getMarshaller();
            for (Map.Entry entry : props.entrySet()) {
                marshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
            this.writeTo(streamWriter);
        }
        catch (JAXBException jbe) {
            throw new XMLStreamException(jbe);
        }
    }

    static {
        utcCalendarFormatter1.setTimeZone(utc);
    }
}

