/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api.metamodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class ModelUnit
implements PropertyChangeListener,
FileChangeListener {
    private static final RequestProcessor RP = new RequestProcessor(ModelUnit.class);
    private static final Logger LOGGER = Logger.getLogger(ModelUnit.class.getName());
    private final ClassPath bootPath;
    private final ClassPath compilePath;
    private final ClassPath sourcePath;
    private final WeakReference<Project> projectRef;
    private final PropertyChangeSupport changeSupport;
    private List<FileObject> configFiles;
    private List<FileObject> configRoots = Collections.synchronizedList(new LinkedList());
    private static final String META_INF = "META-INF";
    private static final String FACES_CONFIG = "faces-config.xml";
    private static final String FACES_CONFIG_SUFFIX = ".faces-config.xml";
    private static final String DEFAULT_FACES_CONFIG_PATH = "WEB-INF/faces-config.xml";
    public final String PROP_CONFIG_FILES = "configFiles";

    public static ModelUnit create(ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath, Project project) {
        return new ModelUnit(bootPath, compilePath, sourcePath, project);
    }

    private ModelUnit(ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath, Project project) {
        Parameters.notNull((CharSequence)"sourcePath", (Object)sourcePath);
        this.bootPath = bootPath;
        this.compilePath = compilePath;
        this.sourcePath = sourcePath;
        this.projectRef = new WeakReference<Project>(project);
        this.changeSupport = new PropertyChangeSupport(this);
        this.initListeners();
    }

    public ClassPath getBootPath() {
        return this.bootPath;
    }

    public ClassPath getCompilePath() {
        return this.compilePath;
    }

    public ClassPath getSourcePath() {
        return this.sourcePath;
    }

    public FileObject getApplicationFacesConfig() {
        List<FileObject> l = this.getConfigFilesImpl();
        if (l.isEmpty()) {
            return null;
        }
        FileObject first = l.iterator().next();
        Project project = (Project)this.projectRef.get();
        if (project == null) {
            return null;
        }
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule != null) {
            FileObject documentBase = webModule.getDocumentBase();
            if (documentBase == null) {
                return null;
            }
            FileObject mainConfigFile = documentBase.getFileObject(DEFAULT_FACES_CONFIG_PATH);
            if (mainConfigFile != null && mainConfigFile.equals(first)) {
                return first;
            }
        } else {
            LinkedList<FileObject> projectConfigs = new LinkedList<FileObject>();
            ModelUnit.collectConfigurationFilesFromClassPath(this.sourcePath, projectConfigs, new LinkedList<FileObject>());
            for (FileObject config : projectConfigs) {
                if (!config.getName().equals(FACES_CONFIG)) continue;
                return config;
            }
        }
        return null;
    }

    public List<FileObject> getApplicationConfigurationResources() {
        List<FileObject> l = this.getConfigFilesImpl();
        FileObject applicationFacesConfig = this.getApplicationFacesConfig();
        if (applicationFacesConfig != null) {
            return l.subList(1, l.size());
        }
        return l;
    }

    private static void collectConfigurationFilesFromClassPath(ClassPath cp, List<FileObject> configs, List<FileObject> configRoots) {
        for (ClassPath.Entry entry : cp.entries()) {
            FileObject[] roots;
            if (entry.isValid()) {
                roots = new FileObject[]{entry.getRoot()};
            } else {
                SourceForBinaryQuery.Result res = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL());
                roots = res.getRoots();
            }
            for (FileObject root : roots) {
                FileObject[] children;
                configRoots.add(root);
                FileObject metaInf = root.getFileObject(META_INF);
                if (metaInf == null) continue;
                for (FileObject fileObject : children = metaInf.getChildren()) {
                    String name = fileObject.getNameExt();
                    if (!name.equals(FACES_CONFIG) && !name.endsWith(FACES_CONFIG_SUFFIX) || configs.contains(fileObject)) continue;
                    configs.add(fileObject);
                }
            }
        }
    }

    private synchronized List<FileObject> getConfigFiles() {
        return this.configFiles;
    }

    private synchronized void setConfigFiles(List<FileObject> configFiles, List<FileObject> configRoots) {
        this.configFiles = configFiles;
        this.configRoots = configRoots;
    }

    private synchronized List<FileObject> getConfigRoots() {
        return this.configRoots;
    }

    private List<FileObject> getConfigFilesImpl() {
        List<Object> configs = this.getConfigFiles();
        Project project = (Project)this.projectRef.get();
        if (configs != null || project == null) {
            return configs;
        }
        LinkedList<FileObject> webFacesConfigs = new LinkedList<FileObject>();
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule != null) {
            webFacesConfigs.addAll(Arrays.asList(ConfigurationUtils.getFacesConfigFiles(webModule)));
        }
        configs = Collections.synchronizedList(new LinkedList(webFacesConfigs));
        List<FileObject> localconfigRoots = Collections.synchronizedList(new LinkedList());
        if (webModule != null && webModule.getDocumentBase() != null) {
            localconfigRoots.add(webModule.getDocumentBase());
        }
        ModelUnit.collectConfigurationFilesFromClassPath(this.sourcePath, configs, localconfigRoots);
        ModelUnit.collectConfigurationFilesFromClassPath(this.compilePath, configs, localconfigRoots);
        this.setConfigFiles(configs, localconfigRoots);
        return configs;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    private void fireChange() {
        this.setConfigFiles(null, new LinkedList<FileObject>());
        this.changeSupport.firePropertyChange("configFiles", null, null);
    }

    private void initListeners() {
        this.sourcePath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.sourcePath));
        this.compilePath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.compilePath));
        RP.submit(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                Project project = (Project)ModelUnit.this.projectRef.get();
                if (project != null) {
                    project.getProjectDirectory().addRecursiveListener(FileUtil.weakFileChangeListener((FileChangeListener)ModelUnit.this, (Object)project.getProjectDirectory()));
                }
                LOGGER.log(Level.FINE, "JSF''s ModelUnit ResursiveListener registration took {0}ms.", new Object[]{System.currentTimeMillis() - start});
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("entries")) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRelevantFileEvent(FileEvent fe) {
        boolean res;
        String path = fe.getFile().getPath();
        boolean bl = res = path.endsWith("/web.xml") || path.endsWith("/WEB-INF/faces-config.xml") || path.endsWith("/META-INF/faces-config.xml") || path.endsWith(FACES_CONFIG_SUFFIX) && fe.getFile().getParent() != null && fe.getFile().getParent().getNameExt().equals(META_INF);
        if (!res && fe instanceof FileRenameEvent) {
            FileRenameEvent fre = (FileRenameEvent)fe;
            boolean bl2 = res = (fre.getName().equals("faces-config") || fre.getName().endsWith(".faces-config") || fre.getName().endsWith("web.xml")) && fre.getExt().equals("xml");
        }
        if (res) {
            List<FileObject> cfRoots;
            res = false;
            List<FileObject> list = cfRoots = this.getConfigRoots();
            synchronized (list) {
                for (FileObject fo : cfRoots) {
                    if (!FileUtil.isParentOf((FileObject)fo, (FileObject)fe.getFile())) continue;
                    res = true;
                    break;
                }
            }
        }
        return res;
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
        if (this.isRelevantFileEvent(fe)) {
            this.fireChange();
        }
    }

    public void fileChanged(FileEvent fe) {
        if (this.isRelevantFileEvent(fe)) {
            this.fireChange();
        }
    }

    public void fileDeleted(FileEvent fe) {
        if (this.isRelevantFileEvent(fe)) {
            this.fireChange();
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        if (this.isRelevantFileEvent((FileEvent)fe)) {
            this.fireChange();
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }
}

