/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.RecommendedTemplates;

public final class RecommendedTemplatesImpl
implements RecommendedTemplates,
PrivilegedTemplates {
    private static final String[] JAR_APPLICATION_TYPES = new String[]{"java-classes", "java-main-class", "java-forms", "gui-java-application", "java-beans", "oasis-XML-catalogs", "XML", "web-service-clients", "REST-clients", "wsdl", "junit", "selenium-java-types", "simple-files"};
    private static final String[] JAR_PRIVILEGED_NAMES = new String[]{"Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/Classes/Interface.java", "Templates/GUIForms/JPanel.java", "Templates/GUIForms/JFrame.java", "Templates/WebServices/WebServiceClient"};
    private static final String[] POM_APPLICATION_TYPES = new String[]{"XML", "simple-files"};
    private static final String[] POM_PRIVILEGED_NAMES = new String[]{"Templates/XML/XMLWizard", "Templates/Other/Folder"};
    private static final String[] ALL_TYPES = new String[]{"java-classes", "java-main-class", "java-forms", "java-beans", "j2ee-types", "gui-java-application", "java-beans", "oasis-XML-catalogs", "XML", "ant-script", "ant-task", "web-service-clients", "REST-clients", "wsdl", "servlet-types", "web-types", "junit", "selenium-java-types", "simple-files", "ear-types"};
    private static final String[] GENERIC_WEB_TYPES = new String[]{"java-classes", "java-main-class", "java-beans", "oasis-XML-catalogs", "XML", "wsdl", "junit", "selenium-java-types", "simple-files"};
    private static final String[] GENERIC_EJB_TYPES = new String[]{"java-classes", "wsdl", "java-beans", "java-main-class", "oasis-XML-catalogs", "XML", "junit", "selenium-java-types", "simple-files"};
    private static final String[] GENERIC_EAR_TYPES = new String[]{"XML", "wsdl", "simple-files"};
    private final List<String> prohibited;
    private final Project project;

    public RecommendedTemplatesImpl(Project proj) {
        this.project = proj;
        this.prohibited = new ArrayList<String>();
        this.prohibited.add("ear");
        this.prohibited.add("ejb");
        this.prohibited.add("war");
        this.prohibited.add("nbm");
        this.prohibited.add("bundle");
    }

    public String[] getRecommendedTypes() {
        String packaging = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getPackagingType();
        if (packaging == null) {
            packaging = "jar";
        }
        if ("pom".equals(packaging = packaging.trim())) {
            if (ProjectUtils.getSources((Project)this.project).getSourceGroups("java").length > 0) {
                return (String[])JAR_APPLICATION_TYPES.clone();
            }
            return (String[])POM_APPLICATION_TYPES.clone();
        }
        if ("jar".equals(packaging)) {
            return (String[])JAR_APPLICATION_TYPES.clone();
        }
        if ("war".equals(packaging)) {
            return (String[])GENERIC_WEB_TYPES.clone();
        }
        if ("ejb".equals(packaging)) {
            return (String[])GENERIC_EJB_TYPES.clone();
        }
        if ("ear".equals(packaging)) {
            return (String[])GENERIC_EAR_TYPES.clone();
        }
        if (this.prohibited.contains(packaging)) {
            return new String[0];
        }
        return (String[])ALL_TYPES.clone();
    }

    public String[] getPrivilegedTemplates() {
        String packaging = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getPackagingType();
        if (packaging == null) {
            packaging = "jar";
        }
        if ("pom".equals(packaging = packaging.trim())) {
            return (String[])POM_PRIVILEGED_NAMES.clone();
        }
        if (this.prohibited.contains(packaging)) {
            return new String[0];
        }
        return (String[])JAR_PRIVILEGED_NAMES.clone();
    }
}

