/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.model.pom.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.modules.maven.model.pom.spi.ElementFactory;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class ElementFactoryRegistry {
    private static ElementFactoryRegistry registry = null;
    private Map<QName, ElementFactory> factories = null;
    private Set<Class> knownEmbeddedModelTypes = null;
    private Set<QName> knownQNames = null;
    private Set<String> knownNames = null;

    private ElementFactoryRegistry() {
        this.initialize();
    }

    public static ElementFactoryRegistry getDefault() {
        if (registry == null) {
            registry = new ElementFactoryRegistry();
        }
        return registry;
    }

    private void initialize() {
        this.factories = new Hashtable<QName, ElementFactory>();
        for (ElementFactory service : Lookup.getDefault().lookupAll(ElementFactory.class)) {
            this.register(service);
        }
        if (this.factories.size() < 1) {
            Lookup lu2 = Lookups.metaInfServices((ClassLoader)this.getClass().getClassLoader());
            for (ElementFactory service : lu2.lookupAll(ElementFactory.class)) {
                this.register(service);
            }
        }
    }

    public void register(ElementFactory factory) {
        for (QName q : factory.getElementQNames()) {
            this.factories.put(q, factory);
        }
        this.resetQNameCache();
    }

    public void unregister(ElementFactory fac) {
        for (QName q : fac.getElementQNames()) {
            this.factories.remove(q);
        }
        this.resetQNameCache();
    }

    public ElementFactory get(QName type) {
        return this.factories.get(type);
    }

    public void resetQNameCache() {
        this.knownEmbeddedModelTypes = null;
        this.knownQNames = null;
        this.knownNames = null;
    }

    public Set<QName> getKnownQNames() {
        return Collections.unmodifiableSet(this.knownQNames());
    }

    private Set<QName> knownQNames() {
        if (this.knownQNames == null) {
            this.knownQNames = new HashSet<QName>();
            for (ElementFactory f : this.factories.values()) {
                for (QName q : f.getElementQNames()) {
                    if (this.knownQNames.add(q)) continue;
                    String msg = "Duplicate factory for: " + q;
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, "getKnownQNames", msg);
                }
            }
        }
        return this.knownQNames;
    }

    public Set<String> getKnownElementNames() {
        return Collections.unmodifiableSet(this.knownElementNames());
    }

    private Set<String> knownElementNames() {
        if (this.knownNames == null) {
            this.knownNames = new HashSet<String>();
            for (QName q : this.knownQNames()) {
                this.knownNames.add(q.getLocalPart());
            }
        }
        return this.knownNames;
    }

    public void addEmbeddedModelQNames(AbstractDocumentModel<?> embeddedModel) {
        if (this.knownEmbeddedModelTypes == null) {
            this.knownEmbeddedModelTypes = new HashSet<Class>();
        }
        if (!this.knownEmbeddedModelTypes.contains(embeddedModel.getClass())) {
            this.knownQNames().addAll(embeddedModel.getQNames());
            this.knownNames = null;
        }
    }
}

