/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.ImmutableList;
import org.gradle.internal.Pair;
import org.gradle.internal.hash.Hashable;
import org.gradle.internal.hash.Hasher;

class AbstractMapSnapshot<T extends Hashable>
implements Hashable {
    protected final ImmutableList<Pair<T, T>> entries;

    public AbstractMapSnapshot(ImmutableList<Pair<T, T>> entries) {
        this.entries = entries;
    }

    public ImmutableList<Pair<T, T>> getEntries() {
        return this.entries;
    }

    public void appendToHasher(Hasher hasher) {
        hasher.putString((CharSequence)"Map");
        hasher.putInt(this.entries.size());
        for (Pair entry : this.entries) {
            ((Hashable)entry.getLeft()).appendToHasher(hasher);
            ((Hashable)entry.getRight()).appendToHasher(hasher);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractMapSnapshot other = (AbstractMapSnapshot)obj;
        return this.entries.equals(other.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }
}

