/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.caching.internal.packaging.impl.PackerDirectoryUtil;
import org.gradle.caching.internal.packaging.impl.RelativePathParser;
import org.gradle.internal.IoActions;
import org.gradle.internal.MutableLong;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathStringTracker;

public class TarBuildCacheEntryPacker
implements BuildCacheEntryPacker {
    private static final String METADATA_PATH = "METADATA";
    private static final Pattern TREE_PATH = Pattern.compile("(missing-)?tree-([^/]+)(?:/(.*))?");
    private static final int BUFFER_SIZE = 65536;
    private static final ThreadLocal<byte[]> COPY_BUFFERS = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[65536];
        }
    };
    private final FileSystem fileSystem;
    private final StreamHasher streamHasher;
    private final StringInterner stringInterner;

    public TarBuildCacheEntryPacker(FileSystem fileSystem, StreamHasher streamHasher, StringInterner stringInterner) {
        this.fileSystem = fileSystem;
        this.streamHasher = streamHasher;
        this.stringInterner = stringInterner;
    }

    @Override
    public BuildCacheEntryPacker.PackResult pack(CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, OutputStream output, OriginWriter writeOrigin) throws IOException {
        BufferedOutputStream bufferedOutput = output instanceof BufferedOutputStream ? (BufferedOutputStream)output : new BufferedOutputStream(output);
        try (TarArchiveOutputStream tarOutput = new TarArchiveOutputStream((OutputStream)bufferedOutput, "utf-8");){
            tarOutput.setLongFileMode(3);
            tarOutput.setBigNumberMode(2);
            tarOutput.setAddPaxHeadersForNonAsciiNames(true);
            this.packMetadata(writeOrigin, tarOutput);
            long entryCount = this.pack(entity, fingerprints, tarOutput);
            BuildCacheEntryPacker.PackResult packResult = new BuildCacheEntryPacker.PackResult(entryCount + 1L);
            return packResult;
        }
    }

    private void packMetadata(OriginWriter writeMetadata, TarArchiveOutputStream tarOutput) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writeMetadata.execute((OutputStream)baos);
        TarBuildCacheEntryPacker.createTarEntry(METADATA_PATH, baos.size(), 33188, tarOutput);
        tarOutput.write(baos.toByteArray());
        tarOutput.closeArchiveEntry();
    }

    private long pack(CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, TarArchiveOutputStream tarOutput) {
        MutableLong entries = new MutableLong();
        entity.visitOutputTrees((treeName, type, root) -> {
            CurrentFileCollectionFingerprint fingerprint = (CurrentFileCollectionFingerprint)fingerprints.get(treeName);
            try {
                entries.increment(this.packTree(treeName, type, fingerprint, tarOutput));
            }
            catch (Exception ex) {
                throw new GradleException(String.format("Could not pack tree '%s': %s", treeName, ex.getMessage()), (Throwable)ex);
            }
        });
        return entries.get();
    }

    private long packTree(String name, TreeType type, CurrentFileCollectionFingerprint fingerprint, TarArchiveOutputStream tarOutput) {
        PackingVisitor packingVisitor = new PackingVisitor(tarOutput, name, type, this.fileSystem);
        fingerprint.accept((FileSystemSnapshotVisitor)packingVisitor);
        return packingVisitor.finish();
    }

    private static void createTarEntry(String path, long size, int mode, TarArchiveOutputStream tarOutput) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(path, true);
        entry.setSize(size);
        entry.setMode(mode);
        tarOutput.putArchiveEntry((ArchiveEntry)entry);
    }

    @Override
    public BuildCacheEntryPacker.UnpackResult unpack(CacheableEntity entity, InputStream input, OriginReader readOrigin) throws IOException {
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream(input);){
            BuildCacheEntryPacker.UnpackResult unpackResult = this.unpack(entity, tarInput, readOrigin);
            return unpackResult;
        }
    }

    private BuildCacheEntryPacker.UnpackResult unpack(CacheableEntity entity, TarArchiveInputStream tarInput, OriginReader readOriginAction) throws IOException {
        ImmutableMap.Builder treesBuilder = ImmutableMap.builder();
        entity.visitOutputTrees((name, type, root) -> treesBuilder.put((Object)name, (Object)new CacheableTree(type, root)));
        ImmutableMap treesByName = treesBuilder.build();
        OriginMetadata originMetadata = null;
        HashMap<String, FileSystemLocationSnapshot> snapshots = new HashMap<String, FileSystemLocationSnapshot>();
        TarArchiveEntry tarEntry = tarInput.getNextTarEntry();
        MutableLong entries = new MutableLong();
        while (tarEntry != null) {
            entries.increment(1L);
            String path = tarEntry.getName();
            if (path.equals(METADATA_PATH)) {
                originMetadata = readOriginAction.execute((InputStream)new CloseShieldInputStream((InputStream)tarInput));
                tarEntry = tarInput.getNextTarEntry();
                continue;
            }
            Matcher matcher = TREE_PATH.matcher(path);
            if (!matcher.matches()) {
                throw new IllegalStateException("Cached entry format error, invalid contents: " + path);
            }
            String treeName = TarBuildCacheEntryPacker.unescape(matcher.group(2));
            CacheableTree tree = (CacheableTree)treesByName.get((Object)treeName);
            if (tree == null) {
                throw new IllegalStateException(String.format("No tree '%s' registered", treeName));
            }
            boolean missing = matcher.group(1) != null;
            String childPath = matcher.group(3);
            tarEntry = this.unpackTree(treeName, tree.getType(), tree.getRoot(), tarInput, tarEntry, childPath, missing, snapshots, entries);
        }
        if (originMetadata == null) {
            throw new IllegalStateException("Cached result format error, no origin metadata was found.");
        }
        return new BuildCacheEntryPacker.UnpackResult(originMetadata, entries.get(), snapshots);
    }

    @Nullable
    private TarArchiveEntry unpackTree(String treeName, TreeType treeType, File treeRoot, TarArchiveInputStream input, TarArchiveEntry rootEntry, String childPath, boolean missing, Map<String, FileSystemLocationSnapshot> snapshots, MutableLong entries) throws IOException {
        boolean isDirEntry = rootEntry.isDirectory();
        boolean root = Strings.isNullOrEmpty((String)childPath);
        if (!root) {
            throw new IllegalStateException("Root needs to be the first entry in a tree");
        }
        if (missing) {
            this.unpackMissingFile(treeRoot);
            return input.getNextTarEntry();
        }
        PackerDirectoryUtil.ensureDirectoryForTree(treeType, treeRoot);
        if (treeType == TreeType.FILE) {
            if (isDirEntry) {
                throw new IllegalStateException("Should be a file: " + treeName);
            }
            RegularFileSnapshot fileSnapshot = this.unpackFile(input, rootEntry, treeRoot, treeRoot.getName());
            snapshots.put(treeName, (FileSystemLocationSnapshot)fileSnapshot);
            return input.getNextTarEntry();
        }
        if (!isDirEntry) {
            throw new IllegalStateException("Should be a directory: " + treeName);
        }
        this.chmodUnpackedFile(rootEntry, treeRoot);
        return this.unpackDirectoryTree(input, rootEntry, snapshots, entries, treeRoot, treeName);
    }

    private void unpackMissingFile(File treeRoot) throws IOException {
        if (!PackerDirectoryUtil.makeDirectory(treeRoot.getParentFile()) && treeRoot.exists()) {
            FileUtils.forceDelete((File)treeRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegularFileSnapshot unpackFile(TarArchiveInputStream input, TarArchiveEntry entry, File file, String fileName) throws IOException {
        HashCode hash;
        FileOutputStream output = new FileOutputStream(file);
        try {
            hash = this.streamHasher.hashCopy((InputStream)input, (OutputStream)output);
            this.chmodUnpackedFile(entry, file);
        }
        finally {
            IoActions.closeQuietly((Closeable)output);
        }
        String internedAbsolutePath = this.stringInterner.intern(file.getAbsolutePath());
        String internedFileName = this.stringInterner.intern(fileName);
        return new RegularFileSnapshot(internedAbsolutePath, internedFileName, hash, file.lastModified());
    }

    @Nullable
    private TarArchiveEntry unpackDirectoryTree(TarArchiveInputStream input, TarArchiveEntry rootEntry, Map<String, FileSystemLocationSnapshot> snapshots, MutableLong entries, File treeRoot, String treeName) throws IOException {
        TarArchiveEntry entry;
        RelativePathParser parser = new RelativePathParser();
        parser.rootPath(rootEntry.getName());
        MerkleDirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        String rootPath = this.stringInterner.intern(treeRoot.getAbsolutePath());
        String rootDirName = this.stringInterner.intern(treeRoot.getName());
        builder.preVisitDirectory(rootPath, rootDirName);
        while ((entry = input.getNextTarEntry()) != null) {
            boolean isDir = entry.isDirectory();
            int directoriesLeft = parser.nextPath(entry.getName(), isDir);
            for (int i = 0; i < directoriesLeft; ++i) {
                builder.postVisitDirectory();
            }
            if (parser.getDepth() == 0) break;
            entries.increment(1L);
            File file = new File(treeRoot, parser.getRelativePath());
            if (isDir) {
                FileUtils.forceMkdir((File)file);
                this.chmodUnpackedFile(entry, file);
                String internedAbsolutePath = this.stringInterner.intern(file.getAbsolutePath());
                String internedDirName = this.stringInterner.intern(parser.getName());
                builder.preVisitDirectory(internedAbsolutePath, internedDirName);
                continue;
            }
            RegularFileSnapshot fileSnapshot = this.unpackFile(input, entry, file, parser.getName());
            builder.visit((FileSystemLocationSnapshot)fileSnapshot);
        }
        for (int i = 0; i < parser.getDepth(); ++i) {
            builder.postVisitDirectory();
        }
        snapshots.put(treeName, builder.getResult());
        return entry;
    }

    private void chmodUnpackedFile(TarArchiveEntry entry, File file) {
        this.fileSystem.chmod(file, entry.getMode() & 0xFFF);
    }

    private static String escape(String name) {
        try {
            return URLEncoder.encode(name, "utf-8");
        }
        catch (UnsupportedEncodingException ignored) {
            throw new AssertionError();
        }
    }

    private static String unescape(String name) {
        try {
            return URLDecoder.decode(name, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class PackingVisitor
    implements FileSystemSnapshotVisitor {
        private final RelativePathStringTracker relativePathStringTracker;
        private final TarArchiveOutputStream tarOutput;
        private final String treePath;
        private final String treeRoot;
        private final FileSystem fileSystem;
        private final TreeType type;
        private long entries;

        public PackingVisitor(TarArchiveOutputStream tarOutput, String treeName, TreeType type, FileSystem fileSystem) {
            this.tarOutput = tarOutput;
            this.treePath = "tree-" + TarBuildCacheEntryPacker.escape(treeName);
            this.treeRoot = this.treePath + "/";
            this.type = type;
            this.fileSystem = fileSystem;
            this.relativePathStringTracker = new RelativePathStringTracker();
        }

        public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
            boolean root = this.relativePathStringTracker.isRoot();
            this.relativePathStringTracker.enter((FileSystemLocationSnapshot)directorySnapshot);
            this.assertCorrectType(root, (FileSystemLocationSnapshot)directorySnapshot);
            String targetPath = this.getTargetPath(root);
            int mode = root ? 493 : this.fileSystem.getUnixMode(new File(directorySnapshot.getAbsolutePath()));
            this.storeDirectoryEntry(targetPath, mode, this.tarOutput);
            ++this.entries;
            return true;
        }

        public void visit(FileSystemLocationSnapshot fileSnapshot) {
            boolean root = this.relativePathStringTracker.isRoot();
            this.relativePathStringTracker.enter(fileSnapshot);
            String targetPath = this.getTargetPath(root);
            if (fileSnapshot.getType() == FileType.Missing) {
                this.storeMissingTree(targetPath, this.tarOutput);
            } else {
                this.assertCorrectType(root, fileSnapshot);
                File file = new File(fileSnapshot.getAbsolutePath());
                int mode = this.fileSystem.getUnixMode(file);
                this.storeFileEntry(file, targetPath, file.length(), mode, this.tarOutput);
            }
            this.relativePathStringTracker.leave();
            ++this.entries;
        }

        public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
            this.relativePathStringTracker.leave();
        }

        public long finish() {
            if (this.entries == 0L) {
                this.storeMissingTree(this.treePath, this.tarOutput);
                ++this.entries;
            }
            return this.entries;
        }

        private void assertCorrectType(boolean root, FileSystemLocationSnapshot snapshot) {
            if (root) {
                switch (this.type) {
                    case DIRECTORY: {
                        if (snapshot.getType() == FileType.Directory) break;
                        throw new IllegalArgumentException(String.format("Expected '%s' to be a directory", snapshot.getAbsolutePath()));
                    }
                    case FILE: {
                        if (snapshot.getType() == FileType.RegularFile) break;
                        throw new IllegalArgumentException(String.format("Expected '%s' to be a file", snapshot.getAbsolutePath()));
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        private String getTargetPath(boolean root) {
            if (root) {
                return this.treePath;
            }
            String relativePath = this.relativePathStringTracker.getRelativePathString();
            return this.treeRoot + relativePath;
        }

        private void storeMissingTree(String treePath, TarArchiveOutputStream tarOutput) {
            try {
                TarBuildCacheEntryPacker.createTarEntry("missing-" + treePath, 0L, 33188, tarOutput);
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        private void storeDirectoryEntry(String path, int mode, TarArchiveOutputStream tarOutput) {
            try {
                TarBuildCacheEntryPacker.createTarEntry(path + "/", 0L, 0x4000 | mode, tarOutput);
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void storeFileEntry(File inputFile, String path, long size, int mode, TarArchiveOutputStream tarOutput) {
            try {
                TarBuildCacheEntryPacker.createTarEntry(path, size, 0x8000 | mode, tarOutput);
                FileInputStream input = new FileInputStream(inputFile);
                try {
                    IOUtils.copyLarge((InputStream)input, (OutputStream)tarOutput, (byte[])((byte[])COPY_BUFFERS.get()));
                }
                finally {
                    IoActions.closeQuietly((Closeable)input);
                }
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
    }

    private static class CacheableTree {
        private final TreeType type;
        private final File root;

        public CacheableTree(TreeType type, File root) {
            this.type = type;
            this.root = root;
        }

        public TreeType getType() {
            return this.type;
        }

        public File getRoot() {
            return this.root;
        }
    }

    private static interface UnixPermissions {
        public static final int FILE_FLAG = 32768;
        public static final int DEFAULT_FILE_PERM = 420;
        public static final int DIR_FLAG = 16384;
        public static final int DEFAULT_DIR_PERM = 493;
        public static final int PERM_MASK = 4095;
    }
}

