/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Optional;
import org.gradle.internal.change.ChangeDetectorVisitor;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.execution.CurrentSnapshotResult;
import org.gradle.internal.execution.IncrementalContext;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.changes.OutputFileChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;

public class StoreSnapshotsStep<C extends IncrementalContext>
implements Step<C, CurrentSnapshotResult> {
    private final Step<? super C, ? extends CurrentSnapshotResult> delegate;

    public StoreSnapshotsStep(Step<? super C, ? extends CurrentSnapshotResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CurrentSnapshotResult execute(C context) {
        CurrentSnapshotResult result = this.delegate.execute(context);
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> finalOutputs = result.getFinalOutputs();
        context.getBeforeExecutionState().ifPresent(beforeExecutionState -> {
            boolean successful = result.getOutcome().isSuccessful();
            if (successful || StoreSnapshotsStep.didChangeOutput(context.getAfterPreviousExecutionState(), finalOutputs)) {
                UnitOfWork work = context.getWork();
                work.getExecutionHistoryStore().store(work.getIdentity(), result.getOriginMetadata(), beforeExecutionState.getImplementation(), beforeExecutionState.getAdditionalImplementations(), beforeExecutionState.getInputProperties(), beforeExecutionState.getInputFileProperties(), finalOutputs, successful);
            }
        });
        return result;
    }

    private static boolean didChangeOutput(Optional<AfterPreviousExecutionState> afterPreviousExecutionState, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
        if (!afterPreviousExecutionState.isPresent()) {
            return true;
        }
        ImmutableSortedMap<String, FileCollectionFingerprint> previous = afterPreviousExecutionState.get().getOutputFileProperties();
        if (!previous.keySet().equals((Object)current.keySet())) {
            return true;
        }
        ChangeDetectorVisitor visitor = new ChangeDetectorVisitor();
        OutputFileChanges changes = new OutputFileChanges(previous, current, true);
        changes.accept((ChangeVisitor)visitor);
        return visitor.hasAnyChanges();
    }
}

