/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.execution.process;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.jna.JnaLoader;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;

public class UnixProcessManager {
    private static final Logger LOG = Logger.getInstance(UnixProcessManager.class);
    private static final CLib C_LIB;

    private UnixProcessManager() {
    }

    public static int getProcessId(@NotNull Process process2) {
        if (process2 == null) {
            UnixProcessManager.$$$reportNull$$$0(0);
        }
        try {
            if (SystemInfo.IS_AT_LEAST_JAVA9 && "java.lang.ProcessImpl".equals(process2.getClass().getName())) {
                return ((Long)Process.class.getMethod("pid", new Class[0]).invoke((Object)process2, new Object[0])).intValue();
            }
            return ObjectUtils.assertNotNull(ReflectionUtil.getField(process2.getClass(), process2, Integer.TYPE, "pid"));
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to get PID from instance of " + process2.getClass() + ", OS: " + SystemInfo.OS_NAME, t);
        }
    }

    public static int sendSignal(int pid, int signal) {
        UnixProcessManager.checkCLib();
        return C_LIB.kill(pid, signal);
    }

    private static void checkCLib() {
        if (C_LIB == null) {
            throw new IllegalStateException("Couldn't load c library, OS: " + SystemInfo.OS_NAME + ", isUnix: " + SystemInfo.isUnix);
        }
    }

    public static boolean sendSigIntToProcessTree(@NotNull Process process2) {
        if (process2 == null) {
            UnixProcessManager.$$$reportNull$$$0(1);
        }
        return UnixProcessManager.sendSignalToProcessTree(process2, 2);
    }

    public static boolean sendSigKillToProcessTree(@NotNull Process process2) {
        if (process2 == null) {
            UnixProcessManager.$$$reportNull$$$0(2);
        }
        return UnixProcessManager.sendSignalToProcessTree(process2, 9);
    }

    public static boolean sendSignalToProcessTree(@NotNull Process process2, int signal) {
        if (process2 == null) {
            UnixProcessManager.$$$reportNull$$$0(3);
        }
        try {
            return UnixProcessManager.sendSignalToProcessTree(UnixProcessManager.getProcessId(process2), signal);
        }
        catch (Exception e) {
            LOG.warn("Error killing the process", e);
            return false;
        }
    }

    public static boolean sendSignalToProcessTree(int processId, int signal) {
        UnixProcessManager.checkCLib();
        int ourPid = C_LIB.getpid();
        return UnixProcessManager.sendSignalToProcessTree(processId, signal, ourPid);
    }

    public static boolean sendSignalToProcessTree(int processId, int signal, int ourPid) {
        boolean result2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending signal " + signal + " to process tree with root PID " + processId);
        }
        Ref foundPid = new Ref();
        ProcessInfo processInfo = new ProcessInfo();
        ArrayList childrenPids = new ArrayList();
        UnixProcessManager.findChildProcesses(ourPid, processId, foundPid, processInfo, childrenPids);
        if (!foundPid.isNull()) {
            processInfo.killProcTree((Integer)foundPid.get(), signal);
            result2 = true;
        } else {
            for (Integer pid : childrenPids) {
                processInfo.killProcTree(pid, signal);
            }
            boolean bl = result2 = !childrenPids.isEmpty();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done sending signal " + signal + "; found: " + foundPid.get() + ", children: " + childrenPids + ", result: " + result2);
        }
        return result2;
    }

    private static void findChildProcesses(final int our_pid, final int process_pid, final Ref<? super Integer> foundPid, final ProcessInfo processInfo, final List<? super Integer> childrenPids) {
        final Ref<Boolean> ourPidFound = Ref.create(false);
        UnixProcessManager.processPSOutput(UnixProcessManager.getPSCmd(false), (Processor<? super String>)new Processor<String>(){

            @Override
            public boolean process(String s) {
                StringTokenizer st = new StringTokenizer(s, " ");
                int parent_pid = Integer.parseInt(st.nextToken());
                int pid = Integer.parseInt(st.nextToken());
                processInfo.register(pid, parent_pid);
                if (parent_pid == process_pid) {
                    childrenPids.add(pid);
                }
                if (pid == our_pid) {
                    ourPidFound.set(true);
                } else if (pid == process_pid) {
                    if (parent_pid == our_pid || our_pid == -1) {
                        foundPid.set(pid);
                    } else {
                        throw new IllegalStateException("Process (pid=" + process_pid + ") is not our child(our pid = " + our_pid + ")");
                    }
                }
                return false;
            }
        });
        if (our_pid != -1 && !ourPidFound.get().booleanValue()) {
            throw new IllegalStateException("IDE pid is not found in ps list(" + our_pid + ")");
        }
    }

    public static void processPSOutput(String[] cmd, Processor<? super String> processor2) {
        UnixProcessManager.processCommandOutput(cmd, processor2, true, true);
    }

    public static void processCommandOutput(String[] cmd, Processor<? super String> processor2, boolean skipFirstLine, boolean throwOnError) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            UnixProcessManager.processCommandOutput(p, processor2, skipFirstLine, throwOnError);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCommandOutput(Process process2, Processor<? super String> processor2, boolean skipFirstLine, boolean throwOnError) throws IOException {
        BufferedReader stdOutput = new BufferedReader(new InputStreamReader(process2.getInputStream()));
        try {
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process2.getErrorStream()));
            try {
                String s;
                if (skipFirstLine) {
                    stdOutput.readLine();
                }
                while ((s = stdOutput.readLine()) != null) {
                    processor2.process(s);
                }
                StringBuilder errorStr = new StringBuilder();
                while ((s = stdError.readLine()) != null) {
                    if (s.contains("environment variables being ignored")) continue;
                    errorStr.append(s).append("\n");
                }
                if (throwOnError && errorStr.length() > 0) {
                    throw new IOException("Error reading ps output:" + errorStr.toString());
                }
            }
            finally {
                stdError.close();
            }
        }
        finally {
            stdOutput.close();
        }
    }

    public static String[] getPSCmd(boolean commandLineOnly) {
        return UnixProcessManager.getPSCmd(commandLineOnly, false);
    }

    public static String[] getPSCmd(boolean commandLineOnly, boolean isShortenCommand) {
        String psCommand = "/bin/ps";
        if (!new File(psCommand).isFile()) {
            psCommand = "ps";
        }
        if (SystemInfo.isLinux) {
            return new String[]{psCommand, "-e", "--format", commandLineOnly ? "%a" : "%P%p%a"};
        }
        if (SystemInfo.isMac || SystemInfo.isFreeBSD) {
            String command = isShortenCommand ? "comm" : "command";
            return new String[]{psCommand, "-ax", "-o", commandLineOnly ? command : "ppid,pid," + command};
        }
        throw new IllegalStateException(System.getProperty("os.name") + " is not supported.");
    }

    static {
        CLib lib = null;
        try {
            if (SystemInfo.isUnix && JnaLoader.isLoaded()) {
                lib = (CLib)Native.loadLibrary((String)"c", CLib.class);
            }
        }
        catch (Throwable t) {
            Logger.getInstance(UnixProcessManager.class).warn("Can't load standard library", t);
        }
        C_LIB = lib;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "process";
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/execution/process/UnixProcessManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getProcessId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "sendSigIntToProcessTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sendSigKillToProcessTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "sendSignalToProcessTree";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProcessInfo {
        private final Map<Integer, List<Integer>> BY_PARENT = new TreeMap<Integer, List<Integer>>();

        private ProcessInfo() {
        }

        public void register(Integer pid, Integer parentPid) {
            List<Integer> children2 = this.BY_PARENT.get(parentPid);
            if (children2 == null) {
                children2 = new LinkedList<Integer>();
                this.BY_PARENT.put(parentPid, children2);
            }
            children2.add(pid);
        }

        public void killProcTree(int pid, int signal) {
            List<Integer> children2 = this.BY_PARENT.get(pid);
            if (children2 != null) {
                for (int child : children2) {
                    this.killProcTree(child, signal);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending signal " + signal + " to PID " + pid);
            }
            UnixProcessManager.sendSignal(pid, signal);
        }
    }

    private static interface CLib
    extends Library {
        public int getpid();

        public int kill(int var1, int var2);
    }
}

