/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Transformer;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.initialization.SessionLifecycleListener;
import org.gradle.internal.event.ListenerManager;

@ThreadSafe
public class DefaultCrossBuildInMemoryCacheFactory
extends CrossBuildInMemoryCacheFactory {
    private final ListenerManager listenerManager;

    public DefaultCrossBuildInMemoryCacheFactory(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    public <K, V> CrossBuildInMemoryCache<K, V> newCache() {
        DefaultCrossBuildInMemoryCache cache = new DefaultCrossBuildInMemoryCache(new HashMap());
        this.listenerManager.addListener(cache);
        return cache;
    }

    public <V> CrossBuildInMemoryCache<Class<?>, V> newClassCache() {
        DefaultCrossBuildInMemoryCache cache = new DefaultCrossBuildInMemoryCache(new WeakHashMap());
        this.listenerManager.addListener(cache);
        return cache;
    }

    private static class DefaultCrossBuildInMemoryCache<K, V>
    implements CrossBuildInMemoryCache<K, V>,
    SessionLifecycleListener {
        private final Object lock = new Object();
        private final Map<K, V> valuesForThisSession = new HashMap();
        private final Set<V> valuesForPreviousSession = new HashSet<V>();
        private final Map<K, SoftReference<V>> allValues;

        public DefaultCrossBuildInMemoryCache(Map<K, SoftReference<V>> allValues) {
            this.allValues = allValues;
        }

        @Override
        public void afterStart() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beforeComplete() {
            Object object = this.lock;
            synchronized (object) {
                this.valuesForPreviousSession.clear();
                this.valuesForPreviousSession.addAll(this.valuesForThisSession.values());
                this.valuesForThisSession.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                this.valuesForThisSession.clear();
                this.valuesForPreviousSession.clear();
                this.allValues.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public V get(K key) {
            Object object = this.lock;
            synchronized (object) {
                return this.getIfPresent(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key, Transformer<V, K> factory) {
            Object object = this.lock;
            synchronized (object) {
                Object v = this.getIfPresent(key);
                if (v != null) {
                    return v;
                }
                v = factory.transform(key);
                this.allValues.put(key, new SoftReference<V>(v));
                this.valuesForThisSession.put(key, v);
                return v;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K key, V value) {
            Object object = this.lock;
            synchronized (object) {
                this.allValues.put(key, new SoftReference<V>(value));
                this.valuesForThisSession.put(key, value);
            }
        }

        private V getIfPresent(K key) {
            V v = this.valuesForThisSession.get(key);
            if (v != null) {
                return v;
            }
            SoftReference<V> reference = this.allValues.get(key);
            if (reference != null && (v = reference.get()) != null) {
                this.valuesForThisSession.put(key, v);
                return v;
            }
            return null;
        }
    }
}

