/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.PathValidation;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.MaybeCompressedFileResource;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.file.UnknownBackingFileReadableResource;
import org.gradle.api.internal.file.archive.TarFileTree;
import org.gradle.api.internal.file.archive.ZipFileTree;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.internal.file.copy.FileCopier;
import org.gradle.api.internal.file.delete.Deleter;
import org.gradle.api.internal.resources.DefaultResourceHandler;
import org.gradle.api.internal.resources.DefaultResourceResolver;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.internal.LocalResourceAdapter;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.Stat;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.LocalBinaryResource;
import org.gradle.internal.resource.TextResourceLoader;
import org.gradle.internal.resource.local.LocalFileStandInExternalResource;
import org.gradle.internal.time.Clock;
import org.gradle.util.GFileUtils;

public class DefaultFileOperations
implements FileOperations {
    private final FileResolver fileResolver;
    @Nullable
    private final TaskResolver taskResolver;
    @Nullable
    private final TemporaryFileProvider temporaryFileProvider;
    private final Instantiator instantiator;
    private final Deleter deleter;
    private final DefaultResourceHandler resourceHandler;
    private final StreamHasher streamHasher;
    private final FileHasher fileHasher;
    private final FileCopier fileCopier;
    private final FileSystem fileSystem;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final FileCollectionFactory fileCollectionFactory;

    public DefaultFileOperations(FileResolver fileResolver, @Nullable TaskResolver taskResolver, @Nullable TemporaryFileProvider temporaryFileProvider, Instantiator instantiator, FileLookup fileLookup, DirectoryFileTreeFactory directoryFileTreeFactory, StreamHasher streamHasher, FileHasher fileHasher, @Nullable TextResourceLoader textResourceLoader, FileCollectionFactory fileCollectionFactory, FileSystem fileSystem, Clock clock) {
        this.fileCollectionFactory = fileCollectionFactory;
        this.fileResolver = fileResolver;
        this.taskResolver = taskResolver;
        this.temporaryFileProvider = temporaryFileProvider;
        this.instantiator = instantiator;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.resourceHandler = new DefaultResourceHandler(this, new DefaultResourceResolver(fileResolver, fileSystem), temporaryFileProvider, textResourceLoader);
        this.streamHasher = streamHasher;
        this.fileHasher = fileHasher;
        this.fileCopier = new FileCopier(this.instantiator, fileSystem, this.fileResolver, fileLookup, directoryFileTreeFactory);
        this.fileSystem = fileSystem;
        this.deleter = new Deleter(fileResolver, fileSystem, clock);
    }

    @Override
    public File file(Object path) {
        return this.fileResolver.resolve(path);
    }

    @Override
    public File file(Object path, PathValidation validation) {
        return this.fileResolver.resolve(path, validation);
    }

    @Override
    public URI uri(Object path) {
        return this.fileResolver.resolveUri(path);
    }

    @Override
    public ConfigurableFileCollection configurableFiles(Object ... paths) {
        return this.fileCollectionFactory.configurableFiles().from(paths);
    }

    @Override
    public FileCollection immutableFiles(Object ... paths) {
        return this.fileCollectionFactory.resolving(paths);
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir) {
        return new DefaultConfigurableFileTree(baseDir, this.fileResolver, this.taskResolver, this.directoryFileTreeFactory);
    }

    @Override
    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        return new DefaultConfigurableFileTree(args, this.fileResolver, this.taskResolver, this.directoryFileTreeFactory);
    }

    @Override
    public FileTree zipTree(Object zipPath) {
        return new FileTreeAdapter((MinimalFileTree)new ZipFileTree(this.file(zipPath), this.getExpandDir(), (Chmod)this.fileSystem, this.directoryFileTreeFactory, this.fileHasher), this.fileResolver.getPatternSetFactory());
    }

    @Override
    public FileTree tarTree(Object tarPath) {
        ReadableResourceInternal resource;
        File tarFile = null;
        if (tarPath instanceof ReadableResourceInternal) {
            resource = (ReadableResourceInternal)tarPath;
        } else if (tarPath instanceof ReadableResource) {
            resource = new UnknownBackingFileReadableResource((ReadableResource)tarPath);
        } else {
            tarFile = this.file(tarPath);
            resource = new LocalResourceAdapter((LocalBinaryResource)new LocalFileStandInExternalResource(tarFile, this.fileSystem));
        }
        TarFileTree tarTree = new TarFileTree(tarFile, new MaybeCompressedFileResource(resource), this.getExpandDir(), (Chmod)this.fileSystem, (Stat)this.fileSystem, this.directoryFileTreeFactory, this.streamHasher, this.fileHasher);
        return new FileTreeAdapter((MinimalFileTree)tarTree, this.fileResolver.getPatternSetFactory());
    }

    private File getExpandDir() {
        return this.temporaryFileProvider.newTemporaryFile("expandedArchives");
    }

    @Override
    public String relativePath(Object path) {
        return this.fileResolver.resolveAsRelativePath(path);
    }

    @Override
    public File mkdir(Object path) {
        File dir = this.fileResolver.resolve(path);
        if (dir.isFile()) {
            throw new InvalidUserDataException(String.format("Can't create directory. The path=%s points to an existing file.", path));
        }
        GFileUtils.mkdirs((File)dir);
        return dir;
    }

    @Override
    public boolean delete(Object ... paths) {
        return this.deleter.delete(paths);
    }

    @Override
    public WorkResult delete(Action<? super DeleteSpec> action) {
        return this.deleter.delete(action);
    }

    @Override
    public WorkResult copy(Action<? super CopySpec> action) {
        return this.fileCopier.copy(action);
    }

    @Override
    public WorkResult sync(Action<? super CopySpec> action) {
        return this.fileCopier.sync(action);
    }

    public CopySpec copySpec(Action<? super CopySpec> action) {
        CopySpec copySpec = this.copySpec();
        action.execute((Object)copySpec);
        return copySpec;
    }

    @Override
    public CopySpec copySpec() {
        return (CopySpec)this.instantiator.newInstance(DefaultCopySpec.class, new Object[]{this.fileResolver, this.instantiator});
    }

    @Override
    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    @Override
    public DefaultResourceHandler getResources() {
        return this.resourceHandler;
    }
}

