/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fileformats;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.services.ProgramManager;
import ghidra.file.crypto.CryptoKeyFileTemplateWriter;
import ghidra.file.eclipse.AndroidProjectCreator;
import ghidra.file.formats.ios.prelink.PrelinkFileSystem;
import ghidra.file.jad.JadProcessWrapper;
import ghidra.file.jad.JarDecompiler;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.framework.main.FrontEndable;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBDirNode;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import ghidra.plugins.fsbrowser.FSBUtils;
import ghidra.plugins.fsbrowser.ImageManager;
import ghidra.plugins.fsbrowser.tasks.GFileSystemLoadKernelTask;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.io.FilenameUtils;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="File format actions", description="This plugin provides file format related actions to the File System Browser.")
public class FileFormatsPlugin
extends Plugin
implements FrontEndable {
    private GhidraFileChooser chooserEclipse;
    private GhidraFileChooser chooserJarFolder;
    private List<DockingAction> actions = new ArrayList<DockingAction>();

    public FileFormatsPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        this.actions.add(this.createEclipseProjectAction());
        this.actions.add(this.createDecompileJarAction());
        this.actions.add(this.createCryptoTemplateAction());
        this.actions.add(this.createLoadKernelAction());
        this.actions.forEach(action -> this.getTool().addAction((DockingActionIf)action));
    }

    protected void dispose() {
        super.dispose();
        this.actions.forEach(action -> this.getTool().removeAction((DockingActionIf)action));
    }

    private boolean isAPK(FSRL fsrl) {
        return fsrl != null && fsrl.getName() != null && "apk".equalsIgnoreCase(FilenameUtils.getExtension((String)fsrl.getName()));
    }

    private void doExportToEclipse(FSRL fsrl, File outputDirectory, TaskMonitor monitor) {
        try (RefdFile refdFile = FileSystemService.getInstance().getRefdFile(fsrl, monitor);){
            AndroidProjectCreator creator = new AndroidProjectCreator(refdFile.file.getFSRL(), outputDirectory);
            creator.create(monitor);
            if (creator.getLog().hasMessages()) {
                Msg.showInfo((Object)((Object)this), (Component)this.getTool().getActiveWindow(), (String)"Export to Eclipse Project", (Object)creator.getLog().toString());
            }
        }
        catch (CancelledException | IOException e) {
            FSUtilities.displayException((Object)((Object)this), (Component)this.getTool().getActiveWindow(), (String)"Error Exporting to Eclipse", (String)e.getMessage(), (Throwable)e);
        }
    }

    private DockingAction createEclipseProjectAction() {
        return (DockingAction)new ActionBuilder("FSB Export Eclipse Project", this.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && JadProcessWrapper.isJadPresent() && this.isAPK(ac.getFileFSRL())).popupMenuPath(new String[]{"Export Eclipse Project"}).popupMenuIcon((Icon)ImageManager.ECLIPSE).popupMenuGroup("H").onAction(ac -> {
            FSRL fsrl = ac.getFileFSRL();
            if (fsrl == null) {
                Msg.info((Object)((Object)this), (Object)"Unable to export eclipse project");
                return;
            }
            if (this.chooserEclipse == null) {
                this.chooserEclipse = new GhidraFileChooser(null);
            }
            this.chooserEclipse.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
            this.chooserEclipse.setTitle("Select Eclipe Project Directory");
            this.chooserEclipse.setApproveButtonText("SELECT");
            this.chooserEclipse.setSelectedFile(null);
            File outputDirectory = this.chooserEclipse.getSelectedFile();
            if (outputDirectory == null) {
                return;
            }
            GTree gTree = ac.getTree();
            gTree.runTask(monitor -> this.doExportToEclipse(fsrl, outputDirectory, monitor));
        }).build();
    }

    private DockingAction createDecompileJarAction() {
        return (DockingAction)new ActionBuilder("FSB Decompile JAR", this.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && JadProcessWrapper.isJadPresent() && ac.getFileFSRL() != null).popupMenuPath(new String[]{"Decompile JAR"}).popupMenuIcon((Icon)ImageManager.JAR).popupMenuGroup("J").onAction(ac -> {
            FSRL jarFSRL = ac.getFileFSRL();
            if (jarFSRL == null) {
                return;
            }
            if (this.chooserJarFolder == null) {
                this.chooserJarFolder = new GhidraFileChooser(null);
            }
            this.chooserJarFolder.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
            this.chooserJarFolder.setTitle("Select JAR Output Directory");
            this.chooserJarFolder.setApproveButtonText("SELECT");
            this.chooserJarFolder.setSelectedFile(null);
            File outputDirectory = this.chooserJarFolder.getSelectedFile();
            if (outputDirectory == null) {
                return;
            }
            GTree gTree = ac.getTree();
            gTree.runTask(monitor -> {
                try {
                    JarDecompiler decompiler = new JarDecompiler(jarFSRL, outputDirectory);
                    decompiler.decompile(monitor);
                    if (decompiler.getLog().hasMessages()) {
                        Msg.showInfo((Object)((Object)this), (Component)gTree, (String)("Decompiling Jar " + jarFSRL.getName()), (Object)decompiler.getLog().toString());
                    }
                }
                catch (Exception e) {
                    FSUtilities.displayException((Object)((Object)this), (Component)gTree, (String)"Error Decompiling Jar", (String)e.getMessage(), (Throwable)e);
                }
            });
        }).build();
    }

    private DockingAction createCryptoTemplateAction() {
        return (DockingAction)new ActionBuilder("FSB Create Crypto Key Template", this.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getSelectedNode() instanceof FSBRootNode && ac.getFSRL(true) != null).popupMenuPath(new String[]{"Create Crypto Key Template..."}).popupMenuGroup("Z", "B").onAction(ac -> {
            FSRL fsrl = ac.getFSRL(true);
            if (ac.getSelectedNode() instanceof FSBRootNode && fsrl != null) {
                this.createCryptoTemplate(fsrl, (FSBRootNode)ac.getSelectedNode());
            }
        }).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCryptoTemplate(FSRL fsrl, FSBRootNode node) {
        try {
            int answer;
            String fsContainerName = fsrl.getFS().getContainer().getName();
            CryptoKeyFileTemplateWriter writer = new CryptoKeyFileTemplateWriter(fsContainerName);
            if (writer.exists() && (answer = OptionDialog.showYesNoDialog((Component)this.getTool().getActiveWindow(), (String)"WARNING!! Crypto Key File Already Exists", (String)"WARNING!!\nThe crypto key file already exists. Are you really sure that you want to overwrite it?")) == 2) {
                return;
            }
            writer.open();
            try {
                this.writeFile(writer, node.getChildren());
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            FSUtilities.displayException((Object)((Object)this), (Component)this.getTool().getActiveWindow(), (String)"Error writing crypt key file", (String)e.getMessage(), (Throwable)e);
        }
    }

    private void writeFile(CryptoKeyFileTemplateWriter writer, List<GTreeNode> children) throws IOException {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (GTreeNode child : children) {
            if (child instanceof FSBFileNode) {
                FSRL childFSRL = ((FSBFileNode)child).getFSRL();
                writer.write(childFSRL.getName());
                continue;
            }
            this.writeFile(writer, child.getChildren());
        }
    }

    private DockingAction createLoadKernelAction() {
        return (DockingAction)new ActionBuilder("FSB Load iOS Kernel", this.getName()).withContext(FSBActionContext.class).enabledWhen(ac -> {
            if (ac.isBusy()) {
                return false;
            }
            FSBRootNode rootNode = ac.getRootOfSelectedNode();
            return rootNode != null && rootNode.getFSRef() != null && rootNode.getFSRef().getFilesystem() instanceof PrelinkFileSystem;
        }).popupMenuPath(new String[]{"Load iOS Kernel"}).popupMenuIcon((Icon)ImageManager.iOS).popupMenuGroup("I").onAction(ac -> {
            FSRL fsrl = ac.getFSRL(true);
            ArrayList<FSRL> fileList = new ArrayList<FSRL>();
            if (fsrl != null) {
                FSBNode selectedNode = ac.getSelectedNode();
                if (selectedNode instanceof FSBRootNode) {
                    for (GTreeNode childNode : ac.getSelectedNode().getChildren()) {
                        if (!(childNode instanceof FSBNode)) continue;
                        FSBNode baseNode = (FSBNode)childNode;
                        fileList.add(baseNode.getFSRL());
                    }
                } else if (selectedNode instanceof FSBFileNode || selectedNode instanceof FSBDirNode) {
                    fileList.add(fsrl);
                }
            }
            if (!fileList.isEmpty()) {
                if (OptionDialog.showYesNoDialog(null, (String)"Load iOS Kernel?", (String)"Performing this action will load the entire kernel and all KEXT files.\nDo you want to continue?") == 1) {
                    this.loadIOSKernel(fileList);
                }
            } else {
                this.getTool().setStatusInfo("Load iOS kernel -- nothing to do.");
            }
        }).build();
    }

    private void loadIOSKernel(List<FSRL> fileList) {
        ProgramManager pm = FSBUtils.getProgramManager((PluginTool)this.getTool(), (boolean)true);
        if (pm != null) {
            TaskLauncher.launch((Task)new GFileSystemLoadKernelTask((Plugin)this, pm, fileList));
        }
    }
}

