/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.iso9660;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.iso9660.ISO9660BaseVolume;
import ghidra.file.formats.iso9660.ISO9660Directory;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDateTime;

public class ISO9660VolumeDescriptor
extends ISO9660BaseVolume {
    private byte unused;
    private byte[] systemIdentifier;
    private byte[] volumeIdentifier;
    private long unused2;
    private int volumeSpaceSizeLE;
    private int volumeSpaceSizeBE;
    private byte[] unused3;
    private short volumeSetSizeLE;
    private short volumeSetSizeBE;
    private short volumeSeqNumberLE;
    private short volumeSeqNumberBE;
    private short logicalBlockSizeLE;
    private short logicalBlockSizeBE;
    private int pathTableSizeLE;
    private int pathTableSizeBE;
    private int typeLPathTableLocation;
    private int optionalTypeLPathTableLocation;
    private int typeMPathTableLocation;
    private int optionalTypeMPathTableLocation;
    private ISO9660Directory directoryEntry;
    private byte[] volumeSetIdentifier;
    private byte[] publisherIdentifier;
    private byte[] dataPreparerIdentifier;
    private byte[] applicationIdentifier;
    private byte[] copyrightFileIdentifier;
    private byte[] abstractFileIdentifier;
    private byte[] bibliographicFileIdentifier;
    private byte[] volumeCreationDateTime;
    private byte[] volumeModifyDateTime;
    private byte[] volumeExpirationDateTime;
    private byte[] volumeEffectiveDateTime;
    private byte fileStructureVersion;
    private byte unused4;
    private byte[] applicationUsed;
    private byte[] reserved;

    public ISO9660VolumeDescriptor(BinaryReader reader) throws IOException {
        super(reader);
        this.unused = reader.readNextByte();
        this.systemIdentifier = reader.readNextByteArray(32);
        this.volumeIdentifier = reader.readNextByteArray(32);
        this.unused2 = reader.readNextLong();
        this.volumeSpaceSizeLE = reader.readNextInt();
        this.volumeSpaceSizeBE = this.readIntBigEndian(reader);
        this.unused3 = reader.readNextByteArray(32);
        this.volumeSetSizeLE = reader.readNextShort();
        this.volumeSetSizeBE = this.readShortBigEndian(reader);
        this.volumeSeqNumberLE = reader.readNextShort();
        this.volumeSeqNumberBE = this.readShortBigEndian(reader);
        this.logicalBlockSizeLE = reader.readNextShort();
        this.logicalBlockSizeBE = this.readShortBigEndian(reader);
        this.pathTableSizeLE = reader.readNextInt();
        this.pathTableSizeBE = this.readIntBigEndian(reader);
        this.typeLPathTableLocation = reader.readNextInt();
        this.optionalTypeLPathTableLocation = reader.readNextInt();
        this.typeMPathTableLocation = this.readIntBigEndian(reader);
        this.optionalTypeMPathTableLocation = this.readIntBigEndian(reader);
        this.directoryEntry = new ISO9660Directory(reader);
        this.volumeSetIdentifier = reader.readNextByteArray(128);
        this.publisherIdentifier = reader.readNextByteArray(128);
        this.dataPreparerIdentifier = reader.readNextByteArray(128);
        this.applicationIdentifier = reader.readNextByteArray(128);
        this.copyrightFileIdentifier = reader.readNextByteArray(38);
        this.abstractFileIdentifier = reader.readNextByteArray(36);
        this.bibliographicFileIdentifier = reader.readNextByteArray(37);
        this.volumeCreationDateTime = reader.readNextByteArray(17);
        this.volumeModifyDateTime = reader.readNextByteArray(17);
        this.volumeExpirationDateTime = reader.readNextByteArray(17);
        this.volumeEffectiveDateTime = reader.readNextByteArray(17);
        this.fileStructureVersion = reader.readNextByte();
        this.unused4 = reader.readNextByte();
        this.applicationUsed = reader.readNextByteArray(512);
        this.reserved = reader.readNextByteArray(653);
    }

    private int readIntBigEndian(BinaryReader reader) throws IOException {
        this.setReaderToBigEndian(reader);
        int tmp = reader.readNextInt();
        this.setReaderToLittleEndian(reader);
        return tmp;
    }

    private short readShortBigEndian(BinaryReader reader) throws IOException {
        this.setReaderToBigEndian(reader);
        short tmp = reader.readNextShort();
        this.setReaderToLittleEndian(reader);
        return tmp;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        Object struc = super.getTypeCode() == 1 ? new StructureDataType("ISO9600PrimaryVolumeDescriptor", 0) : (super.getTypeCode() == 2 ? new StructureDataType("ISO9600SupplementaryVolumeDescriptor", 0) : null);
        struc.add(BYTE, "Type Code", "Type of volume descriptor");
        struc.add((DataType)new ArrayDataType(BYTE, super.getIdentifier().length, 1), "Standard Identifier", "Always 'CD001'");
        struc.add(BYTE, "Version", "Always 0x01");
        struc.add(BYTE, "Unused", "Always 0x00");
        struc.add((DataType)new ArrayDataType(BYTE, this.systemIdentifier.length, 1), "System Identifier", "Name of the system to act upon sectors 0x00-0x0F");
        struc.add((DataType)new ArrayDataType(BYTE, this.volumeIdentifier.length, 1), "Volume Identifier", "Identification for this volume");
        struc.add(QWORD, "Unused", "Always 0x00");
        struc.add(QWORD, "Volume Space Size", "Number of logical blocks the volume is recorded");
        struc.add((DataType)new ArrayDataType(BYTE, this.unused3.length, 1), "Unused", "Always 0x00");
        struc.add(DWORD, "Volume Set Size", "Size of the set in this logical volume");
        struc.add(DWORD, "Volume Sequence Number", "Number of disks in volume set");
        struc.add(DWORD, "Logical block Size", "Size of the logical block");
        struc.add(QWORD, "Path Table Size", "Size of the path table");
        struc.add(DWORD, "Location of Type-L Path Dable", "LBA location of the path table containing only litle-endian values");
        struc.add(DWORD, "Location of Optional Type-L Path Table", "LBA location of the optional path table containing only little-endian values");
        struc.add(DWORD, "Location of Type-M Path Table", "LBA location of the path table containing only big-endian values");
        struc.add(DWORD, "Location of Optional Type-M Path Table", "LBA location of the optional path table containing only big-endian values");
        struc.add(this.directoryEntry.toDataType());
        struc.add((DataType)new ArrayDataType(BYTE, this.volumeSetIdentifier.length, 1), "Volume Set Identifier", "Identifier of the volume set which this volume is a member");
        struc.add((DataType)new ArrayDataType(BYTE, this.publisherIdentifier.length, 1), "Publisher Identifier", "The volume publisher");
        struc.add((DataType)new ArrayDataType(BYTE, this.dataPreparerIdentifier.length, 1), "Data Preparer Identifier", "Identifier of person(s) who prepared data for this volume");
        struc.add((DataType)new ArrayDataType(BYTE, this.applicationIdentifier.length, 1), "Application Identifier", "How the data are recorded on this volume");
        struc.add((DataType)new ArrayDataType(BYTE, this.copyrightFileIdentifier.length, 1), "Copyright File Identifier", "Filename of file that contains copyright information on volume set");
        struc.add((DataType)new ArrayDataType(BYTE, this.abstractFileIdentifier.length, 1), "Abstract File Identifier", "Filename of file that contains abstract information on volume set");
        struc.add((DataType)new ArrayDataType(BYTE, this.bibliographicFileIdentifier.length, 1), "Bibliographic File Identifier", "Filename of file that contians bibliographic information on volume set");
        struc.add((DataType)new ArrayDataType(BYTE, this.volumeCreationDateTime.length, 1), "Volume Creation Date and Time", "Date and time volume was created");
        struc.add((DataType)new ArrayDataType(BYTE, this.volumeModifyDateTime.length, 1), "Volume Modification Date and Time", "Date and time volume was modified");
        struc.add((DataType)new ArrayDataType(BYTE, this.volumeExpirationDateTime.length, 1), "Volume Expiration Date and Time", "Date and time volume was created");
        struc.add((DataType)new ArrayDataType(BYTE, this.volumeEffectiveDateTime.length, 1), "Volume Effective Date and Time", "Date and time after which the volume may be used");
        struc.add(BYTE, "File Structure Version", "Directory records and path table version");
        struc.add(BYTE, "Unused", "Always 0x00");
        struc.add((DataType)new ArrayDataType(BYTE, this.applicationUsed.length, 1), "Application Used", "Contents not defined by ISO 9660");
        struc.add((DataType)new ArrayDataType(BYTE, this.reserved.length, 1), "Reserved", "Reserved by ISO");
        return struc;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Type Code: 0x" + Integer.toHexString(super.getTypeCode()) + " => " + this.getTypeCodeString() + "\n");
        buff.append("Standard Identifier: " + new String(super.getIdentifier()).trim() + "\n");
        buff.append("Version: 0x" + Integer.toHexString(super.getVersion()) + "\n");
        buff.append("Unused: 0x" + Integer.toHexString(this.unused) + "\n");
        buff.append("System Identifier: " + new String(this.systemIdentifier).trim() + "\n");
        buff.append("Volume Identifier: " + new String(this.volumeIdentifier).trim() + "\n");
        buff.append("Unused Field: 0x" + Long.toHexString(this.unused2) + "\n");
        buff.append("Volume Space Size: 0x" + Integer.toHexString(this.getVolumeSpaceSizeLE()) + "\n");
        buff.append("Unused: " + new String(this.unused3).trim() + "\n");
        buff.append("Volume Set Size: 0x" + Integer.toHexString(this.getVolumeSetSizeLE()) + "\n");
        buff.append("Volume Sequence Number: 0x" + Integer.toHexString(this.getVolumeSeqNumberLE()) + "\n");
        buff.append("Logical Block Size: 0x" + Integer.toHexString(this.getLogicalBlockSizeLE()) + "\n");
        buff.append("Path Table Size: 0x" + Integer.toHexString(this.getPathTableSizeLE()) + "\n");
        buff.append("LBA Location of Type-L Path Table: 0x" + Integer.toHexString(this.typeLPathTableLocation) + "\n");
        buff.append("LBA Location of Optional Type-L Path Table: 0x" + Integer.toHexString(this.optionalTypeLPathTableLocation) + "\n");
        buff.append("LBA Location of Type-M Path Table: 0x" + Integer.toHexString(this.typeMPathTableLocation) + "\n");
        buff.append("LBA Location of Optional Type-M Path Table: 0x" + Integer.toHexString(this.optionalTypeMPathTableLocation) + "\n");
        buff.append("Calculated Location of Type-L Path Table: 0x" + Integer.toHexString(this.typeLPathTableLocation * this.getLogicalBlockSizeLE()) + "\n");
        buff.append("Calculated Location of Type-M Path Table: 0x" + Integer.toHexString(this.typeMPathTableLocation * this.getLogicalBlockSizeBE()) + "\n");
        buff.append("Directory Entry for Root Directory: \n" + this.directoryEntry.toString() + "\n");
        buff.append("Volume Set Identifier: " + new String(this.volumeSetIdentifier).trim() + "\n");
        buff.append("Publisher Identifier: " + new String(this.publisherIdentifier).trim() + "\n");
        buff.append("Data Preparer Identifier: " + new String(this.dataPreparerIdentifier).trim() + "\n");
        buff.append("Application Identifier: " + new String(this.applicationIdentifier).trim() + "\n");
        buff.append("Copyright File Identifier: " + new String(this.copyrightFileIdentifier).trim() + "\n");
        buff.append("Abstract File Identifier: " + new String(this.abstractFileIdentifier).trim() + "\n");
        buff.append("Biliographic File Identifier: " + new String(this.bibliographicFileIdentifier) + "\n");
        buff.append("Volume Creation Date/Time: " + this.createDateTimeString(this.volumeCreationDateTime) + "\n");
        buff.append("Volume Modification Date/Time: " + this.createDateTimeString(this.volumeModifyDateTime) + "\n");
        buff.append("Volume Expiration Date/Time: " + this.createDateTimeString(this.volumeCreationDateTime) + "\n");
        buff.append("Volume Effective Date/Time: " + this.createDateTimeString(this.volumeEffectiveDateTime) + "\n");
        buff.append("File Structure Version: 0x" + Integer.toHexString(this.fileStructureVersion) + "\n");
        buff.append("Unused: 0x" + Integer.toHexString(this.unused4) + "\n");
        return buff.toString();
    }

    private boolean isDigitsStringValid(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    protected String createDateTimeString(byte[] byteArray) {
        if (byteArray == null || byteArray.length < 17) {
            return "INVALID (truncated or missing)";
        }
        byte timeOffset = byteArray[byteArray.length - 1];
        String bString = new String(byteArray);
        String s1 = bString.substring(0, 4);
        String s2 = bString.substring(4, 6);
        String s3 = bString.substring(6, 8);
        String s4 = bString.substring(8, 10);
        String s5 = bString.substring(10, 12);
        String s6 = bString.substring(12, 14);
        String s7 = bString.substring(14, 16);
        boolean validBuffer = this.isDigitsStringValid(s1) && this.isDigitsStringValid(s2) && this.isDigitsStringValid(s3) && this.isDigitsStringValid(s4) && this.isDigitsStringValid(s5) && this.isDigitsStringValid(s6) && this.isDigitsStringValid(s7);
        try {
            LocalDateTime.of(Integer.parseInt(s1), Integer.parseInt(s2), Integer.parseInt(s3), Integer.parseInt(s4), Integer.parseInt(s5), Integer.parseInt(s6));
        }
        catch (NumberFormatException | DateTimeException e) {
            validBuffer = false;
        }
        if (timeOffset < -48 || timeOffset > 52) {
            validBuffer = false;
        }
        int timezoneIntegral = timeOffset / 4;
        int timezoneFractional = Math.abs(timeOffset) % 4 * 15;
        StringBuilder builder = new StringBuilder();
        if (!validBuffer) {
            builder.append("INVALID(");
        }
        builder.append(String.format("%s-%s-%s %s:%s:%s.%s GMT%c%02d%02d", s1, s2, s3, s4, s5, s6, s7, Character.valueOf(timezoneIntegral < 0 ? (char)'-' : '+'), timezoneIntegral, timezoneFractional));
        if (!validBuffer) {
            builder.append(")");
        }
        return builder.toString();
    }

    public byte getUnused() {
        return this.unused;
    }

    public byte[] getSystemIdentifier() {
        return this.systemIdentifier;
    }

    public byte[] getVolumeIdentifier() {
        return this.volumeIdentifier;
    }

    public long getUnused2() {
        return this.unused2;
    }

    public byte[] getUnused3() {
        return this.unused3;
    }

    public int getVolumeSpaceSizeLE() {
        return this.volumeSpaceSizeLE;
    }

    public int getVolumeSpaceSizeBE() {
        return this.volumeSpaceSizeBE;
    }

    public short getVolumeSetSizeLE() {
        return this.volumeSetSizeLE;
    }

    public short getVolumeSetSizeBE() {
        return this.volumeSetSizeBE;
    }

    public short getVolumeSeqNumberLE() {
        return this.volumeSeqNumberLE;
    }

    public short getVolumeSeqNumberBE() {
        return this.volumeSeqNumberBE;
    }

    public short getLogicalBlockSizeLE() {
        return this.logicalBlockSizeLE;
    }

    public short getLogicalBlockSizeBE() {
        return this.logicalBlockSizeBE;
    }

    public int getPathTableSizeLE() {
        return this.pathTableSizeLE;
    }

    public int getPathTableSizeBE() {
        return this.pathTableSizeBE;
    }

    public int getTypeLPathTableLocation() {
        return this.typeLPathTableLocation;
    }

    public int getOptionalTypeLPathTableLocation() {
        return this.optionalTypeLPathTableLocation;
    }

    public int getTypeMPathTableLocation() {
        return this.typeMPathTableLocation;
    }

    public int getOptionalTypeMPathTableLocation() {
        return this.optionalTypeMPathTableLocation;
    }

    public ISO9660Directory getDirectoryEntry() {
        return this.directoryEntry;
    }

    public byte[] getVolumeSetIdentifier() {
        return this.volumeSetIdentifier;
    }

    public byte[] getPublisherIdentifier() {
        return this.publisherIdentifier;
    }

    public byte[] getDataPreparerIdentifier() {
        return this.dataPreparerIdentifier;
    }

    public byte[] getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    public byte[] getCopyrightFileIdentifier() {
        return this.copyrightFileIdentifier;
    }

    public byte[] getAbstractFileIdentifier() {
        return this.abstractFileIdentifier;
    }

    public byte[] getBibliographicFileIdentifier() {
        return this.bibliographicFileIdentifier;
    }

    public byte[] getVolumeCreationDateTime() {
        return this.volumeCreationDateTime;
    }

    public byte[] getVolumeModifyDateTime() {
        return this.volumeModifyDateTime;
    }

    public byte[] getVolumeExpirationDateTime() {
        return this.volumeExpirationDateTime;
    }

    public byte[] getVolumeEffectiveDateTime() {
        return this.volumeEffectiveDateTime;
    }

    public byte getFileStructureVersion() {
        return this.fileStructureVersion;
    }

    public byte getUnused4() {
        return this.unused4;
    }

    public byte[] getApplicationUsed() {
        return this.applicationUsed;
    }

    public byte[] getReserved() {
        return this.reserved;
    }

    private void setReaderToBigEndian(BinaryReader reader) {
        reader.setLittleEndian(false);
    }

    private void setReaderToLittleEndian(BinaryReader reader) {
        reader.setLittleEndian(true);
    }
}

