/*
 * Decompiled with CFR 0.152.
 */
package ghidra.service.graph;

import docking.action.DockingActionIf;
import docking.widgets.EventTrigger;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Set;

public interface GraphDisplay {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final String SELECTED_VERTEX_COLOR = "selectedVertexColor";
    public static final String SELECTED_EDGE_COLOR = "selectedEdgeColor";
    public static final String INITIAL_LAYOUT_ALGORITHM = "initialLayoutAlgorithm";
    public static final String DISPLAY_VERTICES_AS_ICONS = "displayVerticesAsIcons";
    public static final String VERTEX_LABEL_POSITION = "vertexLabelPosition";
    public static final String ENABLE_EDGE_SELECTION = "enableEdgeSelection";
    public static final String EDGE_TYPE_PRIORITY_LIST = "edgeTypePriorityList";
    public static final String FAVORED_EDGES = "favoredEdges";

    public void setGraphDisplayListener(GraphDisplayListener var1);

    public void setFocusedVertex(AttributedVertex var1, EventTrigger var2);

    public AttributedGraph getGraph();

    public AttributedVertex getFocusedVertex();

    public void selectVertices(Set<AttributedVertex> var1, EventTrigger var2);

    public Set<AttributedVertex> getSelectedVertices();

    public void close();

    default public void setGraph(AttributedGraph graph, String title, boolean append, TaskMonitor monitor) throws CancelledException {
        this.setGraph(graph, new GraphDisplayOptions(graph.getGraphType()), title, append, monitor);
    }

    public void setGraph(AttributedGraph var1, GraphDisplayOptions var2, String var3, boolean var4, TaskMonitor var5) throws CancelledException;

    public void clear();

    public void updateVertexName(AttributedVertex var1, String var2);

    public String getGraphTitle();

    public void addAction(DockingActionIf var1);
}

