/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.DynamicVariableStorage;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.DynamicEntry;
import ghidra.program.model.pcode.EquateSymbol;
import ghidra.program.model.pcode.HighCodeSymbol;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.MappedDataEntry;
import ghidra.program.model.pcode.MappedEntry;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.SymbolEntry;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class HighSymbol {
    public static final long ID_BASE = 0x4000000000000000L;
    protected String name;
    protected DataType type;
    protected HighFunction function;
    protected int category;
    protected int categoryIndex;
    private boolean namelock;
    private boolean typelock;
    private boolean isThis;
    private boolean isHidden;
    private long id;
    protected SymbolEntry[] entryList;
    private HighVariable highVariable;
    private PcodeDataTypeManager dtmanage;

    protected HighSymbol(HighFunction func) {
        this.function = func;
        this.dtmanage = this.function.getDataTypeManager();
        this.isThis = false;
        this.isHidden = false;
    }

    protected HighSymbol(long uniqueId, String nm, DataType tp, HighFunction func) {
        this.function = func;
        this.dtmanage = this.function.getDataTypeManager();
        this.name = nm;
        this.type = tp;
        this.namelock = false;
        this.typelock = false;
        this.isThis = false;
        this.isHidden = false;
        this.id = uniqueId;
        this.category = -1;
        this.categoryIndex = -1;
    }

    protected HighSymbol(long uniqueId, String nm, DataType tp, boolean tlock, boolean nlock, PcodeDataTypeManager manage) {
        this.function = null;
        this.dtmanage = manage;
        this.name = nm;
        this.type = tp;
        this.namelock = nlock;
        this.typelock = tlock;
        this.isThis = false;
        this.isHidden = false;
        this.id = uniqueId;
        this.category = -1;
        this.categoryIndex = -1;
    }

    protected void addMapEntry(SymbolEntry entry) {
        if (this.entryList == null) {
            this.entryList = new SymbolEntry[1];
            this.entryList[0] = entry;
            if (entry.getStorage().isAutoStorage()) {
                AutoParameterType autoType = entry.getStorage().getAutoParameterType();
                if (autoType == AutoParameterType.THIS) {
                    this.isThis = true;
                } else if (autoType == AutoParameterType.RETURN_STORAGE_PTR) {
                    this.isHidden = true;
                }
            }
        } else {
            SymbolEntry[] newList = new SymbolEntry[this.entryList.length + 1];
            for (int i = 0; i < this.entryList.length; ++i) {
                newList[i] = this.entryList[i];
            }
            newList[this.entryList.length] = entry;
            this.entryList = newList;
        }
    }

    public long getId() {
        return this.id;
    }

    public Symbol getSymbol() {
        if (this.id != 0L) {
            return this.getProgram().getSymbolTable().getSymbol(this.id);
        }
        return null;
    }

    public Namespace getNamespace() {
        Symbol sym = this.getSymbol();
        if (sym != null) {
            return sym.getParentNamespace();
        }
        return null;
    }

    public void setHighVariable(HighVariable high) {
        this.highVariable = high;
    }

    public HighVariable getHighVariable() {
        return this.highVariable;
    }

    public String getName() {
        return this.name;
    }

    public Program getProgram() {
        return this.dtmanage.getProgram();
    }

    public DataType getDataType() {
        return this.type;
    }

    public int getSize() {
        return this.entryList[0].getSize();
    }

    public Address getPCAddress() {
        return this.entryList[0].pcaddr;
    }

    protected int getFirstUseOffset() {
        Address pcaddr = this.entryList[0].pcaddr;
        if (pcaddr == null) {
            return 0;
        }
        return (int)pcaddr.subtract(this.getHighFunction().getFunction().getEntryPoint());
    }

    public HighFunction getHighFunction() {
        return this.function;
    }

    protected void setCategory(int cat, int index) {
        this.category = cat;
        this.categoryIndex = index;
    }

    public void setTypeLock(boolean typelock) {
        this.typelock = typelock;
    }

    public void setNameLock(boolean namelock) {
        this.namelock = namelock;
    }

    public boolean isTypeLocked() {
        return this.typelock;
    }

    public boolean isNameLocked() {
        return this.namelock;
    }

    public boolean isIsolated() {
        return this.typelock;
    }

    public boolean isReadOnly() {
        return this.entryList[0].isReadOnly();
    }

    public boolean isParameter() {
        return this.category == 0;
    }

    public int getCategoryIndex() {
        return this.categoryIndex;
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean isThisPointer() {
        return this.isThis;
    }

    public boolean isHiddenReturn() {
        return this.isHidden;
    }

    public SymbolEntry getFirstWholeMap() {
        return this.entryList[0];
    }

    public VariableStorage getStorage() {
        return this.entryList[0].getStorage();
    }

    protected void saveXMLHeader(StringBuilder buf) {
        if (this.id >> 56 != 64L) {
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"id", (long)this.id);
        }
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)buf, (String)"name", (String)this.name);
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)buf, (String)"typelock", (boolean)this.typelock);
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)buf, (String)"namelock", (boolean)this.namelock);
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)buf, (String)"readonly", (boolean)this.isReadOnly());
        boolean isVolatile = this.entryList[0].isVolatile();
        if (isVolatile) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)buf, (String)"volatile", (boolean)true);
        }
        if (this.isIsolated()) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)buf, (String)"merge", (boolean)false);
        }
        if (this.isThis) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)buf, (String)"thisptr", (boolean)true);
        }
        if (this.isHidden) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)buf, (String)"hiddenretparm", (boolean)true);
        }
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buf, (String)"cat", (long)this.category);
        if (this.categoryIndex >= 0) {
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buf, (String)"index", (long)this.categoryIndex);
        }
    }

    public void saveXML(StringBuilder buf) {
        buf.append("<symbol");
        this.saveXMLHeader(buf);
        buf.append(">\n");
        this.dtmanage.buildTypeRef(buf, this.type, this.getSize());
        buf.append("</symbol>\n");
    }

    protected void restoreXMLHeader(XmlElement symel) throws PcodeXMLException {
        this.id = SpecXmlUtils.decodeLong((String)symel.getAttribute("id"));
        if (this.id == 0L) {
            throw new PcodeXMLException("missing unique symbol id");
        }
        this.typelock = false;
        String typelockstr = symel.getAttribute("typelock");
        if (typelockstr != null && SpecXmlUtils.decodeBoolean((String)typelockstr)) {
            this.typelock = true;
        }
        this.namelock = false;
        String namelockstr = symel.getAttribute("namelock");
        if (namelockstr != null && SpecXmlUtils.decodeBoolean((String)namelockstr)) {
            this.namelock = true;
        }
        this.isThis = false;
        String thisstring = symel.getAttribute("thisptr");
        if (thisstring != null && SpecXmlUtils.decodeBoolean((String)thisstring)) {
            this.isThis = true;
        }
        this.isHidden = false;
        String hiddenstring = symel.getAttribute("hiddenretparm");
        if (hiddenstring != null && SpecXmlUtils.decodeBoolean((String)hiddenstring)) {
            this.isHidden = true;
        }
        this.name = symel.getAttribute("name");
        this.categoryIndex = -1;
        this.category = -1;
        if (symel.hasAttribute("cat")) {
            this.category = SpecXmlUtils.decodeInt((String)symel.getAttribute("cat"));
            if (this.category == 0) {
                this.categoryIndex = SpecXmlUtils.decodeInt((String)symel.getAttribute("index"));
            }
        }
    }

    public void restoreXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement symel = parser.start(new String[]{"symbol"});
        this.restoreXMLHeader(symel);
        this.type = this.dtmanage.readXMLDataType(parser);
        parser.end(symel);
        if (this.categoryIndex >= 0 && this.name.startsWith("$$undef")) {
            this.name = "param_" + Integer.toString(this.categoryIndex + 1);
        }
        while (parser.peek().isStart()) {
            XmlElement el = parser.peek();
            SymbolEntry entry = el.getName().equals("hash") ? new DynamicEntry(this) : (this instanceof HighCodeSymbol ? new MappedDataEntry(this) : new MappedEntry(this));
            ((SymbolEntry)entry).restoreXML(parser);
            this.addMapEntry(entry);
        }
        if ((this.isThis || this.isHidden) && this.entryList != null) {
            SymbolEntry entry = this.entryList[0];
            VariableStorage storage = entry.getStorage();
            AutoParameterType autoType = this.isThis ? AutoParameterType.THIS : AutoParameterType.RETURN_STORAGE_PTR;
            try {
                DynamicVariableStorage newStorage = new DynamicVariableStorage(storage.getProgram(), autoType, storage.getFirstVarnode());
                this.entryList[0] = new MappedEntry(this, newStorage, entry.getPCAdress());
            }
            catch (InvalidInputException e) {
                throw new PcodeXMLException("Unable to parse auto-parameter");
            }
        }
    }

    public static HighSymbol restoreMapSymXML(XmlPullParser parser, boolean isGlobal, HighFunction high) throws PcodeXMLException {
        HighSymbol res = null;
        parser.start(new String[]{"mapsym"});
        XmlElement symel = parser.peek();
        if (symel.getName().equals("equatesymbol")) {
            res = new EquateSymbol(high);
        } else if (!isGlobal) {
            res = new HighSymbol(high);
        }
        res.restoreXML(parser);
        while (parser.peek().isStart()) {
            SymbolEntry entry = parser.peek().getName().equals("hash") ? new DynamicEntry(res) : new MappedEntry(res);
            entry.restoreXML(parser);
            res.addMapEntry(entry);
        }
        parser.end();
        return res;
    }

    public static void buildMapSymXML(StringBuilder res, HighSymbol sym) {
        res.append("<mapsym>\n");
        sym.saveXML(res);
        for (SymbolEntry entry : sym.entryList) {
            entry.saveXml(res);
        }
        res.append("</mapsym>\n");
    }
}

