/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.pcode.BlockCopy;
import ghidra.program.model.pcode.BlockMap;
import ghidra.program.model.pcode.PcodeBlock;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class BlockGraph
extends PcodeBlock {
    private ArrayList<PcodeBlock> list;
    private int maxindex;

    public BlockGraph() {
        this.blocktype = 2;
        this.list = new ArrayList();
        this.maxindex = -1;
    }

    public void addBlock(PcodeBlock bl) {
        int max;
        int min;
        if (bl instanceof BlockGraph) {
            BlockGraph gbl = (BlockGraph)bl;
            min = gbl.index;
            max = gbl.maxindex;
        } else {
            max = min = bl.index;
        }
        if (this.list.isEmpty()) {
            this.index = min;
            this.maxindex = max;
        } else {
            if (min < this.index) {
                this.index = min;
            }
            if (max > this.maxindex) {
                this.maxindex = max;
            }
        }
        bl.parent = this;
        this.list.add(bl);
    }

    public void setIndices() {
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get((int)i).index = i;
        }
        this.index = 0;
        this.maxindex = this.list.size() - 1;
    }

    public int getSize() {
        return this.list.size();
    }

    public PcodeBlock getBlock(int i) {
        return this.list.get(i);
    }

    public void addEdge(PcodeBlock begin, PcodeBlock end) {
        end.addInEdge(begin, 0);
    }

    public void transferObjectRef(BlockGraph ingraph) {
        ArrayList<BlockGraph> queue = new ArrayList<BlockGraph>();
        int pos = 0;
        queue.add(this);
        while (pos < queue.size()) {
            BlockGraph curgraph = (BlockGraph)queue.get(pos);
            ++pos;
            int sz = curgraph.getSize();
            for (int i = 0; i < sz; ++i) {
                PcodeBlock block = curgraph.getBlock(i);
                if (block instanceof BlockCopy) {
                    PcodeBlock block2;
                    BlockCopy copyblock = (BlockCopy)block;
                    int altindex = copyblock.getAltIndex();
                    if (altindex >= ingraph.getSize() || !((block2 = ingraph.getBlock(altindex)) instanceof BlockCopy)) continue;
                    BlockCopy copyblock2 = (BlockCopy)block2;
                    copyblock.set(copyblock2.getRef(), copyblock2.getStart());
                    continue;
                }
                if (!(block instanceof BlockGraph)) continue;
                queue.add((BlockGraph)block);
            }
        }
    }

    @Override
    public void saveXmlBody(Writer writer) throws IOException {
        PcodeBlock bl;
        int i;
        super.saveXmlBody(writer);
        for (i = 0; i < this.list.size(); ++i) {
            bl = this.list.get(i);
            StringBuilder buf = new StringBuilder();
            buf.append("<bhead");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buf, (String)"index", (long)bl.getIndex());
            String name = PcodeBlock.typeToName(bl.blocktype);
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"type", (String)name);
            buf.append("/>\n");
            writer.write(buf.toString());
        }
        for (i = 0; i < this.list.size(); ++i) {
            bl = this.list.get(i);
            bl.saveXml(writer);
        }
    }

    @Override
    public void restoreXmlBody(XmlPullParser parser, BlockMap resolver) throws PcodeXMLException {
        BlockMap newresolver = new BlockMap(resolver);
        super.restoreXmlBody(parser, newresolver);
        ArrayList<PcodeBlock> tmplist = new ArrayList<PcodeBlock>();
        while (parser.peek().isStart() && parser.peek().getName().equals("bhead")) {
            XmlElement el = parser.start(new String[0]);
            int ind = SpecXmlUtils.decodeInt((String)el.getAttribute("index"));
            String name = el.getAttribute("type");
            PcodeBlock newbl = newresolver.createBlock(name, ind);
            tmplist.add(newbl);
            parser.end(el);
        }
        newresolver.sortLevelList();
        for (int i = 0; i < tmplist.size(); ++i) {
            PcodeBlock bl = (PcodeBlock)tmplist.get(i);
            bl.restoreXml(parser, newresolver);
            this.addBlock(bl);
        }
    }

    public void restoreXml(XmlPullParser parser, AddressFactory factory) throws PcodeXMLException {
        BlockMap resolver = new BlockMap(factory);
        this.restoreXml(parser, resolver);
        resolver.resolveGotoReferences();
    }
}

