/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.util.xml.SpecXmlUtils;
import java.nio.charset.Charset;

public abstract class ConstantPool {
    public static final int PRIMITIVE = 0;
    public static final int STRING_LITERAL = 1;
    public static final int CLASS_REFERENCE = 2;
    public static final int POINTER_METHOD = 3;
    public static final int POINTER_FIELD = 4;
    public static final int ARRAY_LENGTH = 5;
    public static final int INSTANCE_OF = 6;
    public static final int CHECK_CAST = 7;

    public abstract Record getRecord(long[] var1);

    public static class Record {
        public int tag;
        public String token;
        public long value;
        public byte[] byteData;
        public DataType type;
        public boolean isConstructor = false;

        public StringBuilder build(long ref, PcodeDataTypeManager dtmanage) {
            StringBuilder buf = new StringBuilder();
            buf.append("<cpoolrec");
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"ref", (long)ref);
            if (this.tag == 1) {
                SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"tag", (String)"string");
            } else if (this.tag == 2) {
                SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"tag", (String)"classref");
            } else if (this.tag == 3) {
                SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"tag", (String)"method");
            } else if (this.tag == 4) {
                SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"tag", (String)"field");
            } else if (this.tag == 5) {
                SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"tag", (String)"arraylength");
            } else if (this.tag == 6) {
                SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"tag", (String)"instanceof");
            } else if (this.tag == 7) {
                SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"tag", (String)"checkcast");
            } else {
                SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"tag", (String)"primitive");
            }
            if (this.isConstructor) {
                SpecXmlUtils.encodeBooleanAttribute((StringBuilder)buf, (String)"constructor", (boolean)true);
            }
            buf.append(">\n");
            if (this.tag == 0) {
                buf.append("<value>");
                buf.append(SpecXmlUtils.encodeUnsignedInteger((long)this.value));
                buf.append("</value>\n");
            }
            if (this.byteData != null) {
                buf.append("<data length=\"").append(this.byteData.length).append("\">\n");
                int wrap = 0;
                for (byte val : this.byteData) {
                    int hival = val >> 4 & 0xF;
                    char hi = (char)(hival > 9 ? hival - 10 + 97 : hival + 48);
                    int loval = val & 0xF;
                    char lo = (char)(loval > 9 ? loval - 10 + 97 : loval + 48);
                    buf.append(hi).append(lo).append(' ');
                    if (++wrap <= 15) continue;
                    buf.append('\n');
                    wrap = 0;
                }
                buf.append("</data>\n");
            } else {
                buf.append("<token>");
                SpecXmlUtils.xmlEscape((StringBuilder)buf, (String)this.token);
                buf.append("</token>\n");
            }
            dtmanage.buildTypeRef(buf, this.type, this.type.getLength());
            buf.append("</cpoolrec>\n");
            return buf;
        }

        public void setUTF8Data(String val) {
            this.byteData = val.getBytes(Charset.forName("UTF-8"));
        }
    }
}

