/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.util;

import db.DBHandle;
import db.DBListener;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.Table;
import db.util.ErrorHandler;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.KeyRange;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class AddressRangeMapDB
implements DBListener {
    private String tableName;
    private DBHandle dbHandle;
    private AddressMap addrMap;
    private ErrorHandler errHandler;
    private Field valueField;
    private boolean indexed;
    private Table rangeMapTable;
    private Schema rangeMapSchema;
    private Address lastStart;
    private Address lastEnd;
    private Field lastValue;
    private AddressRange lastRange;
    private int modCount;
    public static final String RANGE_MAP_TABLE_PREFIX = "Range Map - ";
    private static final int TO_COL = 0;
    private static final int VALUE_COL = 1;
    private static final String[] COLUMN_NAMES = new String[]{"To", "Value"};
    private static final int[] INDEXED_COLUMNS = new int[]{1};
    private final Lock lock;

    public AddressRangeMapDB(DBHandle dbHandle, AddressMap addrMap, Lock lock, String name, ErrorHandler errHandler, Field valueField, boolean indexed) {
        this.dbHandle = dbHandle;
        this.addrMap = addrMap;
        this.lock = lock;
        this.errHandler = errHandler;
        this.valueField = valueField;
        this.indexed = indexed;
        this.tableName = RANGE_MAP_TABLE_PREFIX + name;
        this.findTable();
        dbHandle.addListener((DBListener)this);
    }

    public boolean setName(String newName) throws DuplicateNameException {
        String newTableName = RANGE_MAP_TABLE_PREFIX + newName;
        if (this.rangeMapTable == null || this.rangeMapTable.setName(newTableName)) {
            this.tableName = newTableName;
            return true;
        }
        return false;
    }

    public static boolean exists(DBHandle dbHandle, String name) {
        return dbHandle.getTable(RANGE_MAP_TABLE_PREFIX + name) != null;
    }

    public boolean isEmpty() {
        this.lock.acquire();
        try {
            boolean bl = this.rangeMapTable == null || this.rangeMapTable.getRecordCount() == 0;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    public int getRecordCount() {
        return this.rangeMapTable != null ? this.rangeMapTable.getRecordCount() : 0;
    }

    private void findTable() {
        this.rangeMapTable = this.dbHandle.getTable(this.tableName);
        if (this.rangeMapTable != null) {
            int[] indexedCols;
            this.rangeMapSchema = this.rangeMapTable.getSchema();
            Field[] fields = this.rangeMapSchema.getFields();
            if (fields.length != 2 || !fields[1].isSameType(this.valueField)) {
                this.errHandler.dbError(new IOException("Existing range map table has unexpected value class"));
            }
            if (this.indexed && ((indexedCols = this.rangeMapTable.getIndexedColumns()).length != 1 || indexedCols[0] != 1)) {
                this.errHandler.dbError(new IOException("Existing range map table is not indexed"));
            }
        }
    }

    private void createTable() throws IOException {
        this.rangeMapSchema = new Schema(0, "From", new Field[]{LongField.INSTANCE, this.valueField}, COLUMN_NAMES);
        this.rangeMapTable = this.indexed ? this.dbHandle.createTable(this.tableName, this.rangeMapSchema, INDEXED_COLUMNS) : this.dbHandle.createTable(this.tableName, this.rangeMapSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Field getValue(Address addr) {
        block7: {
            block6: {
                this.lock.acquire();
                if (this.rangeMapTable == null) ** GOTO lbl31
                if (this.lastStart == null || addr.compareTo(this.lastStart) < 0 || addr.compareTo(this.lastEnd) > 0) break block6;
                var2_2 = this.lastValue;
                this.lock.release();
                return var2_2;
            }
            index = this.addrMap.getKey(addr, false);
            rec = this.rangeMapTable.getRecordAtOrBefore(index);
            if (rec == null) break block7;
            startAddr = this.addrMap.decodeAddress(rec.getKey());
            endAddr = this.addrMap.decodeAddress(rec.getLongValue(0));
            if (addr.compareTo(startAddr) < 0 || addr.compareTo(endAddr) > 0) break block7;
            value = rec.getFieldValue(1);
            this.lastStart = startAddr;
            this.lastEnd = endAddr;
            this.lastValue = value;
            this.lastRange = new AddressRangeImpl(this.lastStart, this.lastEnd);
            var8_10 = value;
            this.lock.release();
            return var8_10;
        }
        try {
            block8: {
                break block8;
                catch (IOException e) {
                    this.errHandler.dbError(e);
                }
            }
            var2_5 = null;
            return var2_5;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintRange(Address startAddr, Address endAddr, Field value) {
        this.lock.acquire();
        try {
            this.lastStart = startAddr;
            this.lastEnd = endAddr;
            this.lastValue = value;
            this.lastRange = null;
            if (startAddr.compareTo(endAddr) > 0) {
                throw new IllegalArgumentException();
            }
            ++this.modCount;
            for (KeyRange range : this.addrMap.getKeyRanges(startAddr, endAddr, true)) {
                this.paintRange(range.minKey, range.maxKey, value);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        if (length <= 0L) {
            return;
        }
        DBHandle tmpDb = null;
        AddressRangeMapDB tmpMap = null;
        this.lock.acquire();
        try {
            tmpDb = this.dbHandle.getScratchPad();
            tmpMap = new AddressRangeMapDB(tmpDb, this.addrMap, this.lock, "TEMP", this.errHandler, this.valueField, this.indexed);
            Address fromEndAddr = fromAddr.add(length - 1L);
            for (AddressRange range : this.getAddressRanges(fromAddr, fromEndAddr)) {
                monitor.checkCanceled();
                Address minAddr = range.getMinAddress();
                Field value = this.getValue(minAddr);
                long offset = minAddr.subtract(fromAddr);
                minAddr = toAddr.add(offset);
                Address maxAddr = range.getMaxAddress();
                offset = maxAddr.subtract(fromAddr);
                maxAddr = toAddr.add(offset);
                tmpMap.paintRange(minAddr, maxAddr, value);
            }
            this.clearRange(fromAddr, fromEndAddr);
            for (AddressRange range : tmpMap.getAddressRanges()) {
                monitor.checkCanceled();
                Field value = tmpMap.getValue(range.getMinAddress());
                this.paintRange(range.getMinAddress(), range.getMaxAddress(), value);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            if (tmpMap != null) {
                try {
                    tmpDb.deleteTable(tmpMap.tableName);
                }
                catch (IOException iOException) {}
            }
            this.lock.release();
        }
    }

    private void paintRange(long start, long end, Field value) {
        try {
            long to;
            DBRecord rec;
            if (this.rangeMapTable == null) {
                if (value == null) {
                    return;
                }
                this.createTable();
            }
            if (!this.addrMap.isKeyRangeMin(start) && (rec = this.rangeMapTable.getRecordBefore(start)) != null && this.addrMap.hasSameKeyBase(start, to = rec.getLongValue(0))) {
                if (rec.fieldEquals(1, value)) {
                    if (to >= start - 1L) {
                        if (to >= end) {
                            return;
                        }
                        start = rec.getKey();
                        this.rangeMapTable.deleteRecord(start);
                    }
                } else if (to >= start) {
                    rec.setLongValue(0, start - 1L);
                    this.rangeMapTable.putRecord(rec);
                    if (to > end) {
                        rec.setKey(end + 1L);
                        rec.setLongValue(0, to);
                        this.rangeMapTable.putRecord(rec);
                    }
                }
            }
            if (!this.addrMap.isKeyRangeMax(end) && (rec = this.rangeMapTable.getRecord(end + 1L)) != null && rec.fieldEquals(1, value)) {
                end = rec.getLongValue(0);
                this.rangeMapTable.deleteRecord(rec.getKey());
            }
            RecordIterator iter = this.rangeMapTable.iterator(start, end, start);
            while (iter.hasNext()) {
                DBRecord rec2 = iter.next();
                iter.delete();
                long to2 = rec2.getLongValue(0);
                if (to2 <= end) continue;
                if (rec2.fieldEquals(1, value)) {
                    end = to2;
                    continue;
                }
                rec2.setKey(end + 1L);
                this.rangeMapTable.putRecord(rec2);
            }
            if (value != null) {
                DBRecord rec3 = this.rangeMapSchema.createRecord(start);
                rec3.setLongValue(0, end);
                rec3.setField(1, value);
                this.rangeMapTable.putRecord(rec3);
            } else if (this.rangeMapTable.getRecordCount() == 0) {
                this.dbHandle.deleteTable(this.tableName);
                this.rangeMapTable = null;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRange(Address startAddr, Address endAddr) {
        this.lock.acquire();
        try {
            this.lastStart = startAddr;
            this.lastEnd = endAddr;
            this.lastValue = null;
            this.lastRange = null;
            if (startAddr.compareTo(endAddr) > 0) {
                throw new IllegalArgumentException();
            }
            ++this.modCount;
            for (KeyRange range : this.addrMap.getKeyRanges(startAddr, endAddr, false)) {
                this.paintRange(range.minKey, range.maxKey, null);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressSet getAddressSet() {
        this.lock.acquire();
        try {
            AddressSet set = new AddressSet();
            if (this.rangeMapTable != null) {
                try {
                    for (DBRecord rec : this.rangeMapTable) {
                        Address startAddr = this.addrMap.decodeAddress(rec.getKey());
                        Address endAddr = this.addrMap.decodeAddress(rec.getLongValue(0));
                        set.addRange(startAddr, endAddr);
                    }
                }
                catch (IOException e) {
                    this.errHandler.dbError(e);
                }
            }
            AddressSet addressSet = set;
            return addressSet;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressSet getAddressSet(Field value) {
        this.lock.acquire();
        try {
            AddressSet set = new AddressSet();
            if (this.rangeMapTable != null) {
                try {
                    RecordIterator iterator = this.rangeMapTable.indexIterator(1, value, value, true);
                    while (iterator.hasNext()) {
                        DBRecord rec = iterator.next();
                        Address startAddr = this.addrMap.decodeAddress(rec.getKey());
                        Address endAddr = this.addrMap.decodeAddress(rec.getLongValue(0));
                        set.addRange(startAddr, endAddr);
                    }
                }
                catch (IOException e) {
                    this.errHandler.dbError(e);
                }
            }
            AddressSet addressSet = set;
            return addressSet;
        }
        finally {
            this.lock.release();
        }
    }

    public AddressRangeIterator getAddressRanges() {
        return new RangeIterator();
    }

    public AddressRangeIterator getAddressRanges(Address startAddr) {
        return new RangeIterator(startAddr);
    }

    public AddressRangeIterator getAddressRanges(Address startAddr, Address endAddr) {
        return new RangeIterator(startAddr, endAddr);
    }

    public AddressRangeIterator getValueRanges(Field value) {
        return new ValueRangeIterator(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public AddressRange getAddressRangeContaining(Address addr) {
        block10: {
            block9: {
                block8: {
                    this.lock.acquire();
                    if (this.lastRange == null || !this.lastRange.contains(addr)) break block8;
                    var2_2 = this.lastRange;
                    this.lock.release();
                    return var2_2;
                }
                min = addr.getAddressSpace().getMinAddress();
                max = addr.getAddressSpace().getMaxAddress();
                if (this.rangeMapTable == null) ** GOTO lbl38
                addressKeyRecordIterator = new AddressKeyRecordIterator(this.rangeMapTable, this.addrMap, min, addr, addr, true);
                if (!addressKeyRecordIterator.hasPrevious()) ** GOTO lbl26
                rec = addressKeyRecordIterator.previous();
                fromAddr = this.addrMap.decodeAddress(rec.getKey());
                toAddr = this.addrMap.decodeAddress(rec.getLongValue(0));
                if (toAddr.compareTo(addr) < 0) break block9;
                var8_10 = this.lastRange = new AddressRangeImpl(fromAddr, toAddr);
                this.lock.release();
                return var8_10;
            }
            min = toAddr.next();
lbl26:
            // 2 sources

            if (!(addressKeyRecordIterator = new AddressKeyRecordIterator(this.rangeMapTable, this.addrMap, addr, max, addr, true)).hasNext()) ** GOTO lbl38
            rec = addressKeyRecordIterator.next();
            fromAddr = this.addrMap.decodeAddress(rec.getKey());
            toAddr = this.addrMap.decodeAddress(rec.getLongValue(0));
            if (fromAddr.compareTo(addr) != 0) break block10;
            var8_11 = this.lastRange = new AddressRangeImpl(fromAddr, toAddr);
            this.lock.release();
            return var8_11;
        }
        try {
            try {
                max = fromAddr.previous();
lbl38:
                // 3 sources

                this.lastRange = new AddressRangeImpl(min, max);
            }
            catch (IOException e) {
                this.errHandler.dbError(e);
            }
            var2_3 = this.lastRange;
            return var2_3;
        }
        finally {
            this.lock.release();
        }
    }

    public void dbRestored(DBHandle dbh) {
        this.lastStart = null;
        this.lastEnd = null;
        this.lastValue = null;
        this.lastRange = null;
        this.findTable();
    }

    public void dbClosed(DBHandle dbh) {
    }

    public void tableDeleted(DBHandle dbh, Table table) {
        if (table == this.rangeMapTable) {
            this.lastStart = null;
            this.lastEnd = null;
            this.lastValue = null;
            this.lastRange = null;
            this.rangeMapTable = null;
        }
    }

    public void tableAdded(DBHandle dbh, Table table) {
        if (this.tableName.equals(table.getName())) {
            this.rangeMapTable = table;
        }
    }

    public void dispose() {
        block5: {
            this.lock.acquire();
            try {
                if (this.rangeMapTable == null) break block5;
                try {
                    this.dbHandle.deleteTable(this.tableName);
                }
                catch (IOException e) {
                    this.errHandler.dbError(e);
                }
                this.lastStart = null;
                this.lastEnd = null;
                this.lastValue = null;
                this.lastRange = null;
                this.rangeMapTable = null;
            }
            finally {
                this.lock.release();
            }
        }
    }

    private class ValueRangeIterator
    implements AddressRangeIterator {
        RecordIterator recIter;
        DBRecord nextRec;
        private int expectedModCount;

        ValueRangeIterator(Field value) {
            this.expectedModCount = AddressRangeMapDB.this.modCount;
            if (AddressRangeMapDB.this.rangeMapTable != null) {
                try {
                    this.recIter = AddressRangeMapDB.this.rangeMapTable.indexIterator(1, value, value, true);
                }
                catch (IOException e) {
                    AddressRangeMapDB.this.errHandler.dbError(e);
                }
            }
        }

        @Override
        public Iterator<AddressRange> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * Exception decompiling
         */
        @Override
        public boolean hasNext() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AddressRange next() {
            AddressRangeMapDB.this.lock.acquire();
            try {
                if (this.expectedModCount != AddressRangeMapDB.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                AddressRangeImpl range = null;
                if (this.recIter != null) {
                    try {
                        DBRecord rec;
                        if (this.nextRec != null) {
                            rec = this.nextRec;
                            this.nextRec = null;
                        } else {
                            rec = this.recIter.next();
                        }
                        if (rec != null) {
                            Address rangeStart = AddressRangeMapDB.this.addrMap.decodeAddress(rec.getKey());
                            Address rangeEnd = AddressRangeMapDB.this.addrMap.decodeAddress(rec.getLongValue(0));
                            while (this.recIter.hasNext()) {
                                Address nextFrom;
                                this.nextRec = this.recIter.next();
                                Address nextAddr = rangeEnd.addWrap(1L);
                                if (!nextAddr.equals(nextFrom = AddressRangeMapDB.this.addrMap.decodeAddress(rec.getKey()))) break;
                                rangeEnd = AddressRangeMapDB.this.addrMap.decodeAddress(this.nextRec.getLongValue(0));
                                this.nextRec = null;
                            }
                            AddressRangeMapDB.this.lastStart = rangeStart;
                            AddressRangeMapDB.this.lastEnd = rangeEnd;
                            AddressRangeMapDB.this.lastValue = rec.getFieldValue(1);
                            range = new AddressRangeImpl(rangeStart, rangeEnd);
                        }
                    }
                    catch (IOException e) {
                        AddressRangeMapDB.this.errHandler.dbError(e);
                    }
                }
                AddressRangeImpl addressRangeImpl = range;
                return addressRangeImpl;
            }
            finally {
                AddressRangeMapDB.this.lock.release();
            }
        }
    }

    private class RangeIterator
    implements AddressRangeIterator {
        private RecordIterator recIter;
        private DBRecord nextRec;
        private boolean checkStart;
        private long startIndex;
        private boolean checkEnd;
        private long endIndex;
        private int expectedModCount;

        RangeIterator() {
            this.expectedModCount = AddressRangeMapDB.this.modCount;
            if (AddressRangeMapDB.this.rangeMapTable != null) {
                try {
                    this.recIter = new AddressKeyRecordIterator(AddressRangeMapDB.this.rangeMapTable, AddressRangeMapDB.this.addrMap);
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    AddressRangeMapDB.this.errHandler.dbError(e);
                }
            }
        }

        RangeIterator(Address startAddr) {
            this.expectedModCount = AddressRangeMapDB.this.modCount;
            if (AddressRangeMapDB.this.rangeMapTable != null) {
                try {
                    long to;
                    DBRecord rec;
                    this.startIndex = AddressRangeMapDB.this.addrMap.getKey(startAddr, false);
                    if (this.startIndex != -1L && (rec = AddressRangeMapDB.this.rangeMapTable.getRecordBefore(this.startIndex)) != null && AddressRangeMapDB.this.addrMap.hasSameKeyBase(this.startIndex, to = rec.getLongValue(0)) && to >= this.startIndex) {
                        this.nextRec = rec;
                        this.checkStart = true;
                    }
                    this.recIter = new AddressKeyRecordIterator(AddressRangeMapDB.this.rangeMapTable, AddressRangeMapDB.this.addrMap, startAddr, true);
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    AddressRangeMapDB.this.errHandler.dbError(e);
                }
            }
        }

        RangeIterator(Address startAddr, Address endAddr) {
            this.expectedModCount = AddressRangeMapDB.this.modCount;
            if (AddressRangeMapDB.this.rangeMapTable != null) {
                try {
                    long to;
                    DBRecord rec;
                    this.startIndex = AddressRangeMapDB.this.addrMap.getKey(startAddr, false);
                    if (this.startIndex != -1L && (rec = AddressRangeMapDB.this.rangeMapTable.getRecordBefore(this.startIndex)) != null && AddressRangeMapDB.this.addrMap.hasSameKeyBase(this.startIndex, to = rec.getLongValue(0)) && to >= this.startIndex) {
                        this.nextRec = rec;
                        this.checkStart = true;
                    }
                    this.endIndex = AddressRangeMapDB.this.addrMap.getKey(endAddr, false);
                    this.checkEnd = this.endIndex != -1L;
                    this.recIter = new AddressKeyRecordIterator(AddressRangeMapDB.this.rangeMapTable, AddressRangeMapDB.this.addrMap, startAddr, endAddr, startAddr, true);
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    AddressRangeMapDB.this.errHandler.dbError(e);
                }
            }
        }

        @Override
        public Iterator<AddressRange> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * Exception decompiling
         */
        @Override
        public boolean hasNext() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AddressRange next() {
            AddressRangeMapDB.this.lock.acquire();
            try {
                if (this.expectedModCount != AddressRangeMapDB.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                AddressRangeImpl range = null;
                if (this.recIter != null) {
                    try {
                        DBRecord rec;
                        if (this.nextRec != null) {
                            rec = this.nextRec;
                            this.nextRec = null;
                        } else {
                            rec = this.recIter.next();
                        }
                        if (rec != null) {
                            Address rangeEnd;
                            Field value = rec.getFieldValue(1);
                            long fromIndex = rec.getKey();
                            long toIndex = rec.getLongValue(0);
                            if (this.checkStart && AddressRangeMapDB.this.addrMap.hasSameKeyBase(this.startIndex, fromIndex) && fromIndex < this.startIndex) {
                                fromIndex = this.startIndex;
                            }
                            Address rangeStart = AddressRangeMapDB.this.addrMap.decodeAddress(fromIndex);
                            if (this.checkEnd && AddressRangeMapDB.this.addrMap.hasSameKeyBase(this.endIndex, toIndex) && toIndex > this.endIndex) {
                                rangeEnd = AddressRangeMapDB.this.addrMap.decodeAddress(this.endIndex);
                            } else {
                                rangeEnd = AddressRangeMapDB.this.addrMap.decodeAddress(toIndex);
                                while (this.recIter.hasNext()) {
                                    Address nextFrom;
                                    Address nextAddr;
                                    this.nextRec = this.recIter.next();
                                    if (!value.equals((Object)this.nextRec.getFieldValue(1)) || !(nextAddr = rangeEnd.addWrap(1L)).equals(nextFrom = AddressRangeMapDB.this.addrMap.decodeAddress(rec.getKey()))) break;
                                    toIndex = this.nextRec.getLongValue(0);
                                    this.nextRec = null;
                                    if (this.checkEnd && AddressRangeMapDB.this.addrMap.hasSameKeyBase(this.endIndex, toIndex) && toIndex > this.endIndex) {
                                        rangeEnd = AddressRangeMapDB.this.addrMap.decodeAddress(this.endIndex);
                                        break;
                                    }
                                    rangeEnd = AddressRangeMapDB.this.addrMap.decodeAddress(toIndex);
                                }
                            }
                            AddressRangeMapDB.this.lastStart = rangeStart;
                            AddressRangeMapDB.this.lastEnd = rangeEnd;
                            AddressRangeMapDB.this.lastValue = value;
                            range = new AddressRangeImpl(rangeStart, rangeEnd);
                        }
                    }
                    catch (IOException e) {
                        AddressRangeMapDB.this.errHandler.dbError(e);
                    }
                }
                AddressRangeImpl addressRangeImpl = range;
                return addressRangeImpl;
            }
            finally {
                AddressRangeMapDB.this.lock.release();
            }
        }
    }
}

