/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.program.model.data.DataType;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;
import javax.swing.KeyStroke;

class DataAction
extends ListingContextAction {
    private final String group;
    protected DataType dataType;
    protected FunctionPlugin plugin;

    public DataAction(DataType dataType, FunctionPlugin plugin) {
        this("Define " + dataType.getDisplayName(), "Function", dataType, plugin);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "DataType"));
    }

    public DataAction(String name, String group, DataType dataType, FunctionPlugin plugin) {
        super(name, plugin.getName(), KeyBindingType.SHARED);
        this.group = group;
        this.plugin = plugin;
        this.dataType = dataType;
        this.setPopupMenu(plugin.getDataActionMenuName(null), true);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "DataType"));
        this.initKeyStroke(this.getDefaultKeyStroke());
    }

    protected KeyStroke getDefaultKeyStroke() {
        return null;
    }

    protected void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setKeyBindingData(new KeyBindingData(keyStroke));
    }

    void setPopupMenu(String name, boolean isSignatureAction) {
        this.setPopupMenuData(new MenuData(new String[]{"Set Data Type", this.dataType.getDisplayName()}, this.group));
    }

    public void dispose() {
        this.dataType = null;
        this.plugin = null;
        super.dispose();
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        ProgramLocation location = context.getLocation();
        if (this.plugin.isValidDataLocation(location)) {
            this.setPopupMenu(this.plugin.getDataActionMenuName(location), true);
            return true;
        }
        if (location instanceof VariableLocation) {
            this.setPopupMenu(this.plugin.getDataActionMenuName(location), false);
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.createData(this.dataType, context, true);
    }
}

