/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.cmd.function.ApplyFunctionDataTypesCmd;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProgramArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import java.util.ArrayList;
import javax.swing.tree.TreePath;

public class ApplyFunctionDataTypesAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public ApplyFunctionDataTypesAction(DataTypeManagerPlugin plugin) {
        super("Apply Function Data Types", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Apply Function Data Types"}, null, "VeryLast"));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (this.plugin.getProgram() == null) {
            return false;
        }
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        return node instanceof FileArchiveNode || node instanceof ProjectArchiveNode || node instanceof ProgramArchiveNode;
    }

    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath selectionPath = gTree.getSelectionPath();
        ArchiveNode node = (ArchiveNode)((Object)selectionPath.getLastPathComponent());
        Program program = this.plugin.getProgram();
        DataTypeManager manager = node.getArchive().getDataTypeManager();
        ArrayList<DataTypeManager> managerList = new ArrayList<DataTypeManager>();
        managerList.add(manager);
        ApplyFunctionDataTypesCmd cmd = new ApplyFunctionDataTypesCmd(managerList, null, SourceType.USER_DEFINED, true, true);
        PluginTool tool = this.plugin.getTool();
        tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)program);
    }
}

