/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.calltree.CallNode;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public class ExternalCallNode
extends CallNode {
    private static final Icon EXTERNAL_ICON = ResourceManager.loadImage((String)"images/package.png");
    private final Icon EXTERNAL_FUNCTION_ICON;
    private final Icon baseIcon;
    private final Function function;
    private final Address sourceAddress;
    private final String name;

    ExternalCallNode(Function function, Address sourceAddress, Icon baseIcon) {
        super(new AtomicInteger(0));
        this.function = function;
        this.sourceAddress = sourceAddress;
        this.name = function.getName();
        this.baseIcon = baseIcon;
        MultiIcon outgoingFunctionIcon = new MultiIcon(EXTERNAL_ICON, false, 32, 16);
        TranslateIcon translateIcon = new TranslateIcon(baseIcon, 16, 0);
        outgoingFunctionIcon.addIcon((Icon)translateIcon);
        this.EXTERNAL_FUNCTION_ICON = outgoingFunctionIcon;
    }

    @Override
    CallNode recreate() {
        return new ExternalCallNode(this.function, this.sourceAddress, this.baseIcon);
    }

    @Override
    public Function getRemoteFunction() {
        return this.function;
    }

    @Override
    public ProgramLocation getLocation() {
        return new FunctionSignatureFieldLocation(this.function.getProgram(), this.function.getEntryPoint());
    }

    @Override
    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        return new ArrayList<GTreeNode>();
    }

    public Icon getIcon(boolean expanded) {
        return this.EXTERNAL_FUNCTION_ICON;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        return "External Call - called from " + this.sourceAddress;
    }

    public boolean isLeaf() {
        return true;
    }
}

