/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.util;

import java.util.Date;
import java.util.Random;
import java.util.function.Function;
import org.jungrapht.visualization.layout.model.Point;

public class RandomLocationTransformer<V>
implements Function<V, Point> {
    protected double width;
    protected double height;
    protected Random random;
    protected Origin origin;

    public RandomLocationTransformer(double width, double height) {
        this(Origin.NE, width, height, new Date().getTime());
    }

    public RandomLocationTransformer(Origin origin, double width, double height) {
        this(origin, width, height, new Date().getTime());
    }

    public RandomLocationTransformer(double width, double height, long seed) {
        this(Origin.NE, width, height, seed);
    }

    public RandomLocationTransformer(Origin origin, double width, double height, long seed) {
        this.origin = origin;
        this.width = width;
        this.height = height;
        this.random = new Random(seed);
    }

    private Point applyNE(V vertex) {
        return Point.of(this.random.nextDouble() * this.width, this.random.nextDouble() * this.height);
    }

    private Point applyCenter(V vertex) {
        double radiusX = this.width / 2.0;
        double radiusY = this.height / 2.0;
        return Point.of(this.random.nextDouble() * this.width - radiusX, this.random.nextDouble() * this.height - radiusY);
    }

    @Override
    public Point apply(V vertex) {
        if (this.origin == Origin.NE) {
            return this.applyNE(vertex);
        }
        return this.applyCenter(vertex);
    }

    public static enum Origin {
        NE,
        CENTER;

    }
}

