/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualFunctionTablePointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualFunctionTablePointerWithOffsetMsType;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.PointerTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class VirtualFunctionTablePointerTypeApplier
extends MsTypeApplier {
    public VirtualFunctionTablePointerTypeApplier(PdbApplicator applicator, AbstractMsType msType) throws IllegalArgumentException {
        super(applicator, VirtualFunctionTablePointerTypeApplier.validateType(msType));
    }

    @Override
    BigInteger getSize() {
        return BigInteger.valueOf(this.applicator.getDataOrganization().getPointerSize());
    }

    int getOffset() {
        if (this.msType instanceof AbstractVirtualFunctionTablePointerWithOffsetMsType) {
            return ((AbstractVirtualFunctionTablePointerWithOffsetMsType)this.msType).getOffset();
        }
        return 0;
    }

    String getMemberName() {
        return "VFTablePtr" + this.getOffset();
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.dataType = this.msType instanceof AbstractVirtualFunctionTablePointerMsType ? this.applyPointer(((AbstractVirtualFunctionTablePointerMsType)this.msType).getPointerTypeRecordNumber()) : this.applyPointer(((AbstractVirtualFunctionTablePointerWithOffsetMsType)this.msType).getPointerTypeRecordNumber());
    }

    private DataType applyPointer(RecordNumber pointerTypeRecordNumber) {
        MsTypeApplier rawApplier = this.applicator.getTypeApplier(pointerTypeRecordNumber);
        if (rawApplier instanceof PointerTypeApplier) {
            return rawApplier.getDataType();
        }
        this.applicator.appendLogMsg("cannot process " + rawApplier.getClass().getSimpleName() + "for " + this.getClass().getSimpleName());
        return null;
    }

    private static AbstractMsType validateType(AbstractMsType type) throws IllegalArgumentException {
        if (!(type instanceof AbstractVirtualFunctionTablePointerMsType) && !(type instanceof AbstractVirtualFunctionTablePointerWithOffsetMsType)) {
            throw new IllegalArgumentException("PDB Incorrectly applying " + type.getClass().getSimpleName() + " to " + VirtualFunctionTablePointerTypeApplier.class.getSimpleName());
        }
        return type;
    }
}

