/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.SatelliteVisualizationViewer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.ShearingGraphMousePlugin;
import org.jungrapht.visualization.transform.MutableTransformer;

public class SatelliteShearingGraphMousePlugin<V, E>
extends ShearingGraphMousePlugin<V, E> {
    public SatelliteShearingGraphMousePlugin() {
        super(SatelliteShearingGraphMousePlugin.builder());
    }

    public SatelliteShearingGraphMousePlugin(ShearingGraphMousePlugin.Builder<V, E, ?, ?> builder) {
        super(builder);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean accepted;
        if (this.down == null) {
            return;
        }
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean bl = accepted = e.getModifiersEx() == this.shearingMask;
        if (accepted) {
            if (vv instanceof SatelliteVisualizationViewer) {
                VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
                MutableTransformer modelTransformerMaster = vvMaster.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
                vv.setCursor(this.cursor);
                Point q = this.down;
                Point p = e.getPoint();
                double dx = ((Point2D)p).getX() - ((Point2D)q).getX();
                double dy = ((Point2D)p).getY() - ((Point2D)q).getY();
                Dimension d = vv.getSize();
                double shx = 2.0 * dx / (double)d.height;
                double shy = 2.0 * dy / (double)d.width;
                Point2D center = vv.getRenderContext().getMultiLayerTransformer().transform(vvMaster.getRenderContext().getMultiLayerTransformer().inverseTransform(vvMaster.getCenter()));
                if (((Point2D)p).getX() < center.getX()) {
                    shy = -shy;
                }
                if (((Point2D)p).getY() < center.getY()) {
                    shx = -shx;
                }
                modelTransformerMaster.shear(-shx, -shy, vvMaster.getCenter());
                this.down.x = e.getX();
                this.down.y = e.getY();
            }
            e.consume();
        }
    }
}

