/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.ComponentProvider;
import docking.WindowPosition;
import docking.widgets.label.GLabel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.app.services.GoToService;
import ghidra.bitpatterns.gui.FunctionBitPatternsExplorerPlugin;
import ghidra.bitpatterns.gui.PatternEvalTabelModel;
import ghidra.bitpatterns.info.PatternEvalRowObject;
import ghidra.bitpatterns.info.PatternEvaluationStats;
import ghidra.bitpatterns.info.PatternMatchType;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class PatternEvalTableProvider
extends ComponentProviderAdapter {
    private JPanel mainPanel;

    protected PatternEvalTableProvider(PatternEvaluationStats currentStats, Component parent, FunctionBitPatternsExplorerPlugin plugin, Program program) {
        super(plugin.getTool(), "Pattern Evaluator", plugin.getName());
        this.setTransient();
        this.buildMainPanel(plugin, program, currentStats);
        this.setDefaultWindowPosition(WindowPosition.WINDOW);
        plugin.getTool().addComponentProvider((ComponentProvider)this, true);
        HelpLocation helpLocation = new HelpLocation("FunctionBitPatternsExplorerPlugin", "Evaluating_Patterns");
        this.setHelpLocation(helpLocation);
    }

    private void buildMainPanel(FunctionBitPatternsExplorerPlugin plugin, Program program, PatternEvaluationStats stats) {
        this.mainPanel = new JPanel();
        BoxLayout topLayout = new BoxLayout(this.mainPanel, 1);
        this.mainPanel.setLayout(topLayout);
        JPanel patternPanel = new JPanel(new BorderLayout());
        PatternEvalTabelModel patternEvalModel = new PatternEvalTabelModel(plugin, program, stats.getRowObjects());
        GhidraThreadedTablePanel threadedPanel = new GhidraThreadedTablePanel((ThreadedTableModel)patternEvalModel, 1000);
        GhidraTable table = threadedPanel.getTable();
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        if (goToService != null) {
            table.installNavigation(goToService, goToService.getDefaultNavigatable());
        }
        table.setRowSelectionAllowed(true);
        table.setSelectionMode(2);
        table.setAutoResizeMode(2);
        table.setPreferredScrollableViewportSize(new Dimension(1200, 700));
        GhidraTableFilterPanel tableFilterPanel = new GhidraTableFilterPanel((JTable)table, (RowObjectTableModel)patternEvalModel);
        patternPanel.add((Component)threadedPanel, "Center");
        patternPanel.add((Component)tableFilterPanel, "South");
        JPanel evalPanel = this.buildInfoPanel(stats);
        patternPanel.add((Component)evalPanel, "North");
        this.mainPanel.add(patternPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton highlightButton = new JButton("Highlight Selected");
        highlightButton.addActionListener(e -> {
            AddressSet toHighlight = new AddressSet();
            for (PatternEvalRowObject row : tableFilterPanel.getSelectedItems()) {
                toHighlight.add(row.getMatchedSet());
            }
            plugin.highlightMatches((AddressSetView)toHighlight);
        });
        JButton clearButton = new JButton("Clear Highlights");
        clearButton.addActionListener(e -> plugin.highlightMatches((AddressSetView)new AddressSet()));
        JButton dismissButton = new JButton("Dismiss");
        dismissButton.addActionListener(e -> this.closeComponent());
        buttonPanel.add(highlightButton);
        buttonPanel.add(clearButton);
        buttonPanel.add(dismissButton);
        this.mainPanel.add(buttonPanel);
    }

    private JPanel buildInfoPanel(PatternEvaluationStats stats) {
        JPanel evalPanel = new JPanel(new GridLayout(2, 8));
        evalPanel.add((Component)new GLabel("Match Type"));
        evalPanel.add((Component)new GLabel(PatternMatchType.TRUE_POSITIVE.name()));
        evalPanel.add((Component)new GLabel(PatternMatchType.FP_WRONG_FLOW.name()));
        evalPanel.add((Component)new GLabel(PatternMatchType.FP_MISALIGNED.name()));
        evalPanel.add((Component)new GLabel(PatternMatchType.FP_DATA.name()));
        evalPanel.add((Component)new GLabel(PatternMatchType.POSSIBLE_START_CODE.name()));
        evalPanel.add((Component)new GLabel(PatternMatchType.POSSIBLE_START_UNDEFINED.name()));
        evalPanel.add((Component)new GLabel(PatternMatchType.CONTEXT_CONFLICT.name()));
        evalPanel.add((Component)new GLabel(PatternMatchType.PRE_PATTERN_HIT.name()));
        evalPanel.add((Component)new GLabel("Number"));
        JTextField truePositivesField = new JTextField(8);
        truePositivesField.setEditable(false);
        truePositivesField.setText(Integer.toString(stats.getNumTruePositives()));
        evalPanel.add(truePositivesField);
        JTextField wrongFlowField = new JTextField(8);
        wrongFlowField.setEditable(false);
        wrongFlowField.setText(Integer.toString(stats.getNumWrongFlow()));
        evalPanel.add(wrongFlowField);
        JTextField misalignedField = new JTextField(8);
        misalignedField.setEditable(false);
        misalignedField.setText(Integer.toString(stats.getNumFPMisaligned()));
        evalPanel.add(misalignedField);
        JTextField dataField = new JTextField(8);
        dataField.setEditable(false);
        dataField.setText(Integer.toString(stats.getNumFPData()));
        evalPanel.add(dataField);
        JTextField blockStartField = new JTextField(8);
        blockStartField.setEditable(false);
        blockStartField.setText(Integer.toString(stats.getNumPossibleStartCode()));
        evalPanel.add(blockStartField);
        JTextField undefinedField = new JTextField(8);
        undefinedField.setEditable(false);
        undefinedField.setText(Integer.toString(stats.getNumUndefined()));
        evalPanel.add(undefinedField);
        JTextField regConflictField = new JTextField(8);
        regConflictField.setEditable(false);
        regConflictField.setText(Integer.toString(stats.getNumContextConflicts()));
        evalPanel.add(regConflictField);
        JTextField prePatternFPField = new JTextField(8);
        prePatternFPField.setEditable(false);
        prePatternFPField.setText(Integer.toString(stats.getNumPrePatternHit()));
        evalPanel.add(prePatternFPField);
        return evalPanel;
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }
}

