/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import db.DBBuffer;
import db.DBHandle;
import db.DBRecord;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBBufferInputStream;
import ghidra.util.database.DBBufferOutputStream;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceMemoryBufferEntry
extends DBAnnotatedObject {
    private static final String TABLE_NAME = "MemoryBuffers";
    static final String IN_USE_COLUMN_NAME = "InUse";
    static final String BUFFER_ID_COLUMN_NAME = "BufferId";
    static final String COMPRESSED_COLUMN_NAME = "Compressed";
    @DBAnnotatedColumn(value="InUse")
    static DBObjectColumn IN_USE_COLUMN;
    @DBAnnotatedColumn(value="BufferId")
    static DBObjectColumn BUFFER_ID_COLUMN;
    @DBAnnotatedColumn(value="Compressed")
    static DBObjectColumn COMPRESSED_COLUMN;
    @DBAnnotatedField(column="InUse")
    private byte[] inUse = new byte[32];
    @DBAnnotatedField(column="BufferId")
    private int bufferId = -1;
    @DBAnnotatedField(column="Compressed")
    private boolean compressed;
    protected final DBHandle dbh;
    private DBBuffer buffer;

    static String tableName(AddressSpace space, long threadKey, int frameLevel) {
        return DBTraceUtils.tableName(TABLE_NAME, space, threadKey, frameLevel);
    }

    public DBTraceMemoryBufferEntry(DBHandle dbh, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.dbh = dbh;
    }

    protected boolean isCompressed() {
        return this.compressed;
    }

    protected void fresh(boolean created) throws IOException {
        if (created) {
            this.buffer = this.dbh.createBuffer(0x100000);
            this.bufferId = this.buffer.getId();
        } else {
            this.buffer = this.dbh.getBuffer(this.bufferId);
        }
    }

    public void compress() throws IOException {
        if (this.compressed) {
            return;
        }
        DBBuffer newBuffer = this.dbh.createBuffer(this.buffer.length());
        try (DBBufferInputStream is = new DBBufferInputStream(this.buffer);
             GZIPOutputStream os = new GZIPOutputStream((OutputStream)new DBBufferOutputStream(newBuffer), 8192);){
            is.transferTo(os);
        }
        this.buffer.delete();
        this.buffer = newBuffer;
        this.bufferId = this.buffer.getId();
        this.compressed = true;
        this.update(BUFFER_ID_COLUMN, COMPRESSED_COLUMN);
    }

    public void decompress() throws IOException {
        if (!this.compressed) {
            return;
        }
        DBBuffer newBuffer = this.dbh.createBuffer(0x100000);
        try (GZIPInputStream is = new GZIPInputStream((InputStream)new DBBufferInputStream(this.buffer));
             DBBufferOutputStream os = new DBBufferOutputStream(newBuffer);){
            is.transferTo((OutputStream)os);
        }
        this.buffer.delete();
        this.buffer = newBuffer;
        this.bufferId = this.buffer.getId();
        this.compressed = false;
        this.update(BUFFER_ID_COLUMN, COMPRESSED_COLUMN);
    }

    protected boolean isSane(int offset, int len, int blockNum) {
        if (offset + len > 4096) {
            return false;
        }
        if (blockNum >= 256) {
            return false;
        }
        return this.isInUse(blockNum);
    }

    public int setBytes(ByteBuffer buf, int dstOffset, int len, int blockNum) throws IOException {
        assert (this.isSane(dstOffset, len, blockNum));
        if (this.compressed) {
            this.decompress();
        }
        this.buffer.put((blockNum << 12) + dstOffset, buf.array(), buf.arrayOffset() + buf.position(), len);
        buf.position(buf.position() + len);
        return len;
    }

    public int getBytes(ByteBuffer buf, int srcOffset, int len, int blockNum) throws IOException {
        assert (this.isSane(srcOffset, len, blockNum));
        if (this.compressed) {
            return this.doGetCompressedBytes(buf, srcOffset, len, blockNum);
        }
        this.buffer.get((blockNum << 12) + srcOffset, buf.array(), buf.arrayOffset() + buf.position(), len);
        buf.position(buf.position() + len);
        return len;
    }

    protected int doGetCompressedBytes(ByteBuffer buf, int srcOffset, int len, int blockNum) throws IOException {
        try (GZIPInputStream is = new GZIPInputStream((InputStream)new DBBufferInputStream(this.buffer));){
            ((InputStream)is).skip((blockNum << 12) + srcOffset);
            int amt = ((InputStream)is).read(buf.array(), buf.arrayOffset() + buf.position(), len);
            buf.position(buf.position() + amt);
            if (amt != len) {
                throw new IOException("compressed memory buffer is corrupt");
            }
            int n = len;
            return n;
        }
    }

    protected void doGetBlock(int blockNum, byte[] data) throws IOException {
        assert (this.isInUse(blockNum));
        if (this.compressed) {
            this.doGetCompressedBlock(blockNum, data);
        }
        this.buffer.get(blockNum << 12, data);
    }

    protected void doGetCompressedBlock(int blockNum, byte[] data) throws IOException {
        try (GZIPInputStream is = new GZIPInputStream((InputStream)new DBBufferInputStream(this.buffer));){
            ((InputStream)is).skip(blockNum << 12);
            int amt = ((InputStream)is).read(data);
            if (amt != data.length) {
                throw new IOException("compressed memory buffer is corrupt");
            }
        }
    }

    public void copyFrom(int dstBlockNum, DBTraceMemoryBufferEntry srcBuf, int srcBlockNum) throws IOException {
        assert (this.isInUse(dstBlockNum));
        if (this.compressed) {
            this.decompress();
        }
        byte[] data = new byte[4096];
        srcBuf.doGetBlock(srcBlockNum, data);
        this.buffer.put(dstBlockNum << 12, data);
    }

    public int cmpBytes(ByteBuffer buf, int blkOffset, int len, int blockNum) throws IOException {
        assert (this.isSane(blkOffset, len, blockNum));
        if (this.compressed) {
            return this.doCmpCompressedBytes(buf, blkOffset, len, blockNum);
        }
        int leftPos = (blockNum << 12) + blkOffset;
        int rightPos = buf.position();
        for (int i = 0; i < len; ++i) {
            byte right;
            byte left = this.buffer.getByte(leftPos + i);
            int cmp = Byte.compareUnsigned(left, right = buf.get(rightPos + i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    protected int doCmpCompressedBytes(ByteBuffer buf, int blkOffset, int len, int blockNum) throws IOException {
        try (GZIPInputStream is = new GZIPInputStream((InputStream)new DBBufferInputStream(this.buffer));){
            ((InputStream)is).skip((blockNum << 12) + blkOffset);
            int rightPos = buf.position();
            for (int i = 0; i < len; ++i) {
                int left = ((InputStream)is).read();
                if (left == -1) {
                    throw new IOException("compressed memory buffer is corrupt");
                }
                byte right = buf.get(rightPos + i);
                int cmp = Byte.compareUnsigned((byte)left, right);
                if (cmp == 0) continue;
                int n = cmp;
                return n;
            }
            int n = 0;
            return n;
        }
    }

    public boolean isInUse(int blockNum) {
        int i = blockNum >> 3;
        int j = blockNum & 7;
        return (this.inUse[i] & 1 << j) != 0;
    }

    public int acquireBlock() {
        for (int i = 0; i < this.inUse.length; ++i) {
            byte b = this.inUse[i];
            if (b == -1) continue;
            for (int j = 0; j < 8; ++j) {
                if ((b & 1 << j) != 0) continue;
                int n = i;
                this.inUse[n] = (byte)(this.inUse[n] | 1 << j);
                this.update(IN_USE_COLUMN);
                return i * 8 + j;
            }
        }
        return -1;
    }

    public void acquireBlock(int blockNum) {
        int i = blockNum >> 3;
        int j = blockNum & 7;
        assert ((this.inUse[i] & 1 << j) == 0);
        int n = i;
        this.inUse[n] = (byte)(this.inUse[n] | 1 << j);
        this.update(IN_USE_COLUMN);
    }

    public void releaseBlock(int blockNum) {
        int i = blockNum >> 3;
        int j = blockNum & 7;
        assert ((this.inUse[i] & 1 << j) != 0);
        int n = i;
        this.inUse[n] = (byte)(this.inUse[n] & ~(1 << j));
        this.update(IN_USE_COLUMN);
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.inUse.length; ++i) {
            if (this.inUse[i] == 0) continue;
            return false;
        }
        return true;
    }
}

