/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.utils;

import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpec;
import ghidra.framework.options.PropertyBoolean;
import ghidra.framework.options.PropertySelector;
import ghidra.framework.options.PropertyText;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.awt.Component;
import java.beans.PropertyEditor;
import java.util.Map;
import java.util.function.Function;

public enum MiscellaneousUtils {


    public static Component getEditorComponent(PropertyEditor editor) {
        if (editor.supportsCustomEditor()) {
            return editor.getCustomEditor();
        }
        if (editor.getValue() instanceof Boolean) {
            return new PropertyBoolean(editor);
        }
        if (editor.getTags() != null) {
            return new PropertySelector(editor);
        }
        if (editor.getAsText() != null) {
            return new PropertyText(editor);
        }
        Class<?> clazz = editor.getClass();
        String clazzName = clazz.getSimpleName();
        if (clazzName.startsWith("String")) {
            return new PropertyText(editor);
        }
        throw new IllegalStateException("Ghidra does not know how to use PropertyEditor: " + editor.getClass().getName());
    }

    public static <T> void collectUniqueInstances(Class<T> cls, Map<String, T> map, Function<T, String> keyFunc) {
        for (Object t : ClassSearcher.getInstances(cls)) {
            String key = keyFunc.apply(t);
            T exists = map.get(key);
            if (exists != null) {
                if (exists.getClass().equals(t.getClass())) continue;
                Msg.error(LocationTrackingSpec.class, (Object)(cls.getSimpleName() + " conflict over key: " + key));
            }
            map.put(key, t);
        }
    }
}

