/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import com.google.common.collect.Range;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionActionContext;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionsPlugin;
import ghidra.app.plugin.core.debug.gui.memory.RegionRow;
import ghidra.app.plugin.core.debug.utils.DebouncedRowWrappedEnumeratedColumnTableModel;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceObject;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.database.ObjectKey;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerRegionsProvider
extends ComponentProviderAdapter {
    private final DebuggerRegionsPlugin plugin;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoServiceWiring;
    private Trace currentTrace;
    private final RegionsListener regionsListener = new RegionsListener();
    protected final RegionTableModel regionTableModel = new RegionTableModel();
    protected GhidraTable regionTable;
    private GhidraTableFilterPanel<RegionRow> regionFilterPanel;
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    private DebuggerRegionActionContext myActionContext;
    SelectAddressesAction actionSelectAddresses;
    DockingAction actionSelectRows;
    ToggleDockingAction actionForceFullView;

    protected static RegionRow getSelectedRegionRow(ActionContext context) {
        if (!(context instanceof DebuggerRegionActionContext)) {
            return null;
        }
        DebuggerRegionActionContext ctx = (DebuggerRegionActionContext)context;
        Set<RegionRow> regions = ctx.getSelectedRegions();
        if (regions.size() != 1) {
            return null;
        }
        return regions.iterator().next();
    }

    protected static Set<TraceMemoryRegion> getSelectedRegions(ActionContext context) {
        if (!(context instanceof DebuggerRegionActionContext)) {
            return null;
        }
        DebuggerRegionActionContext ctx = (DebuggerRegionActionContext)context;
        return ctx.getSelectedRegions().stream().map(r -> r.getRegion()).collect(Collectors.toSet());
    }

    public DebuggerRegionsProvider(DebuggerRegionsPlugin plugin) {
        super(plugin.getTool(), "Regions", plugin.getName(), DebuggerRegionActionContext.class);
        this.plugin = plugin;
        this.setIcon(DebuggerResources.ICON_PROVIDER_REGIONS);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_REGIONS);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setVisible(true);
        this.createActions();
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    private void loadRegions() {
        this.regionTableModel.clear();
        if (this.currentTrace == null) {
            return;
        }
        TraceMemoryManager memoryManager = this.currentTrace.getMemoryManager();
        this.regionTableModel.addAllItems(memoryManager.getAllRegions());
    }

    protected void buildMainPanel() {
        this.regionTable = new GhidraTable((TableModel)((Object)this.regionTableModel));
        this.regionTable.setSelectionMode(2);
        this.mainPanel.add(new JScrollPane((Component)this.regionTable));
        this.regionFilterPanel = new GhidraTableFilterPanel((JTable)this.regionTable, (RowObjectTableModel)this.regionTableModel);
        this.mainPanel.add((Component)this.regionFilterPanel, "South");
        this.regionTable.getSelectionModel().addListSelectionListener(evt -> {
            this.myActionContext = new DebuggerRegionActionContext(this, this.regionFilterPanel.getSelectedItems(), (GTable)this.regionTable);
            this.contextChanged();
        });
        this.regionTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DebuggerRegionsProvider.this.navigateToSelectedRegion();
                }
            }
        });
        this.regionTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerRegionsProvider.this.navigateToSelectedRegion();
                }
            }
        });
        TableColumnModel columnModel = this.regionTable.getColumnModel();
        TableColumn startCol = columnModel.getColumn(RegionTableColumns.START.ordinal());
        startCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn endCol = columnModel.getColumn(RegionTableColumns.END.ordinal());
        endCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn lenCol = columnModel.getColumn(RegionTableColumns.LENGTH.ordinal());
        lenCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_ULONG_HEX);
        int small = 100;
        TableColumn rCol = columnModel.getColumn(RegionTableColumns.READ.ordinal());
        rCol.setPreferredWidth(100);
        TableColumn wCol = columnModel.getColumn(RegionTableColumns.WRITE.ordinal());
        wCol.setPreferredWidth(100);
        TableColumn eCol = columnModel.getColumn(RegionTableColumns.EXECUTE.ordinal());
        eCol.setPreferredWidth(100);
        TableColumn vCol = columnModel.getColumn(RegionTableColumns.VOLATILE.ordinal());
        vCol.setPreferredWidth(100);
    }

    protected void navigateToSelectedRegion() {
        int selectedColumn;
        int selectedRow;
        Object value;
        if (this.listingService != null && (value = this.regionTable.getValueAt(selectedRow = this.regionTable.getSelectedRow(), selectedColumn = this.regionTable.getSelectedColumn())) instanceof Address) {
            this.listingService.goTo((Address)value, true);
        }
    }

    protected void createActions() {
        this.actionSelectAddresses = new SelectAddressesAction();
        this.actionSelectRows = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.SelectRowsAction.builder(this.plugin).description("Select regions by trace selection")).enabledWhen(ctx -> this.currentTrace != null)).onAction(this::activatedSelectCurrent)).buildAndInstallLocal((ComponentProvider)this);
        this.actionForceFullView = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.ForceFullViewAction.builder(this.plugin).enabledWhen(ctx -> this.currentTrace != null)).onAction(this::activatedForceFullView)).buildAndInstallLocal((ComponentProvider)this);
    }

    private void activatedSelectCurrent(ActionContext ignored) {
        TraceMemoryRegion reg;
        if (this.listingService == null || this.traceManager == null || this.currentTrace == null) {
            return;
        }
        ProgramSelection progSel = this.listingService.getCurrentSelection();
        TraceMemoryManager memoryManager = this.currentTrace.getMemoryManager();
        if (progSel != null && !progSel.isEmpty()) {
            HashSet<TraceMemoryRegion> regSel = new HashSet<TraceMemoryRegion>();
            for (AddressRange range : progSel) {
                regSel.addAll(memoryManager.getRegionsIntersecting(Range.singleton((Comparable)Long.valueOf(this.traceManager.getCurrentSnap())), range));
            }
            this.setSelectedRegions(regSel);
            return;
        }
        ProgramLocation progLoc = this.listingService.getCurrentLocation();
        if (progLoc != null && (reg = memoryManager.getRegionContaining(this.traceManager.getCurrentSnap(), progLoc.getAddress())) != null) {
            this.setSelectedRegions(Set.of(reg));
            return;
        }
    }

    private void activatedForceFullView(ActionContext ignored) {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.getProgramView().getMemory().setForceFullView(this.actionForceFullView.isSelected());
    }

    public void setSelectedRegions(Set<TraceMemoryRegion> sel) {
        DebuggerResources.setSelectedRows(sel, arg_0 -> ((RegionTableModel)this.regionTableModel).getRow(arg_0), (GTable)this.regionTable, this.regionTableModel, this.regionFilterPanel);
    }

    public Collection<RegionRow> getSelectedRows() {
        return this.regionFilterPanel.getSelectedItems();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void setTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
        this.loadRegions();
        this.contextChanged();
    }

    public void contextChanged() {
        super.contextChanged();
        if (this.currentTrace != null) {
            this.actionForceFullView.setSelected(this.currentTrace.getProgramView().getMemory().isForceFullView());
        }
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.regionsListener);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.regionsListener);
    }

    protected class SelectAddressesAction
    extends DebuggerResources.AbstractSelectAddressesAction {
        public static final String GROUP = "Dbg1. General";

        public SelectAddressesAction() {
            super(DebuggerRegionsProvider.this.plugin);
            this.setDescription("Select addresses contained in regions");
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setPopupMenuData(new MenuData(new String[]{"Select Addresses"}, GROUP));
            DebuggerRegionsProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionContext context) {
            if (DebuggerRegionsProvider.this.listingService == null) {
                return;
            }
            Set<TraceMemoryRegion> regions = DebuggerRegionsProvider.getSelectedRegions(DebuggerRegionsProvider.this.myActionContext);
            if (regions == null) {
                return;
            }
            AddressSet sel = new AddressSet();
            for (TraceMemoryRegion s : regions) {
                sel.add(s.getRange());
            }
            ProgramSelection ps = new ProgramSelection((AddressSetView)sel);
            DebuggerRegionsProvider.this.listingService.setCurrentSelection(ps);
        }

        public boolean isEnabledForContext(ActionContext context) {
            Set<TraceMemoryRegion> sel = DebuggerRegionsProvider.getSelectedRegions(DebuggerRegionsProvider.this.myActionContext);
            return sel != null && !sel.isEmpty();
        }
    }

    private class RegionsListener
    extends TraceDomainObjectListener {
        public RegionsListener() {
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.ADDED, this::regionAdded);
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.CHANGED, this::regionChanged);
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.LIFESPAN_CHANGED, this::regionChanged);
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.DELETED, this::regionDeleted);
        }

        private void objectRestored() {
            DebuggerRegionsProvider.this.loadRegions();
        }

        private void regionAdded(TraceMemoryRegion region) {
            DebuggerRegionsProvider.this.regionTableModel.addItem(region);
        }

        private void regionChanged(TraceMemoryRegion region) {
            DebuggerRegionsProvider.this.regionTableModel.updateItem(region);
        }

        private void regionDeleted(TraceMemoryRegion region) {
            DebuggerRegionsProvider.this.regionTableModel.deleteItem(region);
        }
    }

    protected static class RegionTableModel
    extends DebouncedRowWrappedEnumeratedColumnTableModel<RegionTableColumns, ObjectKey, RegionRow, TraceMemoryRegion> {
        public RegionTableModel() {
            super("Regions", RegionTableColumns.class, TraceObject::getObjectKey, RegionRow::new);
        }
    }

    protected static enum RegionTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<RegionTableColumns, RegionRow>
    {
        NAME("Name", String.class, RegionRow::getName, RegionRow::setName),
        LIFESPAN("Lifespan", Range.class, RegionRow::getLifespan),
        START("Start", Address.class, RegionRow::getMinAddress),
        END("End", Address.class, RegionRow::getMaxAddress),
        LENGTH("Length", Long.class, RegionRow::getLength),
        READ("Read", Boolean.class, RegionRow::isRead, RegionRow::setRead),
        WRITE("Write", Boolean.class, RegionRow::isWrite, RegionRow::setWrite),
        EXECUTE("Execute", Boolean.class, RegionRow::isExecute, RegionRow::setExecute),
        VOLATILE("Volatile", Boolean.class, RegionRow::isVolatile, RegionRow::setVolatile);

        private final String header;
        private final Function<RegionRow, ?> getter;
        private final BiConsumer<RegionRow, Object> setter;
        private final Class<?> cls;

        private <T> RegionTableColumns(String header, Class<T> cls, Function<RegionRow, T> getter, BiConsumer<RegionRow, T> setter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
        }

        private <T> RegionTableColumns(String header, Class<T> cls, Function<RegionRow, T> getter) {
            this(header, cls, getter, null);
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public boolean isEditable(RegionRow row) {
            return this.setter != null;
        }

        public void setValueOf(RegionRow row, Object value) {
            this.setter.accept(row, value);
        }

        public Object getValueOf(RegionRow row) {
            return this.getter.apply(row);
        }
    }
}

