/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.agent;

import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerModelTypeException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface SpiDebuggerObjectModel
extends DebuggerObjectModel {
    @Override
    default public boolean isAlive() {
        return true;
    }

    @Override
    default public CompletableFuture<Void> ping(String content) {
        return AsyncUtils.NIL;
    }

    public static CompletableFuture<Object> fetchFreshChild(TargetObject obj, String key) {
        if (PathUtils.isIndex(key)) {
            return obj.fetchElements(true).thenApply(elements -> elements.get(PathUtils.parseIndex(key)));
        }
        return obj.fetchAttributes(true).thenApply(attributes -> attributes.get(key));
    }

    public static CompletableFuture<Object> fetchSuccessorValue(TargetObject obj, List<String> path, boolean refresh, boolean followLinks) {
        if (path.isEmpty()) {
            return CompletableFuture.completedFuture(obj);
        }
        String key = path.get(0);
        CompletableFuture<Object> futureChild = refresh ? SpiDebuggerObjectModel.fetchFreshChild(obj, key) : obj.fetchChild(key);
        return futureChild.thenCompose(c -> {
            if (c == null) {
                return AsyncUtils.nil();
            }
            if (!(c instanceof TargetObject)) {
                if (path.size() == 1) {
                    return CompletableFuture.completedFuture(c);
                }
                List<String> p = PathUtils.extend(obj.getPath(), key);
                throw DebuggerModelTypeException.typeRequired(c, p, TargetObject.class);
            }
            TargetObject child = (TargetObject)c;
            if (PathUtils.isLink(obj.getPath(), key, child.getPath()) && !followLinks) {
                if (path.size() == 1) {
                    return CompletableFuture.completedFuture(c);
                }
                List<String> p = PathUtils.extend(obj.getPath(), key);
                throw DebuggerModelTypeException.linkForbidden(child, p);
            }
            List<String> remains = path.subList(1, path.size());
            return SpiDebuggerObjectModel.fetchSuccessorValue(child, remains, refresh, followLinks);
        });
    }

    @Override
    default public CompletableFuture<?> fetchModelValue(List<String> path, boolean refresh) {
        return this.fetchModelRoot().thenCompose(root -> SpiDebuggerObjectModel.fetchSuccessorValue(root, path, refresh, true));
    }

    @Override
    default public CompletableFuture<?> fetchModelValue(List<String> path) {
        return this.fetchModelValue(path, false);
    }

    @Override
    default public CompletableFuture<? extends Map<String, ? extends TargetObject>> fetchObjectElements(List<String> path, boolean refresh) {
        return this.fetchModelObject(path).thenCompose(obj -> {
            if (obj == null) {
                return AsyncUtils.nil();
            }
            return obj.fetchElements(refresh);
        });
    }

    @Override
    default public CompletableFuture<? extends Map<String, ?>> fetchObjectAttributes(List<String> path, boolean refresh) {
        return this.fetchModelObject(path).thenCompose(obj -> {
            if (obj == null) {
                return AsyncUtils.nil();
            }
            return obj.fetchAttributes(refresh);
        });
    }

    @Override
    default public void invalidateAllLocalCaches() {
    }
}

