/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryField;
import db.Field;
import db.FieldKeyInteriorNode;
import db.FieldKeyNode;
import db.FieldKeyRecordNode;
import db.FixedKeyNode;
import db.FixedKeyRecordNode;
import db.NodeMgr;
import db.buffers.DataBuffer;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class FixedKeyInteriorNode
extends FixedKeyNode
implements FieldKeyInteriorNode {
    private static final int BASE = 5;
    private static final int ID_SIZE = 4;
    private final int maxKeyCount;
    private final int entrySize;

    FixedKeyInteriorNode(NodeMgr nodeMgr, DataBuffer buf) throws IOException {
        super(nodeMgr, buf);
        this.entrySize = this.keySize + 4;
        this.maxKeyCount = (this.buffer.length() - 5) / this.entrySize;
    }

    FixedKeyInteriorNode(NodeMgr nodeMgr, Field keyType, byte[] key1, int id1, byte[] key2, int id2) throws IOException {
        super(nodeMgr, (byte)5);
        if (this.keySize != key1.length || this.keySize != key2.length) {
            throw new IllegalArgumentException("mismatched fixed-length key sizes");
        }
        this.entrySize = this.keySize + 4;
        this.maxKeyCount = (this.buffer.length() - 5) / this.entrySize;
        this.setKeyCount(2);
        this.putEntry(0, key1, id1);
        this.putEntry(1, key2, id2);
    }

    private FixedKeyInteriorNode(NodeMgr nodeMgr, Field keyType) throws IOException {
        super(nodeMgr, (byte)5);
        this.entrySize = this.keySize + 4;
        this.maxKeyCount = (this.buffer.length() - 5) / this.entrySize;
    }

    void logConsistencyError(String tableName, String msg, Throwable t) {
        Msg.debug((Object)this, (Object)("Consistency Error (" + tableName + "): " + msg));
        Msg.debug((Object)this, (Object)("  parent.key[0]=" + BinaryField.getValueAsString(this.getKey(0)) + " bufferID=" + this.getBufferId()));
        if (t != null) {
            Msg.error((Object)this, (Object)("Consistency Error (" + tableName + ")"), (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConsistent(String tableName, TaskMonitor monitor) throws IOException, CancelledException {
        boolean consistent = true;
        Field lastMinKey = null;
        Field lastMaxKey = null;
        for (int i = 0; i < this.keyCount; ++i) {
            Field key = this.getKeyField(i);
            if (lastMinKey != null && key.compareTo(lastMinKey) <= 0) {
                consistent = false;
                this.logConsistencyError(tableName, "child[" + i + "].minKey <= child[" + (i - 1) + "].minKey", null);
                Msg.debug((Object)this, (Object)("  child[" + i + "].minKey = " + key.getValueAsString() + " bufferID=" + this.getBufferId(i)));
                Msg.debug((Object)this, (Object)("  child[" + (i - 1) + "].minKey = " + lastMinKey.getValueAsString() + " bufferID=" + this.getBufferId(i - 1)));
            } else if (lastMaxKey != null && key.compareTo(lastMaxKey) <= 0) {
                consistent = false;
                this.logConsistencyError(tableName, "child[" + i + "].minKey <= child[" + (i - 1) + "].maxKey", null);
                Msg.debug((Object)this, (Object)("  child[" + i + "].minKey = " + key.getValueAsString() + " bufferID=" + this.getBufferId(i)));
                Msg.debug((Object)this, (Object)("  child[" + (i - 1) + "].maxKey = " + lastMaxKey.getValueAsString() + " bufferID=" + this.getBufferId(i - 1)));
            }
            lastMinKey = key;
            FixedKeyNode node = null;
            try {
                try {
                    node = this.nodeMgr.getFixedKeyNode(this.getBufferId(i));
                    node.parent = this;
                }
                catch (IOException e) {
                    this.logConsistencyError(tableName, "failed to fetch child node: " + e.getMessage(), e);
                }
                catch (RuntimeException e) {
                    this.logConsistencyError(tableName, "failed to fetch child node: " + e.getMessage(), e);
                }
                if (node == null) {
                    consistent = false;
                    lastMaxKey = key;
                    continue;
                }
                lastMaxKey = node.getKeyField(node.getKeyCount() - 1);
                Field childKey0 = node.getKeyField(0);
                if (!key.equals(childKey0)) {
                    consistent = false;
                    this.logConsistencyError(tableName, "parent key entry mismatch with child[" + i + "].minKey", null);
                    Msg.debug((Object)this, (Object)("  child[" + i + "].minKey = " + childKey0.getValueAsString() + " bufferID=" + this.getBufferId(i - 1)));
                    Msg.debug((Object)this, (Object)("  parent key entry = " + key.getValueAsString()));
                }
                consistent &= node.isConsistent(tableName, monitor);
                monitor.checkCanceled();
                continue;
            }
            finally {
                if (node != null) {
                    this.nodeMgr.releaseReadOnlyNode(node.getBufferId());
                }
            }
        }
        monitor.checkCanceled();
        return consistent;
    }

    int getIdIndex(Field key) {
        int min = 1;
        int max = this.keyCount - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            int c = this.compareKeyField(key, i);
            if (c == 0) {
                return i;
            }
            if (c > 0) {
                min = i + 1;
                continue;
            }
            max = i - 1;
        }
        return max;
    }

    @Override
    public int getKeyIndex(Field key) {
        int min = 0;
        int max = this.keyCount - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            int rc = this.compareKeyField(key, i);
            if (rc == 0) {
                return i;
            }
            if (rc > 0) {
                min = i + 1;
                continue;
            }
            max = i - 1;
        }
        return -(min + 1);
    }

    @Override
    byte[] getKey(int index) {
        byte[] key = new byte[this.keySize];
        this.buffer.get(5 + index * this.entrySize, key);
        return key;
    }

    @Override
    public int compareKeyField(Field k, int keyIndex) {
        return k.compareTo(this.buffer, 5 + keyIndex * this.entrySize);
    }

    private void putKey(int index, byte[] key) {
        this.buffer.put(5 + index * this.entrySize, key);
    }

    private int getBufferId(int index) {
        return this.buffer.getInt(5 + index * this.entrySize + this.keySize);
    }

    private void putEntry(int index, byte[] key, int bufferId) {
        int offset = 5 + index * this.entrySize;
        this.buffer.put(offset, key);
        this.buffer.putInt(offset + this.keySize, bufferId);
    }

    private void insertEntry(int index, byte[] key, int bufferId) {
        int start = 5 + index * this.entrySize;
        int end = 5 + this.keyCount * this.entrySize;
        this.buffer.move(start, start + this.entrySize, end - start);
        this.buffer.put(start, key);
        this.buffer.putInt(start + this.keySize, bufferId);
        this.setKeyCount(this.keyCount + 1);
    }

    private void deleteEntry(int index) {
        if (this.keyCount < 3 || index >= this.keyCount) {
            throw new AssertException();
        }
        if (++index < this.keyCount) {
            int start = 5 + index * this.entrySize;
            int end = 5 + this.keyCount * this.entrySize;
            this.buffer.move(start, start - this.entrySize, end - start);
        }
        this.setKeyCount(this.keyCount - 1);
    }

    void keyChanged(Field oldKey, byte[] newKeyData) {
        int index = this.getKeyIndex(oldKey);
        if (index < 0) {
            throw new AssertException();
        }
        this.putKey(index, newKeyData);
        if (index == 0 && this.parent != null) {
            this.parent.keyChanged(oldKey, newKeyData);
        }
    }

    @Override
    public void keyChanged(Field oldKey, Field newKey, FieldKeyNode childNode) throws IOException {
        this.keyChanged(oldKey, newKey.getBinaryData());
    }

    FixedKeyNode insert(int id, Field key) throws IOException {
        if (this.keyCount == this.maxKeyCount) {
            return this.split(key, id);
        }
        int index = -(this.getKeyIndex(key) + 1);
        if (index < 0 || id == 0) {
            throw new AssertException();
        }
        byte[] keyData = key.getBinaryData();
        this.insertEntry(index, keyData, id);
        if (index == 0 && this.parent != null) {
            this.parent.keyChanged(this.getKeyField(1), keyData);
        }
        return this.getRoot();
    }

    private FixedKeyNode split(Field newKey, int newId) throws IOException {
        FixedKeyInteriorNode newNode = new FixedKeyInteriorNode(this.nodeMgr, this.keyType);
        FixedKeyInteriorNode.moveKeysRight(this, newNode, this.keyCount / 2);
        Field rightKey = newNode.getKeyField(0);
        if (newKey.compareTo(rightKey) < 0) {
            this.insert(newId, newKey);
        } else {
            newNode.insert(newId, newKey);
        }
        if (this.parent != null) {
            return this.parent.insert(newNode.getBufferId(), rightKey);
        }
        return new FixedKeyInteriorNode(this.nodeMgr, this.keyType, this.getKey(0), this.buffer.getId(), rightKey.getBinaryData(), newNode.getBufferId());
    }

    @Override
    public FixedKeyRecordNode getLeafNode(Field key) throws IOException {
        FixedKeyNode node = this.nodeMgr.getFixedKeyNode(this.getBufferId(this.getIdIndex(key)));
        node.parent = this;
        return (FixedKeyRecordNode)node.getLeafNode(key);
    }

    @Override
    public FieldKeyRecordNode getLeftmostLeafNode() throws IOException {
        FixedKeyNode node = this.nodeMgr.getFixedKeyNode(this.getBufferId(0));
        return node.getLeftmostLeafNode();
    }

    @Override
    public FieldKeyRecordNode getRightmostLeafNode() throws IOException {
        FixedKeyNode node = this.nodeMgr.getFixedKeyNode(this.getBufferId(this.keyCount - 1));
        return node.getRightmostLeafNode();
    }

    FixedKeyNode deleteChild(Field key) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            throw new AssertException();
        }
        if (this.keyCount == 2) {
            if (this.parent != null) {
                throw new AssertException();
            }
            FixedKeyNode rootNode = this.nodeMgr.getFixedKeyNode(this.getBufferId(1 - index));
            rootNode.parent = null;
            this.nodeMgr.deleteNode(this);
            return rootNode;
        }
        this.deleteEntry(index);
        if (index == 0 && this.parent != null) {
            this.parent.keyChanged(key, this.getKey(0));
        }
        return this.parent != null ? this.parent.balanceChild(this) : this;
    }

    private FixedKeyNode balanceChild(FixedKeyInteriorNode node) throws IOException {
        if (node.keyCount > this.maxKeyCount / 2) {
            return this.getRoot();
        }
        int index = this.getIdIndex(node.getKeyField(0));
        if (index == this.keyCount - 1) {
            return this.balanceChild((FixedKeyInteriorNode)this.nodeMgr.getFixedKeyNode(this.getBufferId(index - 1)), node);
        }
        return this.balanceChild(node, (FixedKeyInteriorNode)this.nodeMgr.getFixedKeyNode(this.getBufferId(index + 1)));
    }

    private FixedKeyNode balanceChild(FixedKeyInteriorNode leftNode, FixedKeyInteriorNode rightNode) throws IOException {
        Field rightKey = rightNode.getKeyField(0);
        int leftKeyCount = leftNode.keyCount;
        int rightKeyCount = rightNode.keyCount;
        int newLeftKeyCount = leftKeyCount + rightKeyCount;
        if (newLeftKeyCount <= this.maxKeyCount) {
            FixedKeyInteriorNode.moveKeysLeft(leftNode, rightNode, rightKeyCount);
            this.nodeMgr.deleteNode(rightNode);
            return this.deleteChild(rightKey);
        }
        if ((newLeftKeyCount /= 2) < leftKeyCount) {
            FixedKeyInteriorNode.moveKeysRight(leftNode, rightNode, leftKeyCount - newLeftKeyCount);
        } else if (newLeftKeyCount > leftKeyCount) {
            FixedKeyInteriorNode.moveKeysLeft(leftNode, rightNode, newLeftKeyCount - leftKeyCount);
        }
        this.keyChanged(rightKey, rightNode.getKey(0));
        return this.getRoot();
    }

    private static void moveKeysRight(FixedKeyInteriorNode leftNode, FixedKeyInteriorNode rightNode, int count) {
        if (leftNode.keySize != rightNode.keySize) {
            throw new IllegalArgumentException("mismatched fixed key sizes");
        }
        int leftKeyCount = leftNode.keyCount;
        int rightKeyCount = rightNode.keyCount;
        int leftOffset = 5 + (leftKeyCount - count) * leftNode.entrySize;
        int len = count * leftNode.entrySize;
        rightNode.buffer.move(5, 5 + len, rightKeyCount * leftNode.entrySize);
        rightNode.buffer.copy(5, leftNode.buffer, leftOffset, len);
        leftNode.setKeyCount(leftKeyCount - count);
        rightNode.setKeyCount(rightKeyCount + count);
    }

    private static void moveKeysLeft(FixedKeyInteriorNode leftNode, FixedKeyInteriorNode rightNode, int count) {
        if (leftNode.keySize != rightNode.keySize) {
            throw new IllegalArgumentException("mismatched fixed key sizes");
        }
        int leftKeyCount = leftNode.keyCount;
        int rightKeyCount = rightNode.keyCount;
        int leftOffset = 5 + leftKeyCount * leftNode.entrySize;
        int len = count * leftNode.entrySize;
        leftNode.buffer.copy(leftOffset, rightNode.buffer, 5, len);
        leftNode.setKeyCount(leftKeyCount + count);
        if (count < rightKeyCount) {
            rightNode.buffer.move(5 + len, 5, (rightKeyCount -= count) * leftNode.entrySize);
            rightNode.setKeyCount(rightKeyCount);
        }
    }

    @Override
    public void delete() throws IOException {
        for (int index = 0; index < this.keyCount; ++index) {
            this.nodeMgr.getFixedKeyNode(this.getBufferId(index)).delete();
        }
        this.nodeMgr.deleteNode(this);
    }

    @Override
    public int[] getBufferReferences() {
        int[] ids = new int[this.keyCount];
        for (int i = 0; i < this.keyCount; ++i) {
            ids[i] = this.getBufferId(i);
        }
        return ids;
    }

    boolean isLeftmostKey(Field key) {
        if (this.getIdIndex(key) == 0) {
            if (this.parent != null) {
                return this.parent.isLeftmostKey(key);
            }
            return true;
        }
        return false;
    }

    boolean isRightmostKey(Field key) {
        if (this.getIdIndex(key) == this.keyCount - 1) {
            if (this.parent != null) {
                return this.parent.isRightmostKey(this.getKeyField(0));
            }
            return true;
        }
        return false;
    }
}

