/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugExceptionRecord64;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgExceptionFilter;
import agent.dbgeng.manager.cmd.DbgSetFilterCommandCommand;
import agent.dbgeng.manager.cmd.DbgSetFilterSecondChanceCmdCommand;
import agent.dbgeng.manager.evt.AbstractDbgEvent;
import agent.dbgeng.manager.evt.DbgExceptionEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.iface1.DbgModelTargetFocusScope;
import agent.dbgeng.model.iface2.DbgModelTargetEventOption;
import agent.dbgeng.model.iface2.DbgModelTargetException;
import agent.dbgeng.model.iface2.DbgModelTargetExceptionContainer;
import agent.dbgeng.model.impl.DbgModelTargetContinuationOptionImpl;
import agent.dbgeng.model.impl.DbgModelTargetExecutionOptionImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Exception", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)})
public class DbgModelTargetExceptionImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetException {
    final String COMMAND_ATTRIBUTE_NAME = "Command";
    final String COMMAND2_ATTRIBUTE_NAME = "SecondCmd";
    final String CONTINUE_OPTION_ATTRIBUTE_NAME = "Continue";
    final String EXECUTE_OPTION_ATTRIBUTE_NAME = "Execute";
    final String EXCEPTION_CODE_ATTRIBUTE_NAME = "Exception";
    protected DbgModelTargetEventOption execOption;
    protected DbgModelTargetEventOption contOption;
    private DbgExceptionFilter filter;

    protected static String indexFilter(DbgExceptionFilter filter) {
        return filter.getName();
    }

    protected static String keyFilter(DbgExceptionFilter filter) {
        return PathUtils.makeKey((String)DbgModelTargetExceptionImpl.indexFilter(filter));
    }

    public DbgModelTargetExceptionImpl(DbgModelTargetExceptionContainer exceptions, DbgExceptionFilter filter) {
        super(exceptions.getModel(), (TargetObject)exceptions, DbgModelTargetExceptionImpl.keyFilter(filter), "ExceptionFilter");
        this.getModel().addModelObject(filter, (TargetObject)this);
        this.filter = filter;
        DebugControl.DebugFilterExecutionOption exec = DebugControl.DebugFilterExecutionOption.getByNumber(filter.getExecutionOption());
        DebugControl.DebugFilterContinuationOption cont = DebugControl.DebugFilterContinuationOption.getByNumber(filter.getContinueOption());
        this.execOption = new DbgModelTargetExecutionOptionImpl(this, exec);
        this.contOption = new DbgModelTargetContinuationOptionImpl(this, cont);
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getIndex(), "Command", filter.getCmd(), "SecondCmd", filter.getCmd(), "Execute", this.execOption, "Continue", this.contOption, "Exception", filter.getExceptionCode()), "Initialized");
        this.getManager().addEventsListener(this);
    }

    @Override
    public DbgExceptionFilter getFilter() {
        return this.filter;
    }

    @Override
    public int getEventIndex() {
        return this.filter.getIndex();
    }

    @Override
    public void eventSelected(AbstractDbgEvent<?> event, DbgCause cause) {
        this.changeAttributes(List.of(), List.of(), Map.of("_modified", false), "Refreshed");
        if (event instanceof DbgExceptionEvent) {
            DebugExceptionRecord64 info = (DebugExceptionRecord64)event.getInfo();
            if ((long)info.code == Long.parseLong(this.filter.getExceptionCode(), 16)) {
                ((DbgModelTargetFocusScope)this.searchForSuitable(TargetFocusScope.class)).setFocus(this);
                this.changeAttributes(List.of(), List.of(), Map.of("_modified", true), "Refreshed");
            }
        }
    }

    public Map<String, TargetMethod.ParameterDescription<?>> getConfigurableOptions() {
        HashMap map = new HashMap();
        TargetMethod.ParameterDescription cmdDesc = TargetMethod.ParameterDescription.create(String.class, (String)"Command", (boolean)false, (Object)"", (String)"Command", (String)"filter command");
        map.put("Command", cmdDesc);
        TargetMethod.ParameterDescription cmdDesc2 = TargetMethod.ParameterDescription.create(String.class, (String)"SecondCmd", (boolean)false, (Object)"", (String)"SecondCmd", (String)"filter 2nd-chance command");
        map.put("SecondCmd", cmdDesc2);
        TargetMethod.ParameterDescription execDesc = TargetMethod.ParameterDescription.create(Integer.class, (String)"Execute", (boolean)false, (Object)this.execOption.getOption(), (String)"Execute", (String)"filter execution option");
        map.put("Execute", execDesc);
        TargetMethod.ParameterDescription contDesc = TargetMethod.ParameterDescription.create(Integer.class, (String)"Continue", (boolean)false, (Object)this.contOption.getOption(), (String)"Continue", (String)"filter continuation option");
        map.put("Continue", contDesc);
        return map;
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        DbgManagerImpl manager = this.getManager();
        switch (key) {
            case "Command": {
                if (value instanceof String) {
                    this.changeAttributes(List.of(), Map.of("Command", value), "Modified");
                    String cmd = (String)this.getCachedAttribute("Command");
                    return manager.execute(new DbgSetFilterCommandCommand(manager, this.getEventIndex(), cmd));
                }
                throw new DebuggerIllegalArgumentException("Command should be a string");
            }
            case "SecondCmd": {
                if (value instanceof String) {
                    this.changeAttributes(List.of(), Map.of("SecondCmd", value), "Modified");
                    String cmd = (String)this.getCachedAttribute("SecondCmd");
                    return manager.execute(new DbgSetFilterSecondChanceCmdCommand(manager, this.getEventIndex(), cmd));
                }
                throw new DebuggerIllegalArgumentException("Command should be a string");
            }
            case "Execute": {
                if (value instanceof Integer) {
                    return this.execOption.setOption((Integer)value);
                }
                throw new DebuggerIllegalArgumentException("Option should be numeric");
            }
            case "Continue": {
                if (value instanceof Integer) {
                    return this.contOption.setOption((Integer)value);
                }
                throw new DebuggerIllegalArgumentException("Option should be numeric");
            }
        }
        return AsyncUtils.NIL;
    }
}

