/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.dbgeng.DebugThreadInfo;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgRunningEvent;
import agent.dbgeng.manager.evt.DbgThreadCreatedEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;

public class DbgRunCommand
extends AbstractDbgCommand<DbgThread> {
    public DbgRunCommand(DbgManagerImpl manager) {
        super(manager);
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            pending.claim(evt);
            return true;
        }
        if (evt instanceof DbgRunningEvent) {
            pending.claim(evt);
        } else if (evt instanceof DbgThreadCreatedEvent) {
            pending.claim(evt);
        }
        return false;
    }

    @Override
    public DbgThread complete(DbgPendingCommand<?> pending) {
        DbgThreadCreatedEvent created = pending.findFirstOf(DbgThreadCreatedEvent.class);
        DebugThreadInfo info = (DebugThreadInfo)created.getInfo();
        DebugSystemObjects so = this.manager.getSystemObjects();
        DebugThreadId tid = so.getThreadIdByHandle(info.handle);
        return this.manager.getThread(tid);
    }

    @Override
    public void invoke() {
    }
}

