/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.async.AsyncUtils;
import ghidra.util.Msg;
import ghidra.util.TriConsumer;
import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;

public class AsyncReference<T, C> {
    private T val;
    private List<TriConsumer<? super T, ? super T, ? super C>> listeners = new ArrayList<TriConsumer<? super T, ? super T, ? super C>>();
    private CompletableFuture<T> changePromise = null;
    private final Map<T, CompletableFuture<Void>> waitsFor = new HashMap<T, CompletableFuture<Void>>();
    private final List<WaitUntilFuture<T>> waitsUntil = new ArrayList<WaitUntilFuture<T>>();
    private FilterFunction<T, ? super C> filter = (cur, set, cause) -> set;
    private Throwable disposalReason;

    public AsyncReference() {
        this(null);
    }

    public AsyncReference(T t) {
        this.val = t;
    }

    public synchronized void filter(FilterFunction<T, ? super C> newFilter) {
        if (newFilter == null) {
            throw new NullPointerException();
        }
        this.filter = newFilter;
    }

    public synchronized T get() {
        return this.val;
    }

    protected CompletableFuture<T> getAndClearChangePromise() {
        CompletableFuture<T> promise = this.changePromise;
        this.changePromise = null;
        return promise;
    }

    protected CompletableFuture<Void> getAndRemoveWaitFor(T t) {
        return this.waitsFor.remove(t);
    }

    protected List<WaitUntilFuture<T>> getAndRemoveUntils(T t) {
        ArrayList<WaitUntilFuture<T>> untils = new ArrayList<WaitUntilFuture<T>>();
        Iterator<WaitUntilFuture<T>> it = this.waitsUntil.iterator();
        while (it.hasNext()) {
            WaitUntilFuture<T> wuf = it.next();
            if (!wuf.predicate.test(t)) continue;
            it.remove();
            untils.add(wuf);
        }
        return untils;
    }

    protected boolean filterAndSet(T t, C cause) {
        if (Objects.equals(this.val, t = this.filter.filter(this.val, t, cause))) {
            return false;
        }
        this.val = t;
        return true;
    }

    protected void invokeListeners(List<TriConsumer<? super T, ? super T, ? super C>> copy, T oldVal, T newVal, C cause) {
        for (TriConsumer<T, T, C> triConsumer : copy) {
            try {
                triConsumer.accept(oldVal, newVal, cause);
            }
            catch (RejectedExecutionException exc) {
                Msg.trace((Object)this, (Object)("Ignoring rejection: " + exc));
            }
            catch (Throwable exc) {
                Msg.error((Object)this, (Object)"Ignoring exception on async reference listener: ", (Throwable)exc);
            }
        }
    }

    protected void invokePromise(CompletableFuture<T> promise, T t) {
        if (promise != null) {
            promise.complete(t);
        }
    }

    protected void invokeWaitFor(CompletableFuture<Void> waiter) {
        if (waiter != null) {
            waiter.complete(null);
        }
    }

    protected void invokeWaitUntils(List<WaitUntilFuture<T>> untils, T t) {
        for (WaitUntilFuture<T> wuf : untils) {
            wuf.complete(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(T newVal, C cause) {
        CompletableFuture<Void> waiter;
        CompletableFuture<T> promise;
        List<TriConsumer<? super T, ? super T, ? super C>> volatileListeners;
        T oldVal;
        ArrayList<WaitUntilFuture<T>> untils = new ArrayList();
        AsyncReference asyncReference = this;
        synchronized (asyncReference) {
            oldVal = this.val;
            if (!this.filterAndSet(newVal, cause)) {
                return false;
            }
            newVal = this.val;
            volatileListeners = this.listeners;
            promise = this.getAndClearChangePromise();
            waiter = this.getAndRemoveWaitFor(newVal);
            untils = this.getAndRemoveUntils(newVal);
        }
        this.invokeListeners(volatileListeners, oldVal, newVal, cause);
        this.invokePromise(promise, newVal);
        this.invokeWaitFor(waiter);
        this.invokeWaitUntils(untils, newVal);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T compute(Function<? super T, ? extends T> func, C cause) {
        CompletableFuture<Void> waiter;
        CompletableFuture<T> promise;
        List<TriConsumer<? super T, ? super T, ? super C>> volatileListeners;
        T newVal;
        T oldVal;
        ArrayList<WaitUntilFuture<T>> untils = new ArrayList();
        AsyncReference asyncReference = this;
        synchronized (asyncReference) {
            oldVal = this.val;
            newVal = func.apply(this.val);
            if (!this.filterAndSet(newVal, cause)) {
                return this.val;
            }
            newVal = this.val;
            volatileListeners = this.listeners;
            promise = this.getAndClearChangePromise();
            waiter = this.getAndRemoveWaitFor(newVal);
            untils = this.getAndRemoveUntils(newVal);
        }
        this.invokeListeners(volatileListeners, oldVal, newVal, cause);
        this.invokePromise(promise, newVal);
        this.invokeWaitFor(waiter);
        this.invokeWaitUntils(untils, newVal);
        return newVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(TriConsumer<? super T, ? super T, ? super C> listener) {
        ArrayList<TriConsumer<T, T, C>> copy = new ArrayList<TriConsumer<T, T, C>>(this.listeners);
        copy.add(listener);
        AsyncReference asyncReference = this;
        synchronized (asyncReference) {
            this.listeners = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeChangeListener(TriConsumer<T, T, C> listener) {
        ArrayList<TriConsumer<T, T, C>> copy = new ArrayList<TriConsumer<T, T, C>>(this.listeners);
        copy.remove(listener);
        AsyncReference asyncReference = this;
        synchronized (asyncReference) {
            this.listeners = copy;
        }
    }

    public synchronized CompletableFuture<T> waitChanged() {
        if (this.disposalReason != null) {
            return CompletableFuture.failedFuture(this.disposalReason);
        }
        if (this.changePromise == null) {
            this.changePromise = new CompletableFuture();
        }
        return this.changePromise;
    }

    public synchronized CompletableFuture<Void> waitValue(T t) {
        if (this.disposalReason != null) {
            return CompletableFuture.failedFuture(this.disposalReason);
        }
        if (Objects.equals(this.val, t)) {
            return AsyncUtils.NIL;
        }
        CompletableFuture<Void> waiter = this.waitsFor.get(t);
        if (waiter == null) {
            waiter = new CompletableFuture();
            this.waitsFor.put(t, waiter);
        }
        return waiter;
    }

    public synchronized CompletableFuture<T> waitUntil(Predicate<T> predicate) {
        if (this.disposalReason != null) {
            return CompletableFuture.failedFuture(this.disposalReason);
        }
        if (predicate.test(this.val)) {
            return CompletableFuture.completedFuture(this.val);
        }
        WaitUntilFuture<T> waiter = new WaitUntilFuture<T>(predicate);
        this.waitsUntil.add(waiter);
        return waiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Throwable reason) {
        ArrayList<CompletableFuture<T>> toExcept = new ArrayList<CompletableFuture<T>>();
        AsyncReference asyncReference = this;
        synchronized (asyncReference) {
            this.disposalReason = reason;
            toExcept.addAll(this.waitsFor.values());
            this.waitsFor.clear();
            toExcept.addAll(this.waitsUntil);
            this.waitsUntil.clear();
            if (this.changePromise != null) {
                toExcept.add(this.changePromise);
                this.changePromise = null;
            }
        }
        ExecutionException ex = new ExecutionException("Disposed", reason);
        for (CompletableFuture completableFuture : toExcept) {
            completableFuture.completeExceptionally(ex);
        }
    }

    public AsyncReference<T, C> debounced(AsyncTimer timer, long windowMillis) {
        return new DebouncedAsyncReference(this, timer, windowMillis);
    }

    protected static class DebouncedAsyncReference<T, C>
    extends AsyncReference<T, C> {
        final State<T, C> state;
        final Cleaner.Cleanable cleanable;

        public DebouncedAsyncReference(AsyncReference<T, C> from, AsyncTimer timer, long windowMillis) {
            super(from.val);
            this.state = new State(new WeakReference(this), from, timer, windowMillis);
            this.cleanable = AsyncUtils.CLEANER.register(this, this.state);
        }

        @Override
        public boolean set(T t, C cause) {
            throw new IllegalStateException("Cannot set a debounced async reference.");
        }

        private boolean doSet(T t, C cause) {
            return super.set(t, cause);
        }

        static class State<T, C>
        implements Runnable,
        TriConsumer<T, T, C> {
            final WeakReference<DebouncedAsyncReference<T, C>> to;
            final AsyncReference<T, C> from;
            final AsyncDebouncer<ChangeRecord<T, C>> db;

            public State(WeakReference<DebouncedAsyncReference<T, C>> to, AsyncReference<T, C> from, AsyncTimer timer, long windowMillis) {
                this.to = to;
                this.from = from;
                this.db = new AsyncDebouncer(timer, windowMillis);
                from.addChangeListener(this);
                this.db.addListener(r -> {
                    DebouncedAsyncReference ref = (DebouncedAsyncReference)to.get();
                    if (ref == null) {
                        return;
                    }
                    ref.doSet(r.val, r.cause);
                });
            }

            public void accept(T oldVal, T newVal, C c) {
                this.db.contact(new ChangeRecord<T, C>(newVal, c));
            }

            @Override
            public void run() {
                this.from.removeChangeListener(this);
            }
        }
    }

    protected static class ChangeRecord<T, C> {
        final T val;
        final C cause;

        public ChangeRecord(T val, C cause) {
            this.val = val;
            this.cause = cause;
        }
    }

    private static class WaitUntilFuture<T>
    extends CompletableFuture<T> {
        private final Predicate<T> predicate;

        public WaitUntilFuture(Predicate<T> predicate) {
            this.predicate = predicate;
        }
    }

    @FunctionalInterface
    public static interface FilterFunction<T, C> {
        public T filter(T var1, T var2, C var3);
    }
}

