/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class FileViewPanel
extends JPanel
implements TreeSelectionListener {
    public static final Dimension FCSSIZE = new Dimension(450, 200);
    final String TITLE = "Files";
    public int type;
    public JTree tree;
    public DefaultTreeModel treeModel;
    public DefaultMutableTreeNode top;
    private CellSymphony cs;

    public FileViewPanel(CellSymphony cs) {
        this.cs = cs;
        this.setLayout(new BoxLayout(this, 1));
        JLabel tip = new JLabel("Drag folder or FCS data files here:");
        tip.setAlignmentX(0.0f);
        this.add(tip);
        this.top = new DefaultMutableTreeNode("Files");
        this.treeModel = new DefaultTreeModel(this.top);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setTransferHandler(new FileListTransferHandler(this));
        JScrollPane fileViewScroller = new JScrollPane(this.tree);
        fileViewScroller.setMinimumSize(FCSSIZE);
        fileViewScroller.setPreferredSize(FCSSIZE);
        fileViewScroller.setAlignmentX(0.0f);
        this.add(fileViewScroller);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        FileSpec fs;
        String path;
        File file;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node != this.top && node.isLeaf() && (file = (File)node.getUserObject()) != null && (path = file.getPath()) != null && FileSpec.isFCS(path) && (fs = new FileSpec(path)) != null) {
            this.cs.set(fs);
        }
    }

    public DefaultMutableTreeNode insertFile(File file) {
        return this.insertFile(file, false, true);
    }

    public DefaultMutableTreeNode insertFile(File file, boolean restricted, boolean cleanup) {
        TreePath tp;
        DefaultMutableTreeNode node = null;
        File parentF = null;
        parentF = file.getParentFile();
        node = parentF == null || file.getPath().equals(File.separator) ? this.top : ((tp = this.tree.getNextMatch(parentF.getPath(), 0, Position.Bias.Forward)) != null ? (DefaultMutableTreeNode)tp.getLastPathComponent() : this.insertFile(parentF, true, false));
        return this.addFile(node, file, restricted, cleanup);
    }

    public void deleteSelectedFile() {
        DefaultMutableTreeNode currentNode;
        DefaultMutableTreeNode parent;
        TreePath currentSelection = this.tree.getSelectionPath();
        if (currentSelection != null && (parent = (DefaultMutableTreeNode)(currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(currentNode);
            while (parent != null && parent.getChildCount() == 0) {
                currentNode = parent;
                if ((parent = (DefaultMutableTreeNode)currentNode.getParent()) == null) continue;
                this.treeModel.removeNodeFromParent(currentNode);
            }
            return;
        }
    }

    public String nextFile(String xpath, int inc) {
        DefaultMutableTreeNode sibling;
        TreePath tp = this.tree.getNextMatch(xpath, 0, Position.Bias.Forward);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        int numKids = parent.getChildCount();
        int index = parent.getIndex(node);
        if (index + inc < 0 || index + inc >= numKids || (sibling = (DefaultMutableTreeNode)parent.getChildAt(index + inc)) == null) {
            return null;
        }
        return ((File)sibling.getUserObject()).getPath();
    }

    private boolean validFile(File f) {
        return FileSpec.isFCS(f.getPath());
    }

    public DefaultMutableTreeNode addFile(DefaultMutableTreeNode node, File file, boolean restricted, boolean cleanup) {
        File[] list = null;
        DefaultMutableTreeNode item = new DefaultMutableTreeNode(file);
        if (file.isDirectory() || this.validFile(file)) {
            TreePath tp = this.tree.getNextMatch(file.getPath(), 0, Position.Bias.Forward);
            if (tp != null) {
                item = (DefaultMutableTreeNode)tp.getLastPathComponent();
            } else {
                this.treeModel.insertNodeInto(item, node, node.getChildCount());
            }
            tp = new TreePath(item.getPath());
            this.tree.scrollPathToVisible(tp);
            if (file.isDirectory() && !restricted) {
                list = file.listFiles();
                int i = 0;
                while (i < list.length) {
                    this.addFile(item, list[i], restricted, false);
                    ++i;
                }
                if (this.treeModel.getChildCount(item) <= 0) {
                    this.treeModel.removeNodeFromParent(item);
                }
            } else if (this.validFile(file)) {
                this.tree.setSelectionPath(tp);
            }
            return item;
        }
        if (cleanup) {
            File f2 = file.getParentFile();
            while (true) {
                TreePath tp;
                if ((tp = this.tree.getNextMatch(f2.getPath(), 0, Position.Bias.Forward)) == null) {
                    continue;
                }
                item = (DefaultMutableTreeNode)tp.getLastPathComponent();
                if (this.treeModel.getChildCount(item) > 0) break;
                this.treeModel.removeNodeFromParent(item);
                if ((f2 = f2.getParentFile()) == null) break;
            }
        }
        return null;
    }

    public File[] getAllSelectedFiles() {
        Vector<File> fileV = new Vector<File>();
        int min = this.tree.getMinSelectionRow();
        int max = this.tree.getMaxSelectionRow();
        int i = min;
        while (i <= max) {
            TreePath tp = this.tree.getPathForRow(i);
            if (tp == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
            if (node != this.top && node != null && node.isLeaf()) {
                fileV.add((File)node.getUserObject());
            }
            ++i;
        }
        int count = fileV.size();
        if (count > 0) {
            File[] file = new File[count];
            i = 0;
            while (i < count) {
                file[i] = (File)fileV.elementAt(i);
                ++i;
            }
            return file;
        }
        return null;
    }

    public File[] getAllFiles() {
        TreePath tp;
        Vector<File> fileV = new Vector<File>();
        int max = this.tree.getRowCount();
        if (max <= 0) {
            return null;
        }
        int i = 0;
        while ((tp = this.tree.getPathForRow(i)) != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
            if (node != this.top && node != null && node.isLeaf()) {
                fileV.add((File)node.getUserObject());
            }
            this.tree.expandRow(i++);
        }
        int count = fileV.size();
        if (count > 0) {
            File[] file = new File[count];
            i = 0;
            while (i < count) {
                file[i] = (File)fileV.elementAt(i);
                ++i;
            }
            return file;
        }
        return null;
    }

    public File getSingleSelectedFile() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != this.top && node != null && node.isLeaf()) {
            File file = (File)node.getUserObject();
            return file;
        }
        return null;
    }
}

