/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Page;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class Wizard
extends JPanel {
    protected JButton cancelButton;
    protected JButton prevButton;
    protected JButton nextButton;
    private Page[] pages;
    private int currentPage;
    private static int PADDING = 12;

    public Wizard() {
        ActionHandler actionHandler = new ActionHandler();
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setRequestFocusEnabled(false);
        this.cancelButton.addActionListener(actionHandler);
        this.prevButton = new JButton("Previous");
        this.prevButton.setRequestFocusEnabled(false);
        this.prevButton.addActionListener(actionHandler);
        this.nextButton = new JButton("Next");
        this.nextButton.setRequestFocusEnabled(false);
        this.nextButton.addActionListener(actionHandler);
        this.setLayout(new WizardLayout());
        this.add(this.cancelButton);
        this.add(this.prevButton);
        this.add(this.nextButton);
    }

    public void setPages(Page[] pages) {
        this.pages = pages;
        for (int i = 0; i < pages.length; ++i) {
            this.add(pages[i]);
        }
        this.pageChanged();
    }

    public boolean previousPage() {
        this.getCurrentPage().validatePageData();
        if (!this.getCurrentPage().canPreviousPage()) {
            return false;
        }
        if (this.currentPage <= 0) {
            return false;
        }
        --this.currentPage;
        this.pageChanged();
        return true;
    }

    public boolean nextPage() {
        this.getCurrentPage().validatePageData();
        if (!this.getCurrentPage().canNextPage()) {
            return false;
        }
        if (this.currentPage == this.pages.length - 1) {
            this.finishCallback();
            return false;
        }
        ++this.currentPage;
        this.pageChanged();
        return true;
    }

    public Page getCurrentPage() {
        return this.pages[this.currentPage];
    }

    protected abstract void cancelCallback();

    protected abstract void finishCallback();

    private void pageChanged() {
        this.prevButton.setEnabled(this.currentPage > 0 && this.getCurrentPage().canPreviousPage());
        this.nextButton.setText(this.getCurrentPage().getNextButtonLabel());
        this.nextButton.setEnabled(this.getCurrentPage().canNextPage());
        this.revalidate();
        this.getCurrentPage().madeVisible();
    }

    class WizardLayout
    implements LayoutManager {
        WizardLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            for (int i = 0; i < Wizard.this.pages.length; ++i) {
                Dimension _dim = Wizard.this.pages[i].getPreferredSize();
                dim.width = Math.max(_dim.width, dim.width);
                dim.height = Math.max(_dim.height, dim.height);
            }
            dim.width += PADDING * 2;
            dim.height += PADDING * 2;
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            Dimension size = Wizard.this.getSize();
            Dimension buttonSize = Wizard.this.cancelButton.getPreferredSize();
            buttonSize.width = Math.max(buttonSize.width, Wizard.this.prevButton.getPreferredSize().width);
            buttonSize.width = Math.max(buttonSize.width, Wizard.this.nextButton.getPreferredSize().width);
            int bottomBorder = buttonSize.height + PADDING;
            Wizard.this.cancelButton.setBounds(PADDING, size.height - buttonSize.height - PADDING, buttonSize.width, buttonSize.height);
            Wizard.this.prevButton.setBounds(size.width - buttonSize.width * 2 - 6 - PADDING, size.height - buttonSize.height - PADDING, buttonSize.width, buttonSize.height);
            Wizard.this.nextButton.setBounds(size.width - buttonSize.width - PADDING, size.height - buttonSize.height - PADDING, buttonSize.width, buttonSize.height);
            Rectangle currentPageBounds = new Rectangle();
            currentPageBounds.x = PADDING;
            currentPageBounds.y = PADDING;
            currentPageBounds.width = size.width - PADDING * 2;
            currentPageBounds.height = size.height - PADDING - bottomBorder - PADDING;
            for (int i = 0; i < Wizard.this.pages.length; ++i) {
                Page page = Wizard.this.pages[i];
                page.setBounds(currentPageBounds);
                ((Component)page).setVisible(i == Wizard.this.currentPage);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (evt.getSource() == Wizard.this.cancelButton) {
                Wizard.this.cancelCallback();
            } else if (evt.getSource() == Wizard.this.prevButton) {
                Wizard.this.previousPage();
            } else if (evt.getSource() == Wizard.this.nextButton) {
                Wizard.this.nextPage();
            }
        }
    }
}

