/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.branches;

import edsim51sh.Memory;
import edsim51sh.Text;
import edsim51sh.instructions.branches.Branch;

public class DjnzReg
extends Branch {
    private int registerNumber;

    public DjnzReg(int registerNumber) {
        this.registerNumber = registerNumber;
        this.mneumonic = "DJNZ R" + registerNumber + ",";
        this.size = 2;
        this.cycles = 2;
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        int regData;
        if ((pc += this.size) > 65535) {
            pc -= 65536;
        }
        if ((regData = ram.readRegister(this.registerNumber) - 1) == -1) {
            regData = 255;
        }
        ram.writeRegister(this.registerNumber, regData);
        if (regData != 0) {
            if ((pc += ram.toSignedNumber(this.operand0)) > 65535) {
                pc -= 65536;
            } else if (pc < 0) {
                pc = 65536 + pc;
            }
        }
        return pc;
    }

    @Override
    public String toString() {
        return "DJNZ R" + this.registerNumber + "," + Text.inHex(this.operand0, false) + "H";
    }

    @Override
    public int getOpcode() {
        return 216 + this.registerNumber;
    }
}

