/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.SDIException;
import org.forester.util.ForesterUtil;

public class SDIutil {
    public static final TaxonomyComparisonBase determineTaxonomyComparisonBase(Phylogeny phylogeny) throws SDIException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy()) continue;
            Taxonomy taxonomy = phylogenyNode.getNodeData().getTaxonomy();
            if (taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue()) && ++n > n4) {
                n4 = n;
            }
            if (!ForesterUtil.isEmpty(taxonomy.getTaxonomyCode()) && ++n2 > n4) {
                n4 = n2;
            }
            if (ForesterUtil.isEmpty(taxonomy.getScientificName()) || ++n3 <= n4) continue;
            n4 = n3;
        }
        if (n4 == 0) {
            throw new SDIException("gene tree has no taxonomic data");
        }
        if (n4 == 1) {
            throw new SDIException("gene tree has only one node with taxonomic data");
        }
        if (n4 == n) {
            return TaxonomyComparisonBase.ID;
        }
        if (n4 == n3) {
            return TaxonomyComparisonBase.SCIENTIFIC_NAME;
        }
        return TaxonomyComparisonBase.CODE;
    }

    public static final Phylogeny parseSpeciesTree(Phylogeny phylogeny, File file, boolean bl, boolean bl2, NHXParser.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION) throws FileNotFoundException, PhyloXmlDataFormatException, IOException, SDIException {
        Phylogeny phylogeny2;
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
        if (phylogenyParser instanceof PhyloXmlParser) {
            phylogeny2 = phylogenyFactory.create(file, phylogenyParser)[0];
        } else {
            Object object;
            if (phylogenyParser instanceof NHXParser) {
                object = (NHXParser)phylogenyParser;
                ((NHXParser)object).setReplaceUnderscores(bl);
                ((NHXParser)object).setIgnoreQuotes(bl2);
                ((NHXParser)object).setTaxonomyExtraction(tAXONOMY_EXTRACTION);
            } else if (phylogenyParser instanceof NexusPhylogeniesParser) {
                object = (NexusPhylogeniesParser)phylogenyParser;
                ((NexusPhylogeniesParser)object).setReplaceUnderscores(bl);
                ((NexusPhylogeniesParser)object).setIgnoreQuotes(bl2);
                ((NexusPhylogeniesParser)object).setTaxonomyExtraction(tAXONOMY_EXTRACTION);
            }
            phylogeny2 = phylogenyFactory.create(file, phylogenyParser)[0];
            phylogeny2.setRooted(true);
            object = SDIutil.determineTaxonomyComparisonBase(phylogeny);
            switch (1.$SwitchMap$org$forester$sdi$SDIutil$TaxonomyComparisonBase[((Enum)object).ordinal()]) {
                case 1: {
                    PhylogenyMethods.transferNodeNameToField(phylogeny2, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME, true);
                    break;
                }
                case 2: {
                    PhylogenyMethods.transferNodeNameToField(phylogeny2, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE, true);
                    break;
                }
                case 3: {
                    PhylogenyMethods.transferNodeNameToField(phylogeny2, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_ID, true);
                    break;
                }
                default: {
                    throw new SDIException("unable to determine comparison base");
                }
            }
        }
        return phylogeny2;
    }

    static String taxonomyToString(PhylogenyNode phylogenyNode, TaxonomyComparisonBase taxonomyComparisonBase) {
        switch (taxonomyComparisonBase) {
            case ID: {
                Identifier identifier = phylogenyNode.getNodeData().getTaxonomy().getIdentifier();
                if (identifier == null) {
                    return null;
                }
                return identifier.getValuePlusProvider();
            }
            case CODE: {
                return phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode();
            }
            case SCIENTIFIC_NAME: {
                return phylogenyNode.getNodeData().getTaxonomy().getScientificName();
            }
        }
        throw new IllegalArgumentException("unknown comparison base for taxonomies: " + (Object)((Object)taxonomyComparisonBase));
    }

    public static enum TaxonomyComparisonBase {
        ID{

            public String toString() {
                return "taxonomy id";
            }
        }
        ,
        CODE{

            public String toString() {
                return "taxonomy code/mnemonic";
            }
        }
        ,
        SCIENTIFIC_NAME{

            public String toString() {
                return "scientific name";
            }
        };

    }

    public static enum ALGORITHM {
        GSDIR,
        GSDI,
        SDI,
        SDIR;

    }
}

