/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import java.util.Arrays;
import java.util.TreeSet;

public class ChartUtilities {
    public static double[] performAutoScale(double min, double max) {
        double[] d = new double[2];
        double diff = max - min;
        d[0] = ChartUtilities.floor(min, ChartUtilities.exp(diff));
        d[1] = ChartUtilities.ceil(max, ChartUtilities.exp(diff));
        return d;
    }

    public static double calculateTickSpacing(double min, double max) {
        double spacing = 1.0;
        double diff = max - min;
        int exp = ChartUtilities.exp(diff);
        if (diff / (spacing = 1.0 * Math.pow(10.0, --exp)) < 20.0) {
            return 0.5 * spacing;
        }
        if (diff / spacing > 40.0) {
            return 2.0 * spacing;
        }
        return spacing;
    }

    public static double interpolate(double[] xa, double[] ya, double x) {
        if (xa.length != ya.length || xa.length == 0 || ya.length == 0) {
            System.out.println("** Invalid Parameter");
            return Double.NaN;
        }
        int n = xa.length;
        double y = 0.0;
        double dy = 0.0;
        int ns = 1;
        double[] c = new double[n];
        double[] d = new double[n];
        double dif = Math.abs(x - xa[0]);
        int i = 0;
        while (i < n) {
            double d2;
            double dift = Math.abs(x - xa[i]);
            if (d2 < dif) {
                ns = i;
                dif = dift;
            }
            c[i] = ya[i];
            d[i] = ya[i];
            ++i;
        }
        y = ya[ns--];
        int m = 0;
        while (m < n - 1) {
            i = 0;
            while (i < n - m - 1) {
                double ho = xa[i] - x;
                double hp = xa[i + m + 1] - x;
                double w = c[i + 1] - d[i];
                double den = ho - hp;
                if (den == 0.0) {
                    return Double.NaN;
                }
                den = w / den;
                d[i] = hp * den;
                c[i] = ho * den;
                ++i;
            }
            dy = 2 * (ns + 1) < n - m ? c[ns + 1] : d[ns--];
            y += dy;
            ++m;
        }
        return y;
    }

    public static double floor(double d, int exp) {
        double x = 1.0 * Math.pow(10.0, exp);
        return Math.floor(d / x) * x;
    }

    public static double ceil(double d, int exp) {
        double x = 1.0 * Math.pow(10.0, exp);
        return Math.ceil(d / x) * x;
    }

    public static int exp(double d) {
        int exp = 0;
        boolean positive = d <= -1.0 || d >= 1.0;
        while (d <= -10.0 || d >= 10.0 || d > -1.0 && d < 1.0) {
            if (positive) {
                d /= 10.0;
                ++exp;
                continue;
            }
            d *= 10.0;
            --exp;
        }
        return exp;
    }

    public static Number[][] transformArray(int[][] data) {
        Number[][] n = new Number[data.length][data[0].length];
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[0].length) {
                n[i][j] = new Integer(data[i][j]);
                ++j;
            }
            ++i;
        }
        return n;
    }

    public static Number[][] transformArray(double[][] data) {
        Number[][] n = new Number[data.length][data[0].length];
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[0].length) {
                n[i][j] = new Double(data[i][j]);
                ++j;
            }
            ++i;
        }
        return n;
    }

    public static Number[] transformArray(double[] data) {
        Number[] n = new Number[data.length];
        int i = 0;
        while (i < data.length) {
            n[i] = new Double(data[i]);
            ++i;
        }
        return n;
    }

    public static Number[] transformArray(int[] data) {
        Number[] n = new Number[data.length];
        int i = 0;
        while (i < data.length) {
            n[i] = new Integer(data[i]);
            ++i;
        }
        return n;
    }

    public static void addDataToSet(TreeSet set, Number[][] data) {
        int i = 0;
        while (i < data.length) {
            set.addAll(Arrays.asList(data[i]));
            ++i;
        }
    }

    public static void main(String[] args) {
        double min = -0.00337;
        double max = 0.00745;
        double[] d = ChartUtilities.performAutoScale(min, max);
        System.out.println("** AutoScaling: (" + min + ", " + max + ") -> (" + d[0] + ", " + d[1] + ")");
        double s = ChartUtilities.calculateTickSpacing(d[0], d[1]);
        System.out.print("** Ticks: ");
        double i = d[0];
        while (i <= d[1]) {
            System.out.print(" " + i + " ");
            i += s;
        }
        System.out.println();
        System.out.println("** Performing interpolation for 4*x^2");
        System.out.println("** Given values [-4, 64], [0, 0], [3, 36]");
        double[] xa = new double[]{-4.0, 0.0, 3.0};
        double[] ya = new double[]{64.0, 0.0, 36.0};
        System.out.print("** Calculating values");
        double i2 = -5.0;
        while (i2 < 6.0) {
            System.out.print("[" + i2 + ", " + ChartUtilities.interpolate(xa, ya, i2) + "]");
            i2 += 0.5;
        }
        System.out.println();
        System.out.println("** Performing interpolation for 5 * x^3 - 4 * x^2 + 2 * x - 5");
        System.out.println("** Given values [-5, -740], [0, -5], [1, -2], [5, 530]");
        double[] xb = new double[]{-5.0, 0.0, 1.0, 5.0};
        double[] yb = new double[]{-740.0, -5.0, -2.0, 530.0};
        System.out.print("** Calculating values ");
        double i3 = -5.0;
        while (i3 < 6.0) {
            System.out.print("[" + i3 + ", " + ChartUtilities.interpolate(xb, yb, i3) + "]");
            i3 += 0.5;
        }
        System.out.println();
    }
}

