/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.fastq;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.fastq.FastqRecord;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FastqReader
implements Iterator<FastqRecord>,
Iterable<FastqRecord>,
Closeable {
    private final File fastqFile;
    private final BufferedReader reader;
    private FastqRecord nextRecord;
    private int line = 1;
    private final boolean skipBlankLines;

    public FastqReader(File file) {
        this(file, false);
    }

    public FastqReader(File file, boolean skipBlankLines) {
        this(file, IOUtil.openFileForBufferedReading(file), skipBlankLines);
    }

    public FastqReader(BufferedReader reader) {
        this(null, reader);
    }

    public FastqReader(File file, BufferedReader reader, boolean skipBlankLines) {
        this.fastqFile = file;
        this.reader = reader;
        this.skipBlankLines = skipBlankLines;
        this.nextRecord = this.readNextRecord();
    }

    public FastqReader(File file, BufferedReader reader) {
        this(file, reader, false);
    }

    private FastqRecord readNextRecord() {
        try {
            String seqHeader = this.readLineConditionallySkippingBlanks();
            if (seqHeader == null) {
                return null;
            }
            if (StringUtil.isBlank(seqHeader)) {
                throw new SAMException(this.error("Missing sequence header"));
            }
            if (!seqHeader.startsWith("@")) {
                throw new SAMException(this.error("Sequence header must start with @: " + seqHeader));
            }
            String seqLine = this.readLineConditionallySkippingBlanks();
            this.checkLine(seqLine, LineType.SequenceLine);
            String qualHeader = this.readLineConditionallySkippingBlanks();
            this.checkLine(qualHeader, LineType.QualityHeader);
            if (!qualHeader.startsWith("+")) {
                throw new SAMException(this.error("Quality header must start with +: " + qualHeader));
            }
            String qualLine = this.readLineConditionallySkippingBlanks();
            this.checkLine(qualLine, LineType.QualityLine);
            if (seqLine.length() != qualLine.length()) {
                throw new SAMException(this.error("Sequence and quality line must be the same length"));
            }
            FastqRecord frec = new FastqRecord(seqHeader.substring(1, seqHeader.length()), seqLine, qualHeader.substring(1, qualHeader.length()), qualLine);
            this.line += 4;
            return frec;
        }
        catch (IOException e) {
            throw new SAMException(this.error(e.getMessage()), e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextRecord != null;
    }

    @Override
    public FastqRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next() called when !hasNext()");
        }
        FastqRecord rec = this.nextRecord;
        this.nextRecord = this.readNextRecord();
        return rec;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public Iterator<FastqRecord> iterator() {
        return this;
    }

    public int getLineNumber() {
        return this.line;
    }

    public File getFile() {
        return this.fastqFile;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new SAMException(this.error(e.getMessage()), e);
        }
    }

    protected void checkLine(String line, LineType kind) {
        if (line == null) {
            throw new SAMException(this.error("File is too short - missing " + (Object)((Object)kind)));
        }
        if (StringUtil.isBlank(line)) {
            throw new SAMException(this.error("Missing " + (Object)((Object)kind)));
        }
    }

    protected String error(String msg) {
        return msg + " at line " + this.line + " in fastq " + this.getAbsolutePath();
    }

    private String getAbsolutePath() {
        if (this.fastqFile == null) {
            return "";
        }
        return this.fastqFile.getAbsolutePath();
    }

    private String readLineConditionallySkippingBlanks() throws IOException {
        String line;
        do {
            if ((line = this.reader.readLine()) != null) continue;
            return line;
        } while (this.skipBlankLines && StringUtil.isBlank(line));
        return line;
    }

    public String toString() {
        return "FastqReader[" + (this.fastqFile == null ? "" : this.fastqFile) + " Line:" + this.getLineNumber() + "]";
    }

    protected static enum LineType {
        SequenceHeader("Sequence Header"),
        SequenceLine("Sequence Line"),
        QualityHeader("Quality Header"),
        QualityLine("Quality Line");

        private String printable;

        private LineType(String printable) {
            this.printable = printable;
        }

        public String toString() {
            return this.printable;
        }
    }
}

