/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant.New;

import htsjdk.tribble.Feature;
import org.broad.igv.Globals;

public class Variant
implements Feature {
    String chr;
    int pos;
    String names;
    String referenceBases;
    String alternateBases;
    int quality;
    String filter;
    String info;
    int start;
    int end;
    String[] alleles;

    public String getChr() {
        return this.chr;
    }

    public String getContig() {
        return this.chr;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getValueString(int genomicPosition) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Chr: " + this.chr + "<br>");
        buffer.append("Pos: " + (this.pos + 1));
        if (this.names != null) {
            buffer.append("Names: " + this.names + "<br>");
        }
        buffer.append("Ref: " + this.alleles[0] + "<br>");
        if (this.alleles.length > 1) {
            for (int i = 1; i < this.alleles.length; ++i) {
                buffer.append(this.alleles[i]);
                if (i < this.alleles.length - 1) {
                    buffer.append(", ");
                }
                buffer.append("<br>");
            }
        }
        buffer.append("Quality: " + this.quality + "<br>");
        buffer.append("Filter: " + this.filter);
        if (this.info != null) {
            String[] infoFields;
            buffer.append("<hr>");
            for (String ifield : infoFields = Globals.semicolonPattern.split(this.info)) {
                buffer.append(ifield + "<br>");
            }
        }
        return buffer.toString();
    }
}

