/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unicode;

public final class UnicodeCharUtil {
    private UnicodeCharUtil() {
    }

    private static boolean isInRange(char c, int l, int h) {
        return c >= l && c <= h;
    }

    public static char foldNonDiacriticChar(char c) {
        switch (c) {
            case '\u0181': {
                return 'B';
            }
            case '\u0182': {
                return 'B';
            }
            case '\u0187': {
                return 'C';
            }
            case '\u0110': {
                return 'D';
            }
            case '\u018a': {
                return 'D';
            }
            case '\u018b': {
                return 'D';
            }
            case '\u0191': {
                return 'F';
            }
            case '\u0193': {
                return 'G';
            }
            case '\u01e4': {
                return 'G';
            }
            case '\u0126': {
                return 'H';
            }
            case '\u0197': {
                return 'I';
            }
            case '\u0198': {
                return 'K';
            }
            case '\u0141': {
                return 'L';
            }
            case '\u019d': {
                return 'N';
            }
            case '\u0220': {
                return 'N';
            }
            case '\u00d8': {
                return 'O';
            }
            case '\u019f': {
                return 'O';
            }
            case '\u01fe': {
                return 'O';
            }
            case '\u01a4': {
                return 'P';
            }
            case '\u0166': {
                return 'T';
            }
            case '\u01ac': {
                return 'T';
            }
            case '\u01ae': {
                return 'T';
            }
            case '\u01b2': {
                return 'V';
            }
            case '\u01b3': {
                return 'Y';
            }
            case '\u01b5': {
                return 'Z';
            }
            case '\u0224': {
                return 'Z';
            }
            case '\u0180': {
                return 'b';
            }
            case '\u0183': {
                return 'b';
            }
            case '\u0253': {
                return 'b';
            }
            case '\u0188': {
                return 'c';
            }
            case '\u0255': {
                return 'c';
            }
            case '\u0111': {
                return 'd';
            }
            case '\u018c': {
                return 'd';
            }
            case '\u0221': {
                return 'd';
            }
            case '\u0256': {
                return 'd';
            }
            case '\u0257': {
                return 'd';
            }
            case '\u0192': {
                return 'f';
            }
            case '\u01e5': {
                return 'g';
            }
            case '\u0260': {
                return 'g';
            }
            case '\u0127': {
                return 'h';
            }
            case '\u0266': {
                return 'h';
            }
            case '\u0268': {
                return 'i';
            }
            case '\u029d': {
                return 'j';
            }
            case '\u0199': {
                return 'k';
            }
            case '\u0142': {
                return 'l';
            }
            case '\u019a': {
                return 'l';
            }
            case '\u0234': {
                return 'l';
            }
            case '\u026b': {
                return 'l';
            }
            case '\u026c': {
                return 'l';
            }
            case '\u026d': {
                return 'l';
            }
            case '\u0271': {
                return 'm';
            }
            case '\u019e': {
                return 'n';
            }
            case '\u0235': {
                return 'n';
            }
            case '\u0272': {
                return 'n';
            }
            case '\u0273': {
                return 'n';
            }
            case '\u00f8': {
                return 'o';
            }
            case '\u01ff': {
                return 'o';
            }
            case '\u01a5': {
                return 'p';
            }
            case '\u02a0': {
                return 'q';
            }
            case '\u027c': {
                return 'r';
            }
            case '\u027d': {
                return 'r';
            }
            case '\u0282': {
                return 's';
            }
            case '\u0167': {
                return 't';
            }
            case '\u01ab': {
                return 't';
            }
            case '\u01ad': {
                return 't';
            }
            case '\u0236': {
                return 't';
            }
            case '\u0288': {
                return 't';
            }
            case '\u028b': {
                return 'v';
            }
            case '\u01b4': {
                return 'y';
            }
            case '\u01b6': {
                return 'z';
            }
            case '\u0225': {
                return 'z';
            }
            case '\u0290': {
                return 'z';
            }
            case '\u0291': {
                return 'z';
            }
            case '\u025a': {
                return '\u0259';
            }
            case '\u0286': {
                return '\u0283';
            }
            case '\u01ba': {
                return '\u0292';
            }
            case '\u0293': {
                return '\u0292';
            }
            case '\u0490': {
                return '\u0413';
            }
            case '\u0492': {
                return '\u0413';
            }
            case '\u0494': {
                return '\u0413';
            }
            case '\u0496': {
                return '\u0416';
            }
            case '\u0498': {
                return '\u0417';
            }
            case '\u048a': {
                return '\u0419';
            }
            case '\u049a': {
                return '\u041a';
            }
            case '\u049c': {
                return '\u041a';
            }
            case '\u049e': {
                return '\u041a';
            }
            case '\u04c3': {
                return '\u041a';
            }
            case '\u04c5': {
                return '\u041b';
            }
            case '\u04cd': {
                return '\u041c';
            }
            case '\u04a2': {
                return '\u041d';
            }
            case '\u04c7': {
                return '\u041d';
            }
            case '\u04c9': {
                return '\u041d';
            }
            case '\u04a6': {
                return '\u041f';
            }
            case '\u048e': {
                return '\u0420';
            }
            case '\u04aa': {
                return '\u0421';
            }
            case '\u04ac': {
                return '\u0422';
            }
            case '\u04b2': {
                return '\u0425';
            }
            case '\u04b3': {
                return '\u0425';
            }
            case '\u0491': {
                return '\u0433';
            }
            case '\u0493': {
                return '\u0433';
            }
            case '\u0495': {
                return '\u0433';
            }
            case '\u0497': {
                return '\u0436';
            }
            case '\u0499': {
                return '\u0437';
            }
            case '\u048b': {
                return '\u0439';
            }
            case '\u049b': {
                return '\u043a';
            }
            case '\u049d': {
                return '\u043a';
            }
            case '\u049f': {
                return '\u043a';
            }
            case '\u04c4': {
                return '\u043a';
            }
            case '\u04c6': {
                return '\u043b';
            }
            case '\u04ce': {
                return '\u043c';
            }
            case '\u04a3': {
                return '\u043d';
            }
            case '\u04c8': {
                return '\u043d';
            }
            case '\u04ca': {
                return '\u043d';
            }
            case '\u04a7': {
                return '\u043f';
            }
            case '\u048f': {
                return '\u0440';
            }
            case '\u04ab': {
                return '\u0441';
            }
            case '\u04ad': {
                return '\u0442';
            }
            case '\u04b9': {
                return '\u0447';
            }
            case '\u047c': {
                return '\u0460';
            }
            case '\u047d': {
                return '\u0461';
            }
            case '\u04b0': {
                return '\u04ae';
            }
            case '\u04b1': {
                return '\u04af';
            }
            case '\u04b6': {
                return '\u04bc';
            }
            case '\u04b7': {
                return '\u04bc';
            }
            case '\u04b8': {
                return '\u04bc';
            }
            case '\u04be': {
                return '\u04bc';
            }
            case '\u04bf': {
                return '\u04bc';
            }
            case '\u04cb': {
                return '\u04bc';
            }
            case '\u04cc': {
                return '\u04bc';
            }
        }
        return '\u0000';
    }

    public static boolean isSpacingModifier(char c) {
        char cval = c;
        int hiByte = cval >>> 8;
        switch (hiByte) {
            case 2: {
                return UnicodeCharUtil.isInRange(c, 688, 767);
            }
            case 3: {
                return c == '\u0374' || c == '\u037a';
            }
            case 5: {
                return c == '\u0559';
            }
            case 6: {
                return c == '\u0640' || c == '\u06e5' || c == '\u06e6';
            }
            case 7: {
                return c == '\u07f4' || c == '\u07f5' || c == '\u07fa';
            }
            case 9: {
                return c == '\u0971';
            }
            case 14: {
                return c == '\u0e46' || c == '\u0ec6';
            }
            case 16: {
                return c == '\u10fc';
            }
            case 23: {
                return c == '\u17d7';
            }
            case 24: {
                return c == '\u1843';
            }
            case 28: {
                return UnicodeCharUtil.isInRange(c, 7288, 7293);
            }
            case 29: {
                return UnicodeCharUtil.isInRange(c, 7468, 7521) || c == '\u1d78' || UnicodeCharUtil.isInRange(c, 7579, 7615) || UnicodeCharUtil.isInRange(c, 8424, 8432);
            }
            case 32: {
                return UnicodeCharUtil.isInRange(c, 8336, 8340);
            }
            case 44: {
                return c == '\u2c7d';
            }
            case 45: {
                return c == '\u2d6f';
            }
            case 46: {
                return c == '\u2e2f';
            }
            case 48: {
                return c == '\u3005' || UnicodeCharUtil.isInRange(c, 12337, 12341) || c == '\u303b' || UnicodeCharUtil.isInRange(c, 12445, 12446) || UnicodeCharUtil.isInRange(c, 12540, 12542);
            }
        }
        return false;
    }

    public static boolean isCombiningCharacter(char c) {
        char cval = c;
        int hiByte = cval >>> 8;
        switch (hiByte) {
            case 3: {
                return UnicodeCharUtil.isInRange(c, 768, 846) || UnicodeCharUtil.isInRange(c, 848, 866);
            }
            case 4: {
                return UnicodeCharUtil.isInRange(c, 1155, 1159);
            }
            case 5: {
                return UnicodeCharUtil.isInRange(c, 1425, 1469) || c == '\u05bf' || UnicodeCharUtil.isInRange(c, 1473, 1474) || UnicodeCharUtil.isInRange(c, 1476, 1477) || c == '\u05c7';
            }
            case 6: {
                return UnicodeCharUtil.isInRange(c, 1611, 1618) || UnicodeCharUtil.isInRange(c, 1623, 1624) || UnicodeCharUtil.isInRange(c, 1759, 1760) || UnicodeCharUtil.isInRange(c, 1770, 1772);
            }
            case 7: {
                return UnicodeCharUtil.isInRange(c, 1840, 1866) || UnicodeCharUtil.isInRange(c, 1958, 1968) || UnicodeCharUtil.isInRange(c, 2027, 2035);
            }
            case 9: {
                return UnicodeCharUtil.isInRange(c, 2305, 2306) || c == '\u093c' || UnicodeCharUtil.isInRange(c, 2369, 2376) || c == '\u094d' || UnicodeCharUtil.isInRange(c, 2385, 2388) || UnicodeCharUtil.isInRange(c, 2402, 2403) || c == '\u0981' || c == '\u09bc' || UnicodeCharUtil.isInRange(c, 2497, 2500) || c == '\u09cd' || UnicodeCharUtil.isInRange(c, 2529, 2531);
            }
            case 10: {
                return UnicodeCharUtil.isInRange(c, 2561, 2562) || c == '\u0a3c' || UnicodeCharUtil.isInRange(c, 2625, 2626) || UnicodeCharUtil.isInRange(c, 2631, 2632) || UnicodeCharUtil.isInRange(c, 2635, 2637) || c == '\u0a51' || UnicodeCharUtil.isInRange(c, 2672, 2673) || c == '\u0a75' || UnicodeCharUtil.isInRange(c, 2689, 2690) || c == '\u0abc' || UnicodeCharUtil.isInRange(c, 2753, 2757) || UnicodeCharUtil.isInRange(c, 2759, 2760) || c == '\u0acd' || UnicodeCharUtil.isInRange(c, 2786, 2787);
            }
            case 11: {
                return c == '\u0b01' || c == '\u0b3c' || c == '\u0b3f' || UnicodeCharUtil.isInRange(c, 2881, 2884) || c == '\u0b4d' || c == '\u0b56' || UnicodeCharUtil.isInRange(c, 2914, 2915) || c == '\u0b82' || c == '\u0bc0' || c == '\u0bcd';
            }
            case 12: {
                return UnicodeCharUtil.isInRange(c, 3134, 3136) || UnicodeCharUtil.isInRange(c, 3142, 3144) || UnicodeCharUtil.isInRange(c, 3146, 3149) || UnicodeCharUtil.isInRange(c, 3157, 3158) || UnicodeCharUtil.isInRange(c, 3170, 3171) || c == '\u0cbc' || c == '\u0cbf' || c == '\u0cc6' || UnicodeCharUtil.isInRange(c, 3276, 3277) || UnicodeCharUtil.isInRange(c, 3298, 3299);
            }
            case 13: {
                return UnicodeCharUtil.isInRange(c, 3393, 3396) || c == '\u0d4d' || UnicodeCharUtil.isInRange(c, 3426, 3427) || c == '\u0dca' || UnicodeCharUtil.isInRange(c, 3538, 3540) || c == '\u0dd6';
            }
            case 14: {
                return c == '\u0e31' || UnicodeCharUtil.isInRange(c, 3636, 3642) || UnicodeCharUtil.isInRange(c, 3655, 3662) || c == '\u0eb1' || UnicodeCharUtil.isInRange(c, 3764, 3641) || UnicodeCharUtil.isInRange(c, 3771, 3772) || UnicodeCharUtil.isInRange(c, 3784, 3789);
            }
            case 15: {
                return UnicodeCharUtil.isInRange(c, 3864, 3865) || c == '\u0f35' || c == '\u0f37' || c == '\u0f39' || UnicodeCharUtil.isInRange(c, 3953, 3966) || c == '\u0f3e' || c == '\u0f3f' || UnicodeCharUtil.isInRange(c, 3968, 3972) || UnicodeCharUtil.isInRange(c, 3974, 3975) || c == '\u0fc6';
            }
            case 16: {
                return UnicodeCharUtil.isInRange(c, 4141, 4144) || UnicodeCharUtil.isInRange(c, 4146, 4151) || UnicodeCharUtil.isInRange(c, 4153, 4154) || UnicodeCharUtil.isInRange(c, 4157, 4158) || UnicodeCharUtil.isInRange(c, 4184, 4185) || UnicodeCharUtil.isInRange(c, 4190, 4192) || UnicodeCharUtil.isInRange(c, 4209, 4212) || c == '\u1082' || UnicodeCharUtil.isInRange(c, 4229, 4230) || c == '\u108d';
            }
            case 19: {
                return c == '\u135f';
            }
            case 23: {
                return UnicodeCharUtil.isInRange(c, 5906, 5908) || UnicodeCharUtil.isInRange(c, 5938, 5940) || UnicodeCharUtil.isInRange(c, 5970, 5971) || UnicodeCharUtil.isInRange(c, 6002, 6003) || UnicodeCharUtil.isInRange(c, 6071, 6077) || c == '\u17c6' || UnicodeCharUtil.isInRange(c, 6089, 6099) || c == '\u17dd';
            }
            case 24: {
                return UnicodeCharUtil.isInRange(c, 6155, 6157);
            }
            case 25: {
                return UnicodeCharUtil.isInRange(c, 6432, 6434) || UnicodeCharUtil.isInRange(c, 6439, 6440) || c == '\u1932' || UnicodeCharUtil.isInRange(c, 6457, 6459);
            }
            case 26: {
                return UnicodeCharUtil.isInRange(c, 6679, 424);
            }
            case 27: {
                return UnicodeCharUtil.isInRange(c, 6912, 6915) || c == '\u1b34' || UnicodeCharUtil.isInRange(c, 6966, 6970) || c == '\u1b3c' || c == '\u1b42' || UnicodeCharUtil.isInRange(c, 7040, 7041) || UnicodeCharUtil.isInRange(c, 7074, 7077) || UnicodeCharUtil.isInRange(c, 7080, 7081);
            }
            case 28: {
                return UnicodeCharUtil.isInRange(c, 7212, 7219) || UnicodeCharUtil.isInRange(c, 7222, 7223);
            }
            case 29: {
                return UnicodeCharUtil.isInRange(c, 7616, 7679) || c == '\u20e1' || UnicodeCharUtil.isInRange(c, 8421, 8423) || UnicodeCharUtil.isInRange(c, 8424, 8432);
            }
            case 32: {
                return UnicodeCharUtil.isInRange(c, 8400, 8412) || c == '\u20e1' || UnicodeCharUtil.isInRange(c, 8421, 8423) || UnicodeCharUtil.isInRange(c, 8424, 8432);
            }
            case 48: {
                return UnicodeCharUtil.isInRange(c, 12330, 12335) || c == '\u3099' || c == '\u309a';
            }
        }
        return false;
    }
}

