/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import FCSalyzer.GUI.FACS_document;
import FCSalyzer.GUI.colorGradient;
import FCSalyzer.GUI.tableCellColorEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class gradientDialog {
    private JDialog theDialog;
    private FACS_document theDocument;
    private JTable gradientTable;
    private static final Object deleteValue = new Object();
    public static String CLOSE = "CLOSE";
    public static String ADD = "ADD";
    public static String DEL = "DEL";
    private ArrayList<TableModelListener> theListeners = new ArrayList();

    public gradientDialog(FACS_document theDocument) {
        this.theDocument = theDocument;
        this.theDialog = new JDialog();
        this.theDialog.setTitle("Color Gradients");
        this.theDialog.setModal(true);
        this.theDialog.setLayout(new BorderLayout());
        this.gradientTable = new JTable(new gradientTableModel());
        this.gradientTable.addMouseListener(new gradientTableMouse());
        tableCellColorEditor tC = new tableCellColorEditor();
        this.gradientTable.getColumn("#1").setCellEditor(tC);
        this.gradientTable.getColumn("#2").setCellEditor(tC);
        this.gradientTable.getColumn("#3").setCellEditor(tC);
        this.gradientTable.getColumn("#4").setCellEditor(tC);
        this.gradientTable.getColumn("#5").setCellEditor(tC);
        this.gradientTable.getColumn("#6").setCellEditor(tC);
        this.gradientTable.getColumn("#7").setCellEditor(tC);
        this.theDialog.add((Component)new JScrollPane(this.gradientTable), "Center");
        buttonListener bL = new buttonListener(this.gradientTable);
        JButton closeB = new JButton("Close");
        closeB.setActionCommand(CLOSE);
        closeB.addActionListener(bL);
        JButton addB = new JButton("Add gradient");
        addB.setActionCommand(ADD);
        addB.addActionListener(bL);
        JButton delB = new JButton("Delete gradient");
        delB.setActionCommand(DEL);
        delB.addActionListener(bL);
        JPanel buttonHolder = new JPanel();
        buttonHolder.add(addB);
        buttonHolder.add(delB);
        buttonHolder.add(closeB);
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new GridLayout(2, 1));
        JLabel hint = new JLabel();
        hint.setText("<html><i>To remove a color from the gradient, perform a mouse popup-trigger (right-mouse click) on it</i></html>");
        lowerPanel.add(hint);
        lowerPanel.add(buttonHolder);
        this.theDialog.add((Component)lowerPanel, "South");
        this.theDialog.setDefaultCloseOperation(2);
        this.theDialog.setLocationByPlatform(true);
        this.theDialog.setSize(600, 200);
    }

    public void showDialog() {
        this.theDialog.setVisible(true);
    }

    private class gradientTableMouse
    implements MouseListener {
        private gradientTableMouse() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() || e.isShiftDown()) {
                int row = gradientDialog.this.gradientTable.rowAtPoint(e.getPoint());
                int col = gradientDialog.this.gradientTable.columnAtPoint(e.getPoint());
                gradientDialog.this.gradientTable.getModel().setValueAt(deleteValue, row, col);
                e.consume();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class buttonListener
    implements ActionListener {
        private TableModel theTabM;
        private JTable theTable;

        public buttonListener(JTable theT) {
            this.theTable = theT;
            this.theTabM = theT.getModel();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(CLOSE)) {
                gradientDialog.this.theDialog.setVisible(false);
                gradientDialog.this.theDialog.dispose();
                return;
            }
            if (e.getActionCommand().equals(ADD)) {
                colorGradient colG = new colorGradient("New Gradient", Color.BLACK, Color.WHITE, colorGradient.gradientSteps);
                gradientDialog.this.theDocument.addColorGradient(colG);
                for (TableModelListener theListener : gradientDialog.this.theListeners) {
                    theListener.tableChanged(new TableModelEvent(this.theTabM));
                }
                return;
            }
            if (e.getActionCommand().equals(DEL)) {
                int sel = this.theTable.getSelectedRow();
                if (sel != -1) {
                    gradientDialog.this.theDocument.removeColorGradient(sel);
                    for (TableModelListener theListener : gradientDialog.this.theListeners) {
                        theListener.tableChanged(new TableModelEvent(this.theTabM));
                    }
                }
                return;
            }
        }
    }

    private class gradientTableModel
    implements TableModel {
        private gradientTableModel() {
        }

        @Override
        public int getRowCount() {
            return gradientDialog.this.theDocument.getColorGradientCount();
        }

        @Override
        public int getColumnCount() {
            return 9;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ((gradientDialog)gradientDialog.this).theDocument.getColorGradient((int)rowIndex).description;
            }
            if (columnIndex == 1) {
                BufferedImage buf = new BufferedImage(colorGradient.gradientSteps + 2, 10, 1);
                for (int i = 0; i < buf.getWidth(); ++i) {
                    for (int k = 0; k < buf.getHeight(); ++k) {
                        buf.setRGB(i, k, Color.black.getRGB());
                    }
                }
                int[] grad = gradientDialog.this.theDocument.getGradient(rowIndex);
                for (int i = 0; i < grad.length; ++i) {
                    for (int k = 0; k < 8; ++k) {
                        buf.setRGB(i + 1, k + 1, grad[i]);
                    }
                }
                return new ImageIcon(buf);
            }
            int mile = columnIndex - 2;
            int[] milestones = ((gradientDialog)gradientDialog.this).theDocument.getColorGradient((int)rowIndex).gradientMilestones;
            if (mile < milestones.length) {
                BufferedImage buf = new BufferedImage(10, 10, 1);
                for (int i = 0; i < 10; ++i) {
                    for (int k = 0; k < 10; ++k) {
                        buf.setRGB(i, k, Color.black.getRGB());
                    }
                }
                int curr = milestones[mile];
                for (int i = 0; i < 8; ++i) {
                    for (int k = 0; k < 8; ++k) {
                        buf.setRGB(i + 1, k + 1, curr);
                    }
                }
                return new ImageIcon(buf);
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            return ImageIcon.class;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Description";
            }
            if (column == 1) {
                return "Gradient";
            }
            return "#" + (column - 1);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue == deleteValue) {
                if (columnIndex < 2) {
                    return;
                }
                gradientDialog.this.theDocument.getColorGradient(rowIndex).deleteMilestone(columnIndex - 2);
                for (TableModelListener theListener : gradientDialog.this.theListeners) {
                    theListener.tableChanged(new TableModelEvent(this));
                }
                gradientDialog.this.theDocument.refreshView(gradientDialog.this.theDocument.getColorGradient(rowIndex));
                return;
            }
            if (columnIndex == 0) {
                ((gradientDialog)gradientDialog.this).theDocument.getColorGradient((int)rowIndex).description = aValue.toString();
            }
            if (columnIndex == 1) {
                return;
            }
            if (columnIndex > 1 && aValue instanceof Integer) {
                int newColor = (Integer)aValue;
                gradientDialog.this.theDocument.getColorGradient(rowIndex).setMilestone(columnIndex - 2, newColor);
                for (TableModelListener theListener : gradientDialog.this.theListeners) {
                    theListener.tableChanged(new TableModelEvent(this));
                }
                gradientDialog.this.theDocument.refreshView(gradientDialog.this.theDocument.getColorGradient(rowIndex));
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            gradientDialog.this.theListeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            gradientDialog.this.theListeners.remove(l);
        }
    }
}

