/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.generate.program;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.encog.app.generate.program.EncogArgType;
import org.encog.app.generate.program.EncogGenProgram;
import org.encog.app.generate.program.EncogProgramArg;
import org.encog.app.generate.program.EncogTreeNode;
import org.encog.app.generate.program.NodeType;

public class EncogProgramNode
extends EncogTreeNode {
    private final List<EncogProgramArg> args = new ArrayList<EncogProgramArg>();
    private final NodeType type;
    private final String name;

    public EncogProgramNode(EncogGenProgram theProgram, EncogTreeNode theParent, NodeType theNodeType, String theName) {
        super(theProgram, theParent);
        this.type = theNodeType;
        this.name = theName;
    }

    public void addArg(double argValue) {
        EncogProgramArg arg = new EncogProgramArg(argValue);
        this.args.add(arg);
    }

    public void addArg(int argValue) {
        EncogProgramArg arg = new EncogProgramArg(argValue);
        this.args.add(arg);
    }

    public void addArg(Object argValue) {
        EncogProgramArg arg = new EncogProgramArg(argValue);
        this.args.add(arg);
    }

    public void addArg(String argValue) {
        EncogProgramArg arg = new EncogProgramArg(argValue);
        this.args.add(arg);
    }

    public EncogProgramNode createArray(String name, double[] a) {
        EncogProgramNode node = new EncogProgramNode(this.getProgram(), this, NodeType.InitArray, name);
        node.addArg(a);
        this.getChildren().add(node);
        return node;
    }

    public EncogProgramNode createFunction(String theName) {
        EncogProgramNode node = new EncogProgramNode(this.getProgram(), this, NodeType.StaticFunction, theName);
        this.getChildren().add(node);
        return node;
    }

    public EncogProgramNode createFunctionCall(EncogProgramNode funct, String returnType, String returnVariable) {
        EncogProgramNode node = new EncogProgramNode(this.getProgram(), this, NodeType.FunctionCall, funct.getName());
        node.addArg(returnType);
        node.addArg(returnVariable);
        this.getChildren().add(node);
        return node;
    }

    public EncogProgramNode createFunctionCall(String name, String returnType, String returnVariable) {
        EncogProgramNode node = new EncogProgramNode(this.getProgram(), this, NodeType.FunctionCall, name);
        node.addArg(returnType);
        node.addArg(returnVariable);
        this.getChildren().add(node);
        return node;
    }

    public EncogProgramNode createMainFunction() {
        EncogProgramNode node = new EncogProgramNode(this.getProgram(), this, NodeType.MainFunction, null);
        this.getChildren().add(node);
        return node;
    }

    public EncogProgramNode createNetworkFunction(String name, File method) {
        EncogProgramNode node = new EncogProgramNode(this.getProgram(), this, NodeType.CreateNetwork, name);
        node.addArg(method);
        this.getChildren().add(node);
        return node;
    }

    public void defineConst(EncogArgType type, String name, String value) {
        EncogProgramNode node = new EncogProgramNode(this.getProgram(), this, NodeType.Const, name);
        node.addArg(value);
        node.addArg(type.toString());
        this.getChildren().add(node);
    }

    public EncogProgramNode embedTraining(File data) {
        EncogProgramNode node = new EncogProgramNode(this.getProgram(), this, NodeType.EmbedTraining, "");
        node.addArg(data);
        this.getChildren().add(node);
        return node;
    }

    public EncogProgramNode generateLoadTraining(File data) {
        EncogProgramNode node = new EncogProgramNode(this.getProgram(), this, NodeType.LoadTraining, "");
        node.addArg(data);
        this.getChildren().add(node);
        return node;
    }

    public List<EncogProgramArg> getArgs() {
        return this.args;
    }

    public String getName() {
        return this.name;
    }

    public NodeType getType() {
        return this.type;
    }
}

