/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.commands;

import java.io.File;
import java.util.ArrayList;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.commands.Cmd;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.util.CSVHeaders;
import org.encog.util.csv.CSVFormat;
import org.encog.util.logging.EncogLogging;
import org.encog.util.simple.EncogUtility;

public class CmdGenerate
extends Cmd {
    public static final String COMMAND_NAME = "GENERATE";

    public CmdGenerate(EncogAnalyst analyst) {
        super(analyst);
    }

    private int[] determineIdealFields(CSVHeaders headerList) {
        String type = this.getProp().getPropertyString("ML:CONFIG_type");
        if (type.equals("som")) {
            int[] result = new int[]{};
            return result;
        }
        ArrayList<Integer> fields = new ArrayList<Integer>();
        for (int currentIndex = 0; currentIndex < headerList.size(); ++currentIndex) {
            String baseName = headerList.getBaseHeader(currentIndex);
            int slice = headerList.getSlice(currentIndex);
            AnalystField field = this.getAnalyst().getScript().findNormalizedField(baseName, slice);
            if (field == null || !field.isOutput()) continue;
            fields.add(currentIndex);
        }
        int[] result = new int[fields.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)fields.get(i);
        }
        return result;
    }

    private int[] determineInputFields(CSVHeaders headerList) {
        ArrayList<Integer> fields = new ArrayList<Integer>();
        for (int currentIndex = 0; currentIndex < headerList.size(); ++currentIndex) {
            String baseName = headerList.getBaseHeader(currentIndex);
            int slice = headerList.getSlice(currentIndex);
            AnalystField field = this.getAnalyst().getScript().findNormalizedField(baseName, slice);
            if (field == null || !field.isInput()) continue;
            fields.add(currentIndex);
        }
        int[] result = new int[fields.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)fields.get(i);
        }
        return result;
    }

    @Override
    public boolean executeCommand(String args) {
        String sourceID = this.getProp().getPropertyString("GENERATE:CONFIG_sourceFile");
        String targetID = this.getProp().getPropertyString("GENERATE:CONFIG_targetFile");
        CSVFormat format = this.getAnalyst().getScript().determineFormat();
        EncogLogging.log(0, "Beginning generate");
        EncogLogging.log(0, "source file:" + sourceID);
        EncogLogging.log(0, "target file:" + targetID);
        File sourceFile = this.getScript().resolveFilename(sourceID);
        File targetFile = this.getScript().resolveFilename(targetID);
        this.getScript().markGenerated(targetID);
        boolean headers = this.getScript().expectInputHeaders(sourceID);
        CSVHeaders headerList = new CSVHeaders(sourceFile, headers, format);
        int[] input = this.determineInputFields(headerList);
        int[] ideal = this.determineIdealFields(headerList);
        EncogUtility.convertCSV2Binary(sourceFile, format, targetFile, input, ideal, headers);
        return false;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }
}

