/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.ThreadInterruptedException;

final class DocumentsWriterPerThreadPool {
    private final ThreadState[] threadStates;
    private volatile int numThreadStatesActive;
    private final ThreadState[] freeList;
    private int freeCount;

    DocumentsWriterPerThreadPool(int maxNumThreadStates) {
        if (maxNumThreadStates < 1) {
            throw new IllegalArgumentException("maxNumThreadStates must be >= 1 but was: " + maxNumThreadStates);
        }
        this.threadStates = new ThreadState[maxNumThreadStates];
        this.numThreadStatesActive = 0;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i] = new ThreadState(null);
        }
        this.freeList = new ThreadState[maxNumThreadStates];
    }

    int getMaxThreadStates() {
        return this.threadStates.length;
    }

    int getActiveThreadState() {
        return this.numThreadStatesActive;
    }

    private ThreadState newThreadState() {
        assert (this.numThreadStatesActive < this.threadStates.length);
        ThreadState threadState = this.threadStates[this.numThreadStatesActive];
        threadState.lock();
        boolean unlock = true;
        try {
            if (threadState.isActive()) {
                ++this.numThreadStatesActive;
                assert (threadState.dwpt == null);
                unlock = false;
                ThreadState threadState2 = threadState;
                return threadState2;
            }
            assert (this.assertUnreleasedThreadStatesInactive());
            throw new AlreadyClosedException("this IndexWriter is closed");
        }
        finally {
            if (unlock) {
                threadState.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean assertUnreleasedThreadStatesInactive() {
        for (int i = this.numThreadStatesActive; i < this.threadStates.length; ++i) {
            assert (this.threadStates[i].tryLock()) : "unreleased threadstate should not be locked";
            try {
                if ($assertionsDisabled || !this.threadStates[i].isInitialized()) continue;
                throw new AssertionError((Object)"expected unreleased thread state to be inactive");
            }
            finally {
                this.threadStates[i].unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deactivateUnreleasedStates() {
        for (int i = this.numThreadStatesActive; i < this.threadStates.length; ++i) {
            ThreadState threadState = this.threadStates[i];
            threadState.lock();
            try {
                threadState.deactivate();
                continue;
            }
            finally {
                threadState.unlock();
            }
        }
        this.notifyAll();
    }

    DocumentsWriterPerThread reset(ThreadState threadState, boolean closed) {
        assert (threadState.isHeldByCurrentThread());
        DocumentsWriterPerThread dwpt = threadState.dwpt;
        if (!closed) {
            threadState.reset();
        } else {
            threadState.deactivate();
        }
        return dwpt;
    }

    void recycle(DocumentsWriterPerThread dwpt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadState getAndLock(Thread requestingThread, DocumentsWriter documentsWriter) {
        ThreadState threadState = null;
        DocumentsWriterPerThreadPool documentsWriterPerThreadPool = this;
        synchronized (documentsWriterPerThreadPool) {
            while (true) {
                if (this.freeCount > 0) {
                    threadState = this.freeList[this.freeCount - 1];
                    if (threadState.dwpt == null) {
                        for (int i = 0; i < this.freeCount; ++i) {
                            if (this.freeList[i].dwpt == null) continue;
                            ThreadState ts = this.freeList[i];
                            this.freeList[i] = threadState;
                            threadState = ts;
                            break;
                        }
                    }
                    --this.freeCount;
                    break;
                }
                if (this.numThreadStatesActive < this.threadStates.length) {
                    return this.newThreadState();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw new ThreadInterruptedException(ie);
                }
            }
        }
        threadState.lock();
        return threadState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(ThreadState state) {
        state.unlock();
        DocumentsWriterPerThreadPool documentsWriterPerThreadPool = this;
        synchronized (documentsWriterPerThreadPool) {
            assert (this.freeCount < this.freeList.length);
            this.freeList[this.freeCount++] = state;
            this.notifyAll();
        }
    }

    ThreadState getThreadState(int ord) {
        return this.threadStates[ord];
    }

    ThreadState minContendedThreadState() {
        ThreadState minThreadState = null;
        int limit = this.numThreadStatesActive;
        for (int i = 0; i < limit; ++i) {
            ThreadState state = this.threadStates[i];
            if (minThreadState != null && state.getQueueLength() >= minThreadState.getQueueLength()) continue;
            minThreadState = state;
        }
        return minThreadState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numDeactivatedThreadStates() {
        int count = 0;
        for (int i = 0; i < this.threadStates.length; ++i) {
            ThreadState threadState = this.threadStates[i];
            threadState.lock();
            try {
                if (threadState.isActive) continue;
                ++count;
                continue;
            }
            finally {
                threadState.unlock();
            }
        }
        return count;
    }

    void deactivateThreadState(ThreadState threadState) {
        assert (threadState.isActive());
        threadState.deactivate();
    }

    static final class ThreadState
    extends ReentrantLock {
        DocumentsWriterPerThread dwpt;
        volatile boolean flushPending = false;
        long bytesUsed = 0L;
        private boolean isActive = true;

        ThreadState(DocumentsWriterPerThread dpwt) {
            this.dwpt = dpwt;
        }

        private void deactivate() {
            assert (this.isHeldByCurrentThread());
            this.isActive = false;
            this.reset();
        }

        private void reset() {
            assert (this.isHeldByCurrentThread());
            this.dwpt = null;
            this.bytesUsed = 0L;
            this.flushPending = false;
        }

        boolean isActive() {
            assert (this.isHeldByCurrentThread());
            return this.isActive;
        }

        boolean isInitialized() {
            assert (this.isHeldByCurrentThread());
            return this.isActive() && this.dwpt != null;
        }

        public long getBytesUsedPerThread() {
            assert (this.isHeldByCurrentThread());
            return this.bytesUsed;
        }

        public DocumentsWriterPerThread getDocumentsWriterPerThread() {
            assert (this.isHeldByCurrentThread());
            return this.dwpt;
        }

        public boolean isFlushPending() {
            return this.flushPending;
        }
    }
}

