/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.renderer.video;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.renderer.VideoRenderer;
import javax.swing.SwingUtilities;
import org.jitsi.impl.neomedia.jmfext.media.renderer.AbstractRenderer;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;
import org.jitsi.util.swing.VideoLayout;

public class JAWTRenderer
extends AbstractRenderer<VideoFormat>
implements VideoRenderer {
    private static final int DEFAULT_COMPONENT_HEIGHT_OR_WIDTH = 16;
    private static final Logger logger = Logger.getLogger(JAWTRenderer.class);
    private static final String PLUGIN_NAME = "JAWT Renderer";
    private static final Format[] SUPPORTED_INPUT_FORMATS = new Format[]{OSUtils.IS_LINUX ? new YUVFormat(null, -1, Format.intArray, -1.0f, 2, -1, -1, -1, -1, -1) : (OSUtils.IS_ANDROID ? new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000) : new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255))};
    private Component component;
    private long handle = 0L;
    private int height = 0;
    private final Runnable reflectInputFormatOnComponentInEventDispatchThread = new Runnable(){

        @Override
        public void run() {
            JAWTRenderer.this.reflectInputFormatOnComponentInEventDispatchThread();
        }
    };
    private int width = 0;

    static native void addNotify(long var0, Component var2);

    private static native void close(long var0, Component var2);

    private static native long open(Component var0) throws ResourceUnavailableException;

    static native boolean paint(long var0, Component var2, Graphics var3, int var4);

    static native boolean process(long var0, Component var2, int[] var3, int var4, int var5, int var6, int var7);

    static native void removeNotify(long var0, Component var2);

    private static native String sysctlbyname(String var0);

    public synchronized void close() {
        if (this.handle != 0L) {
            JAWTRenderer.close(this.handle, this.component);
            this.handle = 0L;
        }
    }

    public Rectangle getBounds() {
        return null;
    }

    public synchronized Component getComponent() {
        if (this.component == null) {
            StringBuilder componentClassName = new StringBuilder();
            componentClassName.append("org.jitsi.impl.neomedia.jmfext.media.renderer.video.JAWTRenderer");
            if (OSUtils.IS_ANDROID) {
                componentClassName.append("Android");
            }
            componentClassName.append("VideoComponent");
            ReflectiveOperationException reflectiveOperationException = null;
            try {
                Class<?> componentClass = Class.forName(componentClassName.toString());
                Constructor<?> componentConstructor = componentClass.getConstructor(JAWTRenderer.class);
                this.component = (Component)componentConstructor.newInstance(this);
            }
            catch (ClassNotFoundException cnfe) {
                reflectiveOperationException = cnfe;
            }
            catch (IllegalAccessException iae) {
                reflectiveOperationException = iae;
            }
            catch (InstantiationException ie) {
                reflectiveOperationException = ie;
            }
            catch (InvocationTargetException ite) {
                reflectiveOperationException = ite;
            }
            catch (NoSuchMethodException nsme) {
                reflectiveOperationException = nsme;
            }
            if (reflectiveOperationException != null) {
                throw new RuntimeException(reflectiveOperationException);
            }
            this.component.setSize(16, 16);
            this.reflectInputFormatOnComponentInEventDispatchThread();
        }
        return this.component;
    }

    public long getHandle() {
        return this.handle;
    }

    public Object getHandleLock() {
        return this;
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Format[] getSupportedInputFormats() {
        return (Format[])SUPPORTED_INPUT_FORMATS.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceUnavailableException {
        Component component;
        boolean addNotify;
        JAWTRenderer jAWTRenderer = this;
        synchronized (jAWTRenderer) {
            if (this.handle == 0L) {
                addNotify = this.component != null && this.component.getParent() != null;
                component = this.getComponent();
                this.handle = JAWTRenderer.open(component);
                if (this.handle == 0L) {
                    throw new ResourceUnavailableException("Failed to open the native JAWTRenderer.");
                }
            } else {
                addNotify = false;
                component = null;
            }
        }
        if (addNotify) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    component.addNotify();
                }
            });
        }
    }

    public synchronized int process(Buffer buffer) {
        Component component;
        boolean repaint;
        if (buffer.isDiscard()) {
            return 0;
        }
        int bufferLength = buffer.getLength();
        if (bufferLength == 0) {
            return 0;
        }
        Format format = buffer.getFormat();
        if (format != null && format != this.inputFormat && !format.equals((Object)this.inputFormat) && this.setInputFormat(format) == null) {
            return 1;
        }
        if (this.handle == 0L) {
            return 1;
        }
        Dimension size = null;
        if (format != null) {
            size = ((VideoFormat)format).getSize();
        }
        if (size == null && (size = ((VideoFormat)this.inputFormat).getSize()) == null) {
            return 1;
        }
        if (size.width >= 4 && size.height >= 4 && (repaint = JAWTRenderer.process(this.handle, component = this.getComponent(), (int[])buffer.getData(), buffer.getOffset(), bufferLength, size.width, size.height))) {
            component.repaint();
        }
        return 0;
    }

    private void reflectInputFormatOnComponent() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.reflectInputFormatOnComponentInEventDispatchThread();
        } else {
            SwingUtilities.invokeLater(this.reflectInputFormatOnComponentInEventDispatchThread);
        }
    }

    private void reflectInputFormatOnComponentInEventDispatchThread() {
        if (this.component != null && this.width > 0 && this.height > 0) {
            Dimension prefSize = this.component.getPreferredSize();
            if (prefSize == null || prefSize.width < 1 || prefSize.height < 1 || !VideoLayout.areAspectRatiosEqual(prefSize, this.width, this.height) || prefSize.width < this.width || prefSize.height < this.height) {
                this.component.setPreferredSize(new Dimension(this.width, this.height));
            }
            if (this.component.isPreferredSizeSet() && this.component.getParent() == null) {
                Dimension size = this.component.getSize();
                prefSize = this.component.getPreferredSize();
                if (size.width < 1 || size.height < 1 || !VideoLayout.areAspectRatiosEqual(size, prefSize.width, prefSize.height)) {
                    this.component.setSize(prefSize.width, prefSize.height);
                }
            }
        }
    }

    public void setBounds(Rectangle bounds) {
    }

    public boolean setComponent(Component component) {
        return false;
    }

    @Override
    public synchronized Format setInputFormat(Format format) {
        Dimension size;
        VideoFormat oldInputFormat = (VideoFormat)this.inputFormat;
        Format newInputFormat = super.setInputFormat(format);
        if (oldInputFormat == this.inputFormat) {
            return newInputFormat;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClass().getName() + " 0x" + Integer.toHexString(this.hashCode()) + " set to input in " + this.inputFormat);
        }
        if ((size = ((VideoFormat)this.inputFormat).getSize()) == null) {
            this.height = 0;
            this.width = 0;
        } else {
            this.width = size.width;
            this.height = size.height;
        }
        this.reflectInputFormatOnComponent();
        return newInputFormat;
    }

    public void start() {
    }

    public void stop() {
    }

    static {
        System.loadLibrary("jnawtrenderer");
    }
}

