/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.audiosilence;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPushBufferCaptureDevice;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPushBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;
import org.jitsi.util.Logger;

public class DataSource
extends AbstractPushBufferCaptureDevice {
    private static final Logger logger = Logger.getLogger(DataSource.class);
    private static final boolean CLOCK_ONLY = true;
    private static final long CLOCK_TICK_INTERVAL = 20L;
    public static final Format[] SUPPORTED_FORMATS = new Format[]{new AudioFormat("LINEAR", 48000.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};

    protected AudioSilenceStream createStream(int streamIndex, FormatControl formatControl) {
        return new AudioSilenceStream(this, formatControl);
    }

    @Override
    protected Format[] getSupportedFormats(int streamIndex) {
        return (Format[])SUPPORTED_FORMATS.clone();
    }

    private static class AudioSilenceStream
    extends AbstractPushBufferStream<DataSource>
    implements Runnable {
        private boolean started;
        private Thread thread;

        public AudioSilenceStream(DataSource dataSource, FormatControl formatControl) {
            super(dataSource, formatControl);
        }

        public void read(Buffer buffer) throws IOException {
            buffer.setLength(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AbstractAudioRenderer.useAudioThreadPriority();
                long tickTime = System.currentTimeMillis();
                while (true) {
                    BufferTransferHandler transferHandler;
                    long sleepInterval;
                    boolean tick;
                    boolean bl = tick = (sleepInterval = tickTime - System.currentTimeMillis()) <= 0L;
                    if (tick) {
                        tickTime += 20L;
                    } else {
                        try {
                            Thread.sleep(sleepInterval);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    AudioSilenceStream ie = this;
                    synchronized (ie) {
                        if (this.thread != Thread.currentThread() || !this.started) {
                            break;
                        }
                    }
                    if (!tick || (transferHandler = this.transferHandler) == null) continue;
                    try {
                        transferHandler.transferData((PushBufferStream)this);
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.error(t, t);
                    }
                }
            }
            finally {
                AudioSilenceStream audioSilenceStream = this;
                synchronized (audioSilenceStream) {
                    if (this.thread == Thread.currentThread()) {
                        this.thread = null;
                        this.started = false;
                        this.notifyAll();
                    }
                }
            }
        }

        @Override
        public synchronized void start() throws IOException {
            if (this.thread == null) {
                String className = this.getClass().getName();
                this.thread = new Thread((Runnable)this, className);
                this.thread.setDaemon(true);
                boolean started = false;
                try {
                    this.thread.start();
                    started = true;
                }
                finally {
                    this.started = started;
                    if (!started) {
                        this.thread = null;
                        this.notifyAll();
                        throw new IOException("Failed to start " + className);
                    }
                }
            }
        }

        @Override
        public synchronized void stop() throws IOException {
            this.started = false;
            this.notifyAll();
            boolean interrupted = false;
            while (this.thread != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

