/*
 * Decompiled with CFR 0.152.
 */
package mork;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mork.Alias;
import mork.Aliases;
import mork.Dict;
import mork.MorkDocument;
import mork.Row;
import mork.Table;

public class MorkWriter {
    MorkDocument currentDocument;
    OutputStreamWriter writer;
    OutputStyle outputStyle = OutputStyle.formatted;
    int indentation = 0;
    int tabSize = 2;
    public static final String zm_Magic = "//<!-- <mdb:mork:z v=\"1.4\"/> -->";
    public static final String zm_LineEnd = "\n";
    public static final String zm_Space = " ";

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public OutputStyle getOutputStyle() {
        return this.outputStyle;
    }

    public void setOutputStyle(OutputStyle outputStyle) {
        this.outputStyle = outputStyle;
    }

    protected void indent() {
        this.indentation += this.tabSize;
    }

    protected void unindent() {
        this.indentation -= this.tabSize;
    }

    public OutputStreamWriter getWriter() {
        return this.writer;
    }

    public void setWriter(OutputStreamWriter writer) {
        this.writer = writer;
    }

    public MorkDocument getCurrentDocument() {
        return this.currentDocument;
    }

    public void setCurrentDocument(MorkDocument currentDocument) {
        this.currentDocument = currentDocument;
    }

    public MorkWriter(MorkDocument document) {
        this.currentDocument = document;
    }

    public void writeIndent() throws IOException {
        this.writer.append(zm_LineEnd);
        switch (this.outputStyle) {
            case formatted: {
                int i = 0;
                while (i < this.indentation) {
                    this.writer.append(zm_Space);
                    ++i;
                }
                break;
            }
        }
    }

    public void write(File file) {
        try {
            this.write(new FileWriter(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(new OutputStreamWriter(outputStream));
    }

    public void write(OutputStreamWriter outputStreamWriter) throws IOException {
        this.writer = outputStreamWriter;
        this.writeDocument();
    }

    public void writeDocument() throws IOException {
        assert (this.currentDocument != null);
        assert (this.writer != null);
        this.writeHeader();
        this.writeContents();
        this.writer.close();
    }

    protected void writeContents() throws IOException {
        this.writeContent();
        this.writeGroup();
    }

    protected void writeContent() throws IOException {
        List<Dict> dicts = this.currentDocument.getDicts();
        List<Table> tables = this.currentDocument.getTables();
        int i = 0;
        while (i < Math.max(dicts.size(), tables.size())) {
            if (i < dicts.size()) {
                this.writeDict(dicts.get(i));
            }
            if (i < tables.size()) {
                this.writeTable(tables.get(i));
            }
            ++i;
        }
    }

    protected void writeTable(Table table) throws IOException {
        this.indent();
        this.writeIndent();
        this.writer.append('{');
        this.writeId(table.getTableId());
        this.writer.append(':');
        this.indent();
        this.writeIndent();
        List<Row> rows = table.getRows();
        for (Row row : rows) {
            this.writeRow(row);
        }
        this.unindent();
        this.writeIndent();
        this.writer.append('}');
        this.unindent();
    }

    protected void writeRow(Row row) throws IOException {
        this.indent();
        this.writeIndent();
        this.writer.append('[');
        this.writeId(row.getRowId());
        Map<String, Alias> aliases = row.getAliases();
        for (String id : aliases.keySet()) {
            this.writeRowItem(id, aliases.get(id));
        }
        this.writer.append(']');
        this.unindent();
    }

    protected void writeRowItem(String name, Alias alias) throws IOException {
        this.writer.append('(');
        if (alias.getRefId().startsWith("^")) {
            this.writer.append(alias.getRefId());
        } else {
            this.writeName(name);
        }
        if (alias.getValueRef() != null) {
            this.writer.append(alias.getValueRef());
        } else {
            this.writeValue(alias.getValue());
        }
        this.writer.append(')');
    }

    protected void writeDict(Dict dict) throws IOException {
        this.indent();
        this.writeIndent();
        this.writer.append('<');
        this.indent();
        Aliases aliases = dict.getAliases();
        Set<String> keys = aliases.getKeySet();
        for (String key : keys) {
            this.writeAlias(key, aliases.getAlias(key));
        }
        this.unindent();
        this.writeIndent();
        this.writer.append('>');
        this.unindent();
    }

    protected void writeAlias(String key, Alias alias) throws IOException {
        this.writeIndent();
        this.writer.append('(');
        this.writeId(key);
        this.writeValue(alias.getValue());
        this.writer.append(')');
    }

    private void writeValue(String value) throws IOException {
        this.writer.append('=');
        this.writer.append(value);
    }

    protected void writeName(String name) throws IOException {
        this.writer.append(name);
    }

    private void writeId(String key) throws IOException {
        this.writer.append(key);
    }

    protected void writeGroup() {
    }

    protected void writeHeader() throws IOException {
        this.writer.append(zm_Magic);
        this.writer.append(zm_LineEnd);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputStyle {
        terse,
        humandReadable,
        formatted;

    }
}

