/*
 * Decompiled with CFR 0.152.
 */
package mork;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mork.Aliases;
import mork.ExceptionManager;
import mork.ScopeTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dict {
    public static final List<Dict> EMPTY_LIST = new ArrayList<Dict>(0);
    private String scopeName;
    private String scopeValue;
    private Aliases aliases;

    public Aliases getAliases() {
        return this.aliases;
    }

    public Dict(String dictString) {
        this(dictString, EMPTY_LIST);
    }

    public Dict(String dictString, List<Dict> dicts) {
        Pattern scopePattern;
        Matcher scopeMatcher;
        Pattern pattern = Pattern.compile("\\s*<\\s*(<\\(?.*\\)?>)?[\\s\\n\\r]*(.*)>[\\s\\r\\n]*", 40);
        Matcher matcher = pattern.matcher(dictString);
        if (!matcher.find()) {
            throw new RuntimeException("RegEx does not match: " + dictString);
        }
        String scopeDef = matcher.group(1);
        String aliasesDef = matcher.group(2);
        if (scopeDef != null && (scopeMatcher = (scopePattern = Pattern.compile("<\\(?(.*)=([^\\)])\\)?>")).matcher(scopeDef)).matches()) {
            this.scopeName = scopeMatcher.group(1);
            this.scopeValue = scopeMatcher.group(2);
        }
        this.aliases = new Aliases(aliasesDef, dicts);
    }

    public ScopeTypes getDefaultScope() {
        if (this.scopeValue != null && this.scopeValue.toLowerCase(Locale.getDefault()).startsWith("c")) {
            return ScopeTypes.COLUMN_SCOPE;
        }
        return ScopeTypes.ATOM_SCOPE;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public String getScopeValue() {
        return this.scopeValue;
    }

    public String getValue(String id) {
        return this.aliases.getValue(id);
    }

    public int getAliasCount() {
        return this.aliases.count();
    }

    public String dereference(String id) {
        if (!id.startsWith("^")) {
            throw new RuntimeException("dereference() must be called with a reference id including the prefix '^'");
        }
        String oid = id.substring(1);
        String value = this.getValue(oid);
        return value;
    }

    public static String dereference(String id, List<Dict> dicts, ScopeTypes scope) {
        if (dicts.isEmpty()) {
            return ExceptionManager.createString(id, new RuntimeException("Cannot dereference IDs without dictionaries"));
        }
        String dereference = null;
        for (Dict dict : dicts) {
            if (dict.getDefaultScope() != scope || (dereference = dict.dereference(id)) == null) continue;
            return dereference;
        }
        return ExceptionManager.createString(id, new RuntimeException("Dictionary could not dereference key: " + id + " in scope " + (Object)((Object)scope)));
    }
}

